/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.internal.network.codec;

import com.hedera.node.internal.network.HelidonGrpcConfig;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class HelidonGrpcConfigJsonCodec
implements JsonCodec<HelidonGrpcConfig> {
    @NonNull
    public HelidonGrpcConfig parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Boolean temp_abort_poll_time_expired = null;
            String temp_heartbeat_period = null;
            Integer temp_init_buffer_size = null;
            String temp_name = null;
            String temp_poll_wait_time = null;
            block16: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "abortPollTimeExpired": {
                        temp_abort_poll_time_expired = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block16;
                    }
                    case "heartbeatPeriod": {
                        temp_heartbeat_period = JsonTools.unescape((String)JsonTools.checkSize((String)"heartbeat_period", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block16;
                    }
                    case "initBufferSize": {
                        temp_init_buffer_size = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block16;
                    }
                    case "name": {
                        temp_name = JsonTools.unescape((String)JsonTools.checkSize((String)"name", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block16;
                    }
                    case "pollWaitTime": {
                        temp_poll_wait_time = JsonTools.unescape((String)JsonTools.checkSize((String)"poll_wait_time", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block16;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new HelidonGrpcConfig(temp_abort_poll_time_expired, temp_heartbeat_period, temp_init_buffer_size, temp_name, temp_poll_wait_time);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull HelidonGrpcConfig data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.abortPollTimeExpired() != null) {
            fieldLines.add(JsonTools.field((String)"abortPollTimeExpired", (Boolean)data.abortPollTimeExpired()));
        }
        if (data.heartbeatPeriod() != null) {
            fieldLines.add(JsonTools.field((String)"heartbeatPeriod", (String)data.heartbeatPeriod()));
        }
        if (data.initBufferSize() != null) {
            fieldLines.add(JsonTools.field((String)"initBufferSize", (Integer)data.initBufferSize()));
        }
        if (data.name() != null) {
            fieldLines.add(JsonTools.field((String)"name", (String)data.name()));
        }
        if (data.pollWaitTime() != null) {
            fieldLines.add(JsonTools.field((String)"pollWaitTime", (String)data.pollWaitTime()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

