/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hiero.block.api.BlockEnd;
import org.hiero.block.api.BlockItemSet;
import org.hiero.block.api.codec.PublishStreamRequestJsonCodec;
import org.hiero.block.api.codec.PublishStreamRequestProtoCodec;
import org.hiero.block.api.schema.PublishStreamRequestSchema;

public final class PublishStreamRequest {
    public static final Codec<PublishStreamRequest> PROTOBUF = new PublishStreamRequestProtoCodec();
    public static final JsonCodec<PublishStreamRequest> JSON = new PublishStreamRequestJsonCodec();
    public static final PublishStreamRequest DEFAULT = PublishStreamRequest.newBuilder().build();
    private final OneOf<RequestOneOfType> request;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public PublishStreamRequest(OneOf<RequestOneOfType> request) {
        this.$unknownFields = null;
        if (request == null) {
            throw new NullPointerException("Parameter 'request' must be supplied and can not be null");
        }
        this.request = request;
    }

    public PublishStreamRequest(OneOf<RequestOneOfType> request, List<UnknownField> $unknownFields) {
        List<UnknownField> list = this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        if (request == null) {
            throw new NullPointerException("Parameter 'request' must be supplied and can not be null");
        }
        this.request = request;
    }

    public OneOf<RequestOneOfType> request() {
        return this.request;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            if (this.request.kind() == RequestOneOfType.BLOCK_ITEMS) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PublishStreamRequestSchema.BLOCK_ITEMS, (Object)((BlockItemSet)this.request.as()), BlockItemSet.PROTOBUF);
            }
            if (this.request.kind() == RequestOneOfType.END_STREAM) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PublishStreamRequestSchema.END_STREAM, (Object)((EndStream)this.request.as()), EndStream.PROTOBUF);
            }
            if (this.request.kind() == RequestOneOfType.END_OF_BLOCK) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PublishStreamRequestSchema.END_OF_BLOCK, (Object)((BlockEnd)this.request.as()), BlockEnd.PROTOBUF);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.request != null && !this.request.equals(PublishStreamRequest.DEFAULT.request)) {
                result = 31 * result + this.request.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        PublishStreamRequest thatObj = (PublishStreamRequest)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.request == null && thatObj.request != null) {
            return false;
        }
        if (this.request != null && !this.request.equals(thatObj.request)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "PublishStreamRequest[request=" + String.valueOf(this.request) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public BlockItemSet blockItems() {
        return this.request.kind() == RequestOneOfType.BLOCK_ITEMS ? (BlockItemSet)this.request.value() : null;
    }

    public boolean hasBlockItems() {
        return this.request.kind() == RequestOneOfType.BLOCK_ITEMS;
    }

    public BlockItemSet blockItemsOrElse(@NonNull BlockItemSet defaultValue) {
        return this.hasBlockItems() ? this.blockItems() : defaultValue;
    }

    @NonNull
    public BlockItemSet blockItemsOrThrow() {
        return Objects.requireNonNull(this.blockItems(), "Field blockItems is null");
    }

    @Nullable
    public EndStream endStream() {
        return this.request.kind() == RequestOneOfType.END_STREAM ? (EndStream)this.request.value() : null;
    }

    public boolean hasEndStream() {
        return this.request.kind() == RequestOneOfType.END_STREAM;
    }

    public EndStream endStreamOrElse(@NonNull EndStream defaultValue) {
        return this.hasEndStream() ? this.endStream() : defaultValue;
    }

    @NonNull
    public EndStream endStreamOrThrow() {
        return Objects.requireNonNull(this.endStream(), "Field endStream is null");
    }

    @Nullable
    public BlockEnd endOfBlock() {
        return this.request.kind() == RequestOneOfType.END_OF_BLOCK ? (BlockEnd)this.request.value() : null;
    }

    public boolean hasEndOfBlock() {
        return this.request.kind() == RequestOneOfType.END_OF_BLOCK;
    }

    public BlockEnd endOfBlockOrElse(@NonNull BlockEnd defaultValue) {
        return this.hasEndOfBlock() ? this.endOfBlock() : defaultValue;
    }

    @NonNull
    public BlockEnd endOfBlockOrThrow() {
        return Objects.requireNonNull(this.endOfBlock(), "Field endOfBlock is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.request, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum RequestOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        BLOCK_ITEMS(1, "block_items"),
        END_STREAM(2, "end_stream"),
        END_OF_BLOCK(3, "end_of_block");

        private final int protoOrdinal;
        private final String protoName;

        private RequestOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static RequestOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 1 -> BLOCK_ITEMS;
                case 2 -> END_STREAM;
                case 3 -> END_OF_BLOCK;
                default -> UNSET;
            };
        }

        public static RequestOneOfType fromString(String name) {
            return switch (name) {
                case "block_items", "BLOCK_ITEMS" -> BLOCK_ITEMS;
                case "end_stream", "END_STREAM" -> END_STREAM;
                case "end_of_block", "END_OF_BLOCK" -> END_OF_BLOCK;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }

        public static RequestOneOfType fromObject(Object obj) {
            if (obj == null) {
                return RequestOneOfType.fromProtobufOrdinal(0);
            }
            if (obj instanceof RequestOneOfType) {
                RequestOneOfType pbjEnum = (RequestOneOfType)((Object)obj);
                return pbjEnum;
            }
            return UNSET;
        }

        public static List<RequestOneOfType> fromObjects(List<?> list) {
            return list.stream().map(RequestOneOfType::fromObject).toList();
        }

        public static int toProtoOrdinal(Object obj) {
            if (obj instanceof RequestOneOfType) {
                RequestOneOfType pbjEnum = (RequestOneOfType)((Object)obj);
                return pbjEnum.protoOrdinal();
            }
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                return i;
            }
            throw new IllegalArgumentException("Neither RequestOneOfType, nor Integer, but: " + obj.getClass().getName());
        }

        public static List<Integer> toProtoOrdinals(List<?> list) {
            return list.stream().map(RequestOneOfType::toProtoOrdinal).toList();
        }

        public static int compare(Object o1, Object o2) {
            int i2;
            int i1;
            if (o1 instanceof RequestOneOfType) {
                RequestOneOfType e1 = (RequestOneOfType)((Object)o1);
                if (o2 instanceof RequestOneOfType) {
                    RequestOneOfType e2 = (RequestOneOfType)((Object)o2);
                    return e1.compareTo(e2);
                }
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof RequestOneOfType) {
                RequestOneOfType e1 = (RequestOneOfType)((Object)o1);
                i1 = e1.protoOrdinal();
            } else if (o1 instanceof Integer) {
                Integer ii1 = (Integer)o1;
                i1 = ii1;
            } else {
                throw new IllegalArgumentException("o1 is neither RequestOneOfType, nor Integer. It's: " + o1.getClass().getName());
            }
            if (o2 instanceof RequestOneOfType) {
                RequestOneOfType e2 = (RequestOneOfType)((Object)o2);
                i2 = e2.protoOrdinal();
            } else if (o2 instanceof Integer) {
                Integer ii2 = (Integer)o2;
                i2 = ii2;
            } else {
                throw new IllegalArgumentException("o2 is neither RequestOneOfType, nor Integer. It's: " + o2.getClass().getName());
            }
            return Integer.compare(i1, i2);
        }
    }

    public static final class EndStream {
        public static final Codec<EndStream> PROTOBUF = new PublishStreamRequestProtoCodec.EndStreamProtoCodec();
        public static final JsonCodec<EndStream> JSON = new PublishStreamRequestJsonCodec.EndStreamJsonCodec();
        public static final EndStream DEFAULT = EndStream.newBuilder().build();
        private final Object endCode;
        private final long earliestBlockNumber;
        private final long latestBlockNumber;
        private int $hashCode = -1;
        private int $protobufEncodedSize = -1;
        private final List<UnknownField> $unknownFields;

        public EndStream(Code endCode, long earliestBlockNumber, long latestBlockNumber) {
            this.$unknownFields = null;
            this.endCode = endCode;
            this.earliestBlockNumber = earliestBlockNumber;
            this.latestBlockNumber = latestBlockNumber;
        }

        public EndStream(Object endCode, long earliestBlockNumber, long latestBlockNumber) {
            this.$unknownFields = null;
            this.endCode = endCode;
            this.earliestBlockNumber = earliestBlockNumber;
            this.latestBlockNumber = latestBlockNumber;
        }

        public EndStream(Code endCode, long earliestBlockNumber, long latestBlockNumber, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.endCode = endCode;
            this.earliestBlockNumber = earliestBlockNumber;
            this.latestBlockNumber = latestBlockNumber;
        }

        public EndStream(Object endCode, long earliestBlockNumber, long latestBlockNumber, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.endCode = endCode;
            this.earliestBlockNumber = earliestBlockNumber;
            this.latestBlockNumber = latestBlockNumber;
        }

        public Code endCode() {
            return Code.fromObject(this.endCode);
        }

        public int endCodeProtoOrdinal() {
            return Code.toProtoOrdinal(this.endCode);
        }

        public long earliestBlockNumber() {
            return this.earliestBlockNumber;
        }

        public long latestBlockNumber() {
            return this.latestBlockNumber;
        }

        @NonNull
        public List<UnknownField> getUnknownFields() {
            return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
        }

        public int protobufSize() {
            if (this.$protobufEncodedSize == -1) {
                int _size = 0;
                _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)PublishStreamRequestSchema.EndStreamSchema.END_CODE, (Object)this.endCode);
                _size += ProtoWriterTools.sizeOfLong((FieldDefinition)PublishStreamRequestSchema.EndStreamSchema.EARLIEST_BLOCK_NUMBER, (long)this.earliestBlockNumber, (boolean)true);
                _size += ProtoWriterTools.sizeOfLong((FieldDefinition)PublishStreamRequestSchema.EndStreamSchema.LATEST_BLOCK_NUMBER, (long)this.latestBlockNumber, (boolean)true);
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        UnknownField uf = this.$unknownFields.get(i);
                        _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                        _size += Math.toIntExact(uf.bytes().length());
                    }
                }
                this.$protobufEncodedSize = _size;
            }
            return this.$protobufEncodedSize;
        }

        public int hashCode() {
            if (this.$hashCode == -1) {
                int result = 1;
                if (this.endCode != null && !this.endCode.equals(EndStream.DEFAULT.endCode)) {
                    result = 31 * result + Integer.hashCode(EnumWithProtoMetadata.protoOrdinal((Object)this.endCode));
                }
                if (this.earliestBlockNumber != EndStream.DEFAULT.earliestBlockNumber) {
                    result = 31 * result + Long.hashCode(this.earliestBlockNumber);
                }
                if (this.latestBlockNumber != EndStream.DEFAULT.latestBlockNumber) {
                    result = 31 * result + Long.hashCode(this.latestBlockNumber);
                }
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        result = 31 * result + this.$unknownFields.get(i).hashCode();
                    }
                }
                long hashCode = result;
                hashCode += hashCode << 30;
                hashCode ^= hashCode >>> 27;
                hashCode += hashCode << 16;
                hashCode ^= hashCode >>> 20;
                hashCode += hashCode << 5;
                hashCode ^= hashCode >>> 18;
                hashCode += hashCode << 10;
                hashCode ^= hashCode >>> 24;
                hashCode += hashCode << 30;
                this.$hashCode = (int)hashCode;
            }
            return this.$hashCode;
        }

        public boolean equals(Object that) {
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            EndStream thatObj = (EndStream)that;
            if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
                return false;
            }
            if (this.endCode == null && thatObj.endCode != null) {
                return false;
            }
            if (this.endCode != null && !this.endCode.equals(thatObj.endCode)) {
                return false;
            }
            if (this.earliestBlockNumber != thatObj.earliestBlockNumber) {
                return false;
            }
            if (this.latestBlockNumber != thatObj.latestBlockNumber) {
                return false;
            }
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                    return false;
                }
                if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                    return false;
                }
            } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
                return false;
            }
            return true;
        }

        public String toString() {
            String $ufstr = null;
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    this.$unknownFields.get(i).printToString(sb);
                }
                $ufstr = sb.toString();
            }
            return "EndStream[endCode=" + String.valueOf(this.endCode) + ", earliestBlockNumber=" + this.earliestBlockNumber + ", latestBlockNumber=" + this.latestBlockNumber + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
        }

        public Builder copyBuilder() {
            return new Builder(this.endCode, this.earliestBlockNumber, this.latestBlockNumber, this.$unknownFields);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static enum Code implements EnumWithProtoMetadata
        {
            UNKNOWN(0, "UNKNOWN"),
            RESET(1, "RESET"),
            TIMEOUT(2, "TIMEOUT"),
            ERROR(3, "ERROR"),
            TOO_FAR_BEHIND(4, "TOO_FAR_BEHIND"),
            UNRECOGNIZED(-1, "UNRECOGNIZED");

            private final int protoOrdinal;
            private final String protoName;

            private Code(int protoOrdinal, String protoName) {
                this.protoOrdinal = protoOrdinal;
                this.protoName = protoName;
            }

            public int protoOrdinal() {
                return this.protoOrdinal;
            }

            public String protoName() {
                return this.protoName;
            }

            public static Code fromProtobufOrdinal(int ordinal) {
                return switch (ordinal) {
                    case 0 -> UNKNOWN;
                    case 1 -> RESET;
                    case 2 -> TIMEOUT;
                    case 3 -> ERROR;
                    case 4 -> TOO_FAR_BEHIND;
                    default -> UNRECOGNIZED;
                };
            }

            public static Code fromString(String name) {
                return switch (name) {
                    case "UNKNOWN" -> UNKNOWN;
                    case "RESET" -> RESET;
                    case "TIMEOUT" -> TIMEOUT;
                    case "ERROR" -> ERROR;
                    case "TOO_FAR_BEHIND" -> TOO_FAR_BEHIND;
                    default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
                };
            }

            public static Code fromObject(Object obj) {
                if (obj == null) {
                    return Code.fromProtobufOrdinal(0);
                }
                if (obj instanceof Code) {
                    Code pbjEnum = (Code)((Object)obj);
                    return pbjEnum;
                }
                return UNRECOGNIZED;
            }

            public static List<Code> fromObjects(List<?> list) {
                return list.stream().map(Code::fromObject).toList();
            }

            public static int toProtoOrdinal(Object obj) {
                if (obj instanceof Code) {
                    Code pbjEnum = (Code)((Object)obj);
                    return pbjEnum.protoOrdinal();
                }
                if (obj instanceof Integer) {
                    Integer i = (Integer)obj;
                    return i;
                }
                throw new IllegalArgumentException("Neither Code, nor Integer, but: " + obj.getClass().getName());
            }

            public static List<Integer> toProtoOrdinals(List<?> list) {
                return list.stream().map(Code::toProtoOrdinal).toList();
            }

            public static int compare(Object o1, Object o2) {
                int i2;
                int i1;
                if (o1 instanceof Code) {
                    Code e1 = (Code)((Object)o1);
                    if (o2 instanceof Code) {
                        Code e2 = (Code)((Object)o2);
                        return e1.compareTo(e2);
                    }
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                if (o1 instanceof Code) {
                    Code e1 = (Code)((Object)o1);
                    i1 = e1.protoOrdinal();
                } else if (o1 instanceof Integer) {
                    Integer ii1 = (Integer)o1;
                    i1 = ii1;
                } else {
                    throw new IllegalArgumentException("o1 is neither Code, nor Integer. It's: " + o1.getClass().getName());
                }
                if (o2 instanceof Code) {
                    Code e2 = (Code)((Object)o2);
                    i2 = e2.protoOrdinal();
                } else if (o2 instanceof Integer) {
                    Integer ii2 = (Integer)o2;
                    i2 = ii2;
                } else {
                    throw new IllegalArgumentException("o2 is neither Code, nor Integer. It's: " + o2.getClass().getName());
                }
                return Integer.compare(i1, i2);
            }
        }

        public static final class Builder {
            private Object endCode = Code.fromProtobufOrdinal(0);
            private long earliestBlockNumber = 0L;
            private long latestBlockNumber = 0L;
            private final List<UnknownField> $unknownFields;

            public Builder() {
                this.$unknownFields = null;
            }

            public Builder(Code endCode, long earliestBlockNumber, long latestBlockNumber) {
                this.$unknownFields = null;
                this.endCode = endCode;
                this.earliestBlockNumber = earliestBlockNumber;
                this.latestBlockNumber = latestBlockNumber;
            }

            public Builder(Object endCode, long earliestBlockNumber, long latestBlockNumber) {
                this.$unknownFields = null;
                this.endCode = endCode;
                this.earliestBlockNumber = earliestBlockNumber;
                this.latestBlockNumber = latestBlockNumber;
            }

            public Builder(Code endCode, long earliestBlockNumber, long latestBlockNumber, List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
                this.endCode = endCode;
                this.earliestBlockNumber = earliestBlockNumber;
                this.latestBlockNumber = latestBlockNumber;
            }

            public Builder(Object endCode, long earliestBlockNumber, long latestBlockNumber, List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
                this.endCode = endCode;
                this.earliestBlockNumber = earliestBlockNumber;
                this.latestBlockNumber = latestBlockNumber;
            }

            public EndStream build() {
                return new EndStream(this.endCode, this.earliestBlockNumber, this.latestBlockNumber);
            }

            public Builder endCode(Code endCode) {
                this.endCode = endCode;
                return this;
            }

            public Builder earliestBlockNumber(long earliestBlockNumber) {
                this.earliestBlockNumber = earliestBlockNumber;
                return this;
            }

            public Builder latestBlockNumber(long latestBlockNumber) {
                this.latestBlockNumber = latestBlockNumber;
                return this;
            }

            public Code endCode() {
                return Code.fromObject(this.endCode);
            }

            public int endCodeProtoOrdinal() {
                return Code.toProtoOrdinal(this.endCode);
            }

            public long earliestBlockNumber() {
                return this.earliestBlockNumber;
            }

            public long latestBlockNumber() {
                return this.latestBlockNumber;
            }
        }
    }

    public static final class Builder {
        private OneOf<RequestOneOfType> request = PublishStreamRequestProtoCodec.REQUEST_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(OneOf<RequestOneOfType> request) {
            this.$unknownFields = null;
            this.request = request;
        }

        public Builder(OneOf<RequestOneOfType> request, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.request = request;
        }

        public PublishStreamRequest build() {
            return new PublishStreamRequest(this.request);
        }

        public void clearRequest() {
            this.request = PublishStreamRequestProtoCodec.REQUEST_UNSET;
        }

        public Builder blockItems(@Nullable BlockItemSet blockItems) {
            this.request = new OneOf((Enum)RequestOneOfType.BLOCK_ITEMS, (Object)blockItems);
            return this;
        }

        public Builder blockItems(BlockItemSet.Builder builder) {
            this.request = new OneOf((Enum)RequestOneOfType.BLOCK_ITEMS, (Object)builder.build());
            return this;
        }

        public Builder endStream(@Nullable EndStream endStream) {
            this.request = new OneOf((Enum)RequestOneOfType.END_STREAM, (Object)endStream);
            return this;
        }

        public Builder endStream(EndStream.Builder builder) {
            this.request = new OneOf((Enum)RequestOneOfType.END_STREAM, (Object)builder.build());
            return this;
        }

        public Builder endOfBlock(@Nullable BlockEnd endOfBlock) {
            this.request = new OneOf((Enum)RequestOneOfType.END_OF_BLOCK, (Object)endOfBlock);
            return this;
        }

        public Builder endOfBlock(BlockEnd.Builder builder) {
            this.request = new OneOf((Enum)RequestOneOfType.END_OF_BLOCK, (Object)builder.build());
            return this;
        }

        public OneOf<RequestOneOfType> request() {
            return this.request;
        }
    }
}

