/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.streams;

import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.Releasable;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;
import org.hiero.consensus.reconnect.config.ReconnectConfig;

public class AsyncInputStream<T extends SelfSerializable>
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(AsyncInputStream.class);
    private static final String THREAD_NAME = "async-input-stream";
    private final SerializableDataInputStream inputStream;
    private final AtomicLong anticipatedMessages;
    private final BlockingQueue<SelfSerializable> receivedMessages;
    private final Duration pollTimeout;
    private final CountDownLatch finishedLatch;
    private volatile boolean alive;
    private final Supplier<T> messageFactory;
    private final StandardWorkGroup workGroup;

    public AsyncInputStream(@NonNull SerializableDataInputStream inputStream, @NonNull StandardWorkGroup workGroup, @NonNull Supplier<T> messageFactory, @NonNull ReconnectConfig config) {
        Objects.requireNonNull(config, "config must not be null");
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream must not be null");
        this.workGroup = Objects.requireNonNull(workGroup, "workGroup must not be null");
        this.messageFactory = Objects.requireNonNull(messageFactory, "messageFactory must not be null");
        this.pollTimeout = config.asyncStreamTimeout();
        this.anticipatedMessages = new AtomicLong(0L);
        this.receivedMessages = new LinkedBlockingQueue<SelfSerializable>(config.asyncStreamBufferSize());
        this.finishedLatch = new CountDownLatch(1);
        this.alive = true;
    }

    public void start() {
        this.workGroup.execute(THREAD_NAME, this::run);
    }

    public boolean isAlive() {
        return this.alive;
    }

    public long getTotalAnticipatedMessages() {
        return this.anticipatedMessages.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        SelfSerializable message = null;
        logger.info(LogMarker.RECONNECT.getMarker(), this.toString() + " start run()");
        try {
            while (this.isAlive() && !Thread.currentThread().isInterrupted()) {
                long previous = this.anticipatedMessages.getAndUpdate(value -> value == 0L ? 0L : value - 1L);
                if (previous == 0L) {
                    TimeUnit.MILLISECONDS.sleep(1L);
                    continue;
                }
                message = (SelfSerializable)this.messageFactory.get();
                message.deserialize(this.inputStream, message.getVersion());
                boolean accepted = this.receivedMessages.offer(message, this.pollTimeout.toMillis(), TimeUnit.MILLISECONDS);
                if (accepted) continue;
                new MerkleSynchronizationException(this.toString() + " timed out waiting to add message to received messages queue");
            }
        }
        catch (IOException e) {
            throw new MerkleSynchronizationException(String.format("%s failed to deserialize object with class ID %d(0x%08X) (%s)", this.toString(), message.getClassId(), message.getClassId(), message.getClass().toString()), e);
        }
        catch (InterruptedException e) {
            logger.warn(LogMarker.RECONNECT.getMarker(), this.toString() + " interrupted");
            Thread.currentThread().interrupt();
        }
        finally {
            this.finishedLatch.countDown();
        }
        logger.info(LogMarker.RECONNECT.getMarker(), this.toString() + " finish run()");
    }

    public void anticipateMessage() {
        this.anticipatedMessages.getAndIncrement();
    }

    public T readAnticipatedMessage() throws InterruptedException {
        return this.asyncRead();
    }

    public void abort() {
        this.close();
        try {
            this.finishedLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        while (!this.receivedMessages.isEmpty()) {
            SelfSerializable message = (SelfSerializable)this.receivedMessages.remove();
            if (!(message instanceof Releasable)) continue;
            ((Releasable)message).release();
        }
    }

    @Override
    public void close() {
        this.alive = false;
    }

    private T asyncRead() throws InterruptedException {
        SelfSerializable data = this.receivedMessages.poll(this.pollTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (data == null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                throw new MerkleSynchronizationException("Unable to close stream", e);
            }
            throw new MerkleSynchronizationException("Timed out waiting for data");
        }
        return (T)data;
    }
}

