/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;

public final class SyncDeltaBuilder {
    private SyncToken _token;
    private SyncDeltaType _deltaType;
    private Uid _previousUid;
    private Uid _uid;
    private ConnectorObject _object;

    public SyncDeltaBuilder() {
    }

    public SyncDeltaBuilder(SyncDelta delta) {
        this._token = delta.getToken();
        this._deltaType = delta.getDeltaType();
        this._object = delta.getObject();
        this._previousUid = delta.getPreviousUid();
        this._uid = delta.getUid();
    }

    public SyncToken getToken() {
        return this._token;
    }

    public SyncDeltaBuilder setToken(SyncToken token) {
        this._token = token;
        return this;
    }

    public SyncDeltaType getDeltaType() {
        return this._deltaType;
    }

    public SyncDeltaBuilder setDeltaType(SyncDeltaType type) {
        this._deltaType = type;
        return this;
    }

    public Uid getPreviousUid() {
        return this._previousUid;
    }

    public void setPreviousUid(Uid previousUid) {
        this._previousUid = previousUid;
    }

    public Uid getUid() {
        return this._uid;
    }

    public SyncDeltaBuilder setUid(Uid uid) {
        this._uid = uid;
        return this;
    }

    public ConnectorObject getObject() {
        return this._object;
    }

    public SyncDeltaBuilder setObject(ConnectorObject object) {
        this._object = object;
        if (object != null) {
            this._uid = object.getUid();
        }
        return this;
    }

    public SyncDelta build() {
        return new SyncDelta(this._token, this._deltaType, this._previousUid, this._uid, this._object);
    }
}

