/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli;

import com.swirlds.common.utility.CommonUtils;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.crypto.EnhancedKeyStoreLoader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStoreException;
import java.security.cert.CertificateEncodingException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.node.NodeUtilities;
import org.hiero.consensus.pcli.AbstractCommand;
import org.hiero.consensus.pcli.Pcli;
import org.hiero.consensus.pcli.SubcommandOf;
import picocli.CommandLine;

@CommandLine.Command(name="generate-keys", mixinStandardHelpOptions=true, description={"Generates Node's X.509 certificate and private keys."})
@SubcommandOf(value=Pcli.class)
public class GenerateKeysCommand
extends AbstractCommand {
    private Path sigCertPath;
    @CommandLine.Parameters
    private List<Integer> ids;

    @CommandLine.Option(names={"-p", "--path"}, description={"Path to place the keys"})
    private void setSigCertPath(Path sigCertPath) {
        this.sigCertPath = this.pathMustExist(sigCertPath.toAbsolutePath());
    }

    @Override
    public Integer call() throws KeyStoreException, ExecutionException, InterruptedException, IOException, CertificateEncodingException {
        Map keysEntries = CryptoStatic.generateKeysAndCerts(this.ids.stream().map(NodeId::of).toList());
        if (this.sigCertPath == null) {
            Files.createDirectories(Path.of(System.getProperty("user.dir"), new String[0]).resolve("data/keys"), new FileAttribute[0]);
            this.sigCertPath = Path.of(System.getProperty("user.dir"), new String[0]).resolve("data/keys");
        }
        for (Map.Entry kEntry : keysEntries.entrySet()) {
            Path publicKeyStorePath = this.sigCertPath.resolve(String.format("s-public-%s.pem", NodeUtilities.formatNodeName((NodeId)((NodeId)kEntry.getKey()))));
            Path privateKeyStorePath = this.sigCertPath.resolve(String.format("s-private-%s.pem", NodeUtilities.formatNodeName((NodeId)((NodeId)kEntry.getKey()))));
            EnhancedKeyStoreLoader.writePemFile((boolean)true, (Path)privateKeyStorePath, (byte[])((KeysAndCerts)kEntry.getValue()).sigKeyPair().getPrivate().getEncoded());
            EnhancedKeyStoreLoader.writePemFile((boolean)false, (Path)publicKeyStorePath, (byte[])((KeysAndCerts)kEntry.getValue()).sigCert().getEncoded());
        }
        CommonUtils.tellUserConsole((String)("All " + this.ids.size() + " keys generated in:" + String.valueOf(this.sigCertPath)));
        return 0;
    }
}

