/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.node.app.service.token.api.FeeStreamBuilder;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.LongConsumer;
import java.util.function.ObjLongConsumer;

public class FeeAccumulator {
    private final TokenServiceApi tokenApi;
    private final FeeStreamBuilder feeStreamBuilder;
    private final LongConsumer onNodeFeeCharged;
    private final LongConsumer onNodeFeeRefunded;

    public FeeAccumulator(@NonNull TokenServiceApi tokenApi, @NonNull FeeStreamBuilder feeStreamBuilder, @NonNull SavepointStackImpl stack) {
        this.tokenApi = Objects.requireNonNull(tokenApi);
        this.feeStreamBuilder = Objects.requireNonNull(feeStreamBuilder);
        this.onNodeFeeCharged = amount -> stack.peek().trackCollectedNodeFee(amount);
        this.onNodeFeeRefunded = amount -> stack.peek().trackRefundedNodeFee(amount);
    }

    public Fees chargeFee(@NonNull AccountID payer, long networkFee, @Nullable ObjLongConsumer<AccountID> cb) {
        Objects.requireNonNull(payer);
        return this.tokenApi.chargeFee(payer, networkFee, (StreamBuilder)this.feeStreamBuilder, cb);
    }

    public void refundFee(@NonNull AccountID payer, long networkFee) {
        Objects.requireNonNull(payer);
        this.tokenApi.refundFee(payer, networkFee, this.feeStreamBuilder);
    }

    public Fees chargeFees(@NonNull AccountID payer, @NonNull AccountID nodeAccount, @NonNull Fees fees, @Nullable ObjLongConsumer<AccountID> cb) {
        Objects.requireNonNull(payer);
        Objects.requireNonNull(nodeAccount);
        Objects.requireNonNull(fees);
        return this.tokenApi.chargeFees(payer, nodeAccount, fees, this.feeStreamBuilder, cb, this.onNodeFeeCharged);
    }

    public void refundFees(@NonNull AccountID payerId, @NonNull Fees fees, @NonNull AccountID nodeAccountId) {
        Objects.requireNonNull(payerId);
        Objects.requireNonNull(nodeAccountId);
        Objects.requireNonNull(fees);
        this.tokenApi.refundFees(payerId, nodeAccountId, fees, this.feeStreamBuilder, this.onNodeFeeRefunded);
    }
}

