/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.SubType;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.spi.fees.ResourcePriceCalculator;
import com.hedera.node.app.spi.workflows.FunctionalityResourcePrices;
import com.hedera.node.app.store.ReadableStoreFactoryImpl;
import com.hedera.node.app.workflows.TransactionInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import javax.inject.Inject;

public class ResourcePriceCalculatorImpl
implements ResourcePriceCalculator {
    private final Instant consensusNow;
    private final TransactionInfo txnInfo;
    private final FeeManager feeManager;
    private final ReadableStoreFactoryImpl readableStoreFactory;

    @Inject
    public ResourcePriceCalculatorImpl(@NonNull Instant consensusNow, @NonNull TransactionInfo txnInfo, @NonNull FeeManager feeManager, @NonNull ReadableStoreFactoryImpl readableStoreFactory) {
        this.consensusNow = Objects.requireNonNull(consensusNow);
        this.txnInfo = Objects.requireNonNull(txnInfo);
        this.feeManager = Objects.requireNonNull(feeManager);
        this.readableStoreFactory = Objects.requireNonNull(readableStoreFactory);
    }

    @NonNull
    public FunctionalityResourcePrices resourcePricesFor(@NonNull HederaFunctionality functionality, @NonNull SubType subType) {
        return new FunctionalityResourcePrices(Objects.requireNonNull(this.feeManager.getFeeData(functionality, this.consensusNow, subType)), this.feeManager.congestionMultiplierFor(this.txnInfo.txBody(), functionality, this.readableStoreFactory));
    }
}

