/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl.producers.formats;

import com.hedera.node.app.records.impl.producers.BlockRecordWriter;
import com.hedera.node.app.records.impl.producers.BlockRecordWriterFactory;
import com.hedera.node.app.records.impl.producers.formats.v6.BlockRecordWriterV6;
import com.hedera.node.app.spi.records.SelfNodeAccountIdManager;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.BlockRecordStreamConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.FileSystem;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Signer;

@Singleton
public class BlockRecordWriterFactoryImpl
implements BlockRecordWriterFactory {
    private static final Logger logger = LogManager.getLogger(BlockRecordWriterFactoryImpl.class);
    private final ConfigProvider configProvider;
    private final Signer signer;
    private final FileSystem fileSystem;
    private final SelfNodeAccountIdManager selfNodeAccountIdManager;

    @Inject
    public BlockRecordWriterFactoryImpl(@NonNull ConfigProvider configProvider, @NonNull Signer signer, @NonNull FileSystem fileSystem, @NonNull SelfNodeAccountIdManager selfNodeAccountIdManager) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.fileSystem = Objects.requireNonNull(fileSystem);
        this.signer = Objects.requireNonNull(signer);
        this.selfNodeAccountIdManager = selfNodeAccountIdManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BlockRecordWriter create() throws RuntimeException {
        VersionedConfiguration config = this.configProvider.getConfiguration();
        BlockRecordStreamConfig recordStreamConfig = (BlockRecordStreamConfig)config.getConfigData(BlockRecordStreamConfig.class);
        int recordFileVersion = recordStreamConfig.recordFileVersion();
        switch (recordFileVersion) {
            case 6: {
                return new BlockRecordWriterV6((BlockRecordStreamConfig)this.configProvider.getConfiguration().getConfigData(BlockRecordStreamConfig.class), this.selfNodeAccountIdManager.getSelfNodeAccountId(), this.signer, this.fileSystem);
            }
            case 7: {
                throw new IllegalArgumentException("Record file version 7 is not yet supported");
            }
            default: {
                throw new IllegalArgumentException("Unknown record file version: " + recordFileVersion);
            }
        }
    }
}

