/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.hashgraph.impl.consensus;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.event.EventConsensusData;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.JudgeId;
import com.hedera.hapi.util.HapiUtils;
import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.crypto.Hash;
import org.hiero.base.utility.Threshold;
import org.hiero.consensus.concurrent.utility.throttle.RateLimitedLogger;
import org.hiero.consensus.hashgraph.config.ConsensusConfig;
import org.hiero.consensus.hashgraph.impl.EventImpl;
import org.hiero.consensus.hashgraph.impl.consensus.AncestorSearch;
import org.hiero.consensus.hashgraph.impl.consensus.CandidateWitness;
import org.hiero.consensus.hashgraph.impl.consensus.Consensus;
import org.hiero.consensus.hashgraph.impl.consensus.ConsensusRounds;
import org.hiero.consensus.hashgraph.impl.consensus.ConsensusSorter;
import org.hiero.consensus.hashgraph.impl.consensus.ConsensusUtils;
import org.hiero.consensus.hashgraph.impl.consensus.CountingVote;
import org.hiero.consensus.hashgraph.impl.consensus.DeGen;
import org.hiero.consensus.hashgraph.impl.consensus.EventUtils;
import org.hiero.consensus.hashgraph.impl.consensus.InitJudges;
import org.hiero.consensus.hashgraph.impl.consensus.RoundElections;
import org.hiero.consensus.hashgraph.impl.metrics.ConsensusMetrics;
import org.hiero.consensus.model.PbjConverters;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.roster.RosterLookup;

public class ConsensusImpl
implements Consensus {
    private static final Logger logger = LogManager.getLogger(ConsensusImpl.class);
    private final ConsensusConfig config;
    private final Time time;
    private final RosterLookup rosterLookup;
    private final ConsensusMetrics consensusMetrics;
    private final AncestorSearch search = new AncestorSearch();
    private final List<EventImpl> recentEvents = new LinkedList<EventImpl>();
    private final ConsensusRounds rounds;
    private long numConsensus = 0L;
    private Instant lastConsensusTime = null;
    private InitJudges initJudges = null;
    private final RateLimitedLogger noSuperMajorityLogger;
    private final RateLimitedLogger noJudgeLogger;
    private final RateLimitedLogger coinRoundLogger;
    private boolean pcesMode = false;

    public ConsensusImpl(@NonNull Configuration configuration, @NonNull Time time, @NonNull ConsensusMetrics consensusMetrics, @NonNull Roster roster) {
        this.config = (ConsensusConfig)Objects.requireNonNull(configuration).getConfigData(ConsensusConfig.class);
        this.time = time;
        this.consensusMetrics = consensusMetrics;
        this.rosterLookup = new RosterLookup(roster);
        this.rounds = new ConsensusRounds(this.config, roster);
        this.noSuperMajorityLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
        this.noJudgeLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
        this.coinRoundLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
    }

    @Override
    public void loadSnapshot(@NonNull ConsensusSnapshot snapshot) {
        this.reset();
        Set<Hash> judgeHashes = snapshot.judgeIds().stream().map(judge -> new Hash(judge.judgeHash())).collect(Collectors.toSet());
        this.initJudges = new InitJudges(snapshot.round(), judgeHashes);
        this.rounds.loadFromMinimumJudge(snapshot.minimumJudgeInfoList());
        this.numConsensus = snapshot.nextConsensusNumber();
        this.lastConsensusTime = PbjConverters.fromPbjTimestamp((Timestamp)snapshot.consensusTimestamp());
    }

    private void reset() {
        this.recentEvents.clear();
        this.rounds.reset();
        this.numConsensus = 0L;
        this.lastConsensusTime = null;
        this.initJudges = null;
    }

    @Override
    public void setPcesMode(boolean pcesMode) {
        this.pcesMode = pcesMode;
    }

    @Override
    public List<EventImpl> getPreConsensusEvents() {
        return this.recentEvents.stream().filter(e -> !e.isConsensus()).toList();
    }

    @Override
    @NonNull
    public List<ConsensusRound> addEvent(@NonNull EventImpl event) {
        try {
            this.recentEvents.add(event);
            event.setRoundCreated(-1L);
            boolean lastJudgeFound = this.checkInitJudges(event);
            if (this.waitingForInitJudges()) {
                return List.of();
            }
            ConsensusRound consensusRound = lastJudgeFound ? this.recalculateAndVote() : this.calculateAndVote(event);
            ArrayList<ConsensusRound> rounds = new ArrayList<ConsensusRound>();
            while (consensusRound != null) {
                rounds.add(consensusRound);
                consensusRound = this.recalculateAndVote();
            }
            return rounds;
        }
        catch (Exception e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception occurred while trying to add event", (Throwable)e);
            throw e;
        }
    }

    @Nullable
    private ConsensusRound recalculateAndVote() {
        this.rounds.recalculating();
        Iterator<EventImpl> iterator = this.recentEvents.iterator();
        while (iterator.hasNext()) {
            EventImpl insertedEvent = iterator.next();
            if (this.rounds.isLastDecidedJudge(insertedEvent) && insertedEvent.getAllParents().stream().mapToLong(this::round).max().orElse(0L) == 0L) {
                DeGen.calculateDeGen(insertedEvent);
                continue;
            }
            if (insertedEvent.isConsensus() || this.ancient(insertedEvent)) {
                insertedEvent.clearMetadata();
                insertedEvent.setRoundCreated(0L);
                iterator.remove();
                continue;
            }
            insertedEvent.clearMetadata();
            insertedEvent.setRoundCreated(-1L);
            ConsensusRound consensusRound = this.calculateAndVote(insertedEvent);
            if (consensusRound == null) continue;
            return consensusRound;
        }
        return null;
    }

    @Nullable
    private ConsensusRound calculateAndVote(EventImpl event) {
        RoundElections roundElections;
        DeGen.calculateDeGen(event);
        this.round(event);
        this.consensusMetrics.addedEvent(event);
        this.calculateMetadata(event);
        if (!this.witness(event)) {
            return null;
        }
        event.setWitness(true);
        if (this.rounds.getElectionRoundNumber() <= event.getRoundCreated()) {
            this.rounds.newWitness(event);
            if (this.rounds.getElectionRoundNumber() < event.getRoundCreated()) {
                this.voteInAllElections(event);
            }
        } else {
            event.setFamous(false);
            event.setFameDecided(true);
        }
        if ((roundElections = this.rounds.getElectionRound()).isDecided() && !this.waitingForInitJudges()) {
            return this.roundDecided(roundElections);
        }
        return null;
    }

    @Override
    public boolean waitingForInitJudges() {
        return this.initJudges != null && this.initJudges.initJudgesMissing();
    }

    private boolean checkInitJudges(@NonNull EventImpl event) {
        if (!this.waitingForInitJudges()) {
            return false;
        }
        if (!this.initJudges.isInitJudge(event.getBaseHash())) {
            return false;
        }
        this.initJudges.judgeFound(event);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.initJudges::numMissingJudges;
        logger.info(LogMarker.STARTUP.getMarker(), "Found init judge %s, num remaining: {}".formatted(event.shortString()), supplierArray);
        if (this.initJudges.initJudgesMissing()) {
            return false;
        }
        List<EventImpl> ancestors = this.search.commonAncestorsOf(this.initJudges.getJudges(), this::nonConsensusNonAncient);
        ancestors.forEach(e -> {
            e.setConsensus(true);
            e.setRecTimes(null);
        });
        this.rounds.setConsensusRelevantNGen(this.initJudges.getJudges().stream().map(EventImpl::getNGen).min(Long::compareTo).orElse(1L));
        this.initJudges = null;
        return true;
    }

    private void calculateMetadata(@NonNull EventImpl event) {
        if (ConsensusImpl.notRelevantForConsensus(event) || this.rounds.isLastDecidedJudge(event)) {
            return;
        }
        this.lastSee(event, 0L);
        this.timedStronglySeeP(event, 0L);
        this.firstSelfWitnessS(event);
        this.firstWitnessS(event);
    }

    private void voteInAllElections(@NonNull EventImpl votingWitness) {
        RoundElections roundElections = this.rounds.getElectionRound();
        votingWitness.initVoting(roundElections.numElections());
        long diff = this.round(votingWitness) - roundElections.getRound();
        if (diff <= 0L) {
            return;
        }
        if (diff == 1L) {
            Iterator<CandidateWitness> it = roundElections.undecidedWitnesses();
            while (it.hasNext()) {
                CandidateWitness candidateWitness = it.next();
                boolean firstVote = this.firstVote(votingWitness, candidateWitness.getWitness());
                votingWitness.setVote(candidateWitness, firstVote);
                this.logVote(votingWitness, candidateWitness, "first", diff);
            }
            return;
        }
        List<EventImpl> stronglySeen = this.getStronglySeenInPreviousRound(votingWitness);
        Iterator<CandidateWitness> it = roundElections.undecidedWitnesses();
        while (it.hasNext()) {
            CandidateWitness candidateWitness = it.next();
            CountingVote countingVote = this.getCountingVote(candidateWitness, stronglySeen);
            if (this.isCoinRound(diff)) {
                this.coinVote(votingWitness, candidateWitness, countingVote);
                this.logVote(votingWitness, candidateWitness, "coin-" + (countingVote.isSupermajority() ? "counting" : "sig"), diff);
                this.coinRoundLogger.warn(LogMarker.ERROR.getMarker(), "Coin round {}, voting witness: {}", new Object[]{roundElections.getRound(), votingWitness});
                continue;
            }
            votingWitness.setVote(candidateWitness, countingVote.getVote());
            this.logVote(votingWitness, candidateWitness, "counting", diff);
            if (!countingVote.isSupermajority()) continue;
            candidateWitness.fameDecided(votingWitness.getVote(candidateWitness));
            if (!roundElections.isDecided()) continue;
            this.consensusMetrics.lastFamousInRound(candidateWitness.getWitness());
            return;
        }
    }

    @NonNull
    private CountingVote getCountingVote(CandidateWitness candidateWitness, List<EventImpl> stronglySeen) {
        long yesWeight = 0L;
        long noWeight = 0L;
        for (EventImpl w : stronglySeen) {
            long weight = this.rosterLookup.getWeight(w.getCreatorId());
            if (w.getVote(candidateWitness)) {
                yesWeight += weight;
                continue;
            }
            noWeight += weight;
        }
        boolean superMajority = Threshold.SUPER_MAJORITY.isSatisfiedBy(yesWeight, this.rosterLookup.rosterTotalWeight()) || Threshold.SUPER_MAJORITY.isSatisfiedBy(noWeight, this.rosterLookup.rosterTotalWeight());
        boolean countingVote = yesWeight >= noWeight;
        return CountingVote.get(countingVote, superMajority);
    }

    private boolean isCoinRound(long diff) {
        return diff % (long)this.config.coinFreq() == 0L;
    }

    private void coinVote(@NonNull EventImpl votingWitness, @NonNull CandidateWitness candidateWitness, @NonNull CountingVote countingVote) {
        this.consensusMetrics.coinRound();
        boolean vote = countingVote.isSupermajority() ? countingVote.getVote() : ConsensusUtils.coin((Event)votingWitness.getBaseEvent());
        votingWitness.setVote(candidateWitness, vote);
    }

    private void logVote(@NonNull EventImpl votingWitness, @NonNull CandidateWitness candidateWitness, @NonNull String votingType, long diff) {
        if (logger.isDebugEnabled(LogMarker.CONSENSUS_VOTING.getMarker())) {
            logger.debug(LogMarker.CONSENSUS_VOTING.getMarker(), "Witness {} voted on {}. vote:{} type:{} diff:{}", (Object)votingWitness.shortString(), (Object)candidateWitness.getWitness().shortString(), (Object)votingWitness.getVote(candidateWitness), (Object)votingType, (Object)diff);
        }
    }

    private boolean firstVote(@NonNull EventImpl voting, @NonNull EventImpl votedOn) {
        int votedOnIndex = this.rosterLookup.getRosterIndex(votedOn.getCreatorId());
        EventImpl w = this.firstSee(voting, votedOnIndex);
        while (w != null && w.getRoundCreated() > voting.getRoundCreated() - 1L && this.selfParent(w) != null) {
            w = this.firstSelfWitnessS(this.selfParent(w));
        }
        return votedOn == w;
    }

    @NonNull
    private List<EventImpl> getStronglySeenInPreviousRound(EventImpl event) {
        ArrayList<EventImpl> stronglySeen = new ArrayList<EventImpl>(this.rosterLookup.numMembers());
        for (long m = 0L; m < (long)this.rosterLookup.numMembers(); ++m) {
            EventImpl s = this.stronglySeeS1(event, m);
            if (s == null) continue;
            stronglySeen.add(s);
        }
        return stronglySeen;
    }

    @NonNull
    private ConsensusRound roundDecided(RoundElections roundElections) {
        List<EventImpl> judges = roundElections.findAllJudges();
        long decidedRoundNumber = this.rounds.getElectionRoundNumber();
        this.checkJudges(judges, decidedRoundNumber);
        this.rounds.currentElectionDecided();
        List<PlatformEvent> consensusEvents = this.findConsensusEvents(judges, decidedRoundNumber, ConsensusUtils.generateWhitening(judges)).stream().map(EventImpl::getBaseEvent).toList();
        this.consensusMetrics.consensusReachedOnRound();
        if (consensusEvents.isEmpty()) {
            if (this.lastConsensusTime == null) {
                List<Instant> judgeTimes = judges.stream().map(EventImpl::getTimeCreated).sorted().toList();
                this.lastConsensusTime = judgeTimes.get(judgeTimes.size() / 2);
            } else {
                this.lastConsensusTime = ConsensusUtils.calcMinTimestampForNextEvent(this.lastConsensusTime);
            }
        }
        long nonAncientThreshold = this.rounds.getAncientThreshold();
        long nonExpiredThreshold = this.rounds.getExpiredThreshold();
        List<JudgeId> judgeIds = judges.stream().map(event -> new JudgeId(event.getCreatorId().id(), event.getBaseHash().getBytes())).toList();
        return new ConsensusRound(this.rosterLookup.getRoster(), consensusEvents, new EventWindow(decidedRoundNumber, decidedRoundNumber + 1L, nonAncientThreshold, nonExpiredThreshold), new ConsensusSnapshot(decidedRoundNumber, this.rounds.getMinimumJudgeInfoList(), this.numConsensus, PbjConverters.toPbjTimestamp((Instant)this.lastConsensusTime), judgeIds), this.pcesMode, this.time.now());
    }

    private void checkJudges(@NonNull List<EventImpl> judges, long decidedRoundNumber) {
        long judgeWeights = judges.stream().mapToLong(event -> this.rosterLookup.getWeight(event.getCreatorId())).sum();
        this.consensusMetrics.judgeWeights(judgeWeights);
        if (judges.isEmpty()) {
            this.noJudgeLogger.error(LogMarker.ERROR.getMarker(), "no judges in round = {}", new Object[]{decidedRoundNumber});
        } else if (!Threshold.SUPER_MAJORITY.isSatisfiedBy(judgeWeights, this.rosterLookup.rosterTotalWeight())) {
            this.noSuperMajorityLogger.error(LogMarker.ERROR.getMarker(), "less than a super majority of weight on judges.  round = {}, judgesWeight = {}, percentage = {}", new Object[]{decidedRoundNumber, judgeWeights, (double)judgeWeights / (double)this.rosterLookup.rosterTotalWeight()});
        }
    }

    @NonNull
    private List<EventImpl> findConsensusEvents(@NonNull List<EventImpl> judges, long decidedRound, @NonNull byte[] whitening) {
        List<EventImpl> consensus = this.search.commonAncestorsOf(judges, this::nonConsensusNonAncient);
        consensus.forEach(e -> ConsensusImpl.setIsConsensusTrue(e, decidedRound));
        ConsensusSorter.sort(consensus, whitening);
        this.setConsensusOrder(consensus);
        consensus.forEach(e -> e.setRecTimes(null));
        return consensus;
    }

    private static void setIsConsensusTrue(@NonNull EventImpl event, long receivedRound) {
        event.setRoundReceived(receivedRound);
        event.setConsensus(true);
        List<Instant> times = event.getRecTimes();
        event.setPreliminaryConsensusTimestamp(times.get(times.size() / 2));
    }

    private void setConsensusOrder(@NonNull Collection<EventImpl> events) {
        for (EventImpl e : events) {
            Instant minTimestamp;
            Instant instant = minTimestamp = this.lastConsensusTime == null ? null : ConsensusUtils.calcMinTimestampForNextEvent(this.lastConsensusTime);
            if (minTimestamp != null && e.getPreliminaryConsensusTimestamp().isBefore(minTimestamp)) {
                e.setPreliminaryConsensusTimestamp(minTimestamp);
            }
            e.getBaseEvent().setConsensusData(new EventConsensusData(HapiUtils.asTimestamp((Instant)e.getPreliminaryConsensusTimestamp()), this.numConsensus));
            this.lastConsensusTime = EventUtils.getLastTransTime(e.getBaseEvent());
            ++this.numConsensus;
            this.consensusMetrics.consensusReached(e);
        }
    }

    private boolean nonConsensusNonAncient(@NonNull EventImpl e) {
        return !e.isConsensus() && !this.ancient(e);
    }

    @Nullable
    private EventImpl timedStronglySeeP(@Nullable EventImpl x, long m) {
        long t = System.nanoTime();
        EventImpl result = this.stronglySeeP(x, m);
        t = System.nanoTime() - t;
        this.consensusMetrics.dotProductTime(t);
        return result;
    }

    private static boolean notRelevantForConsensus(@NonNull EventImpl e) {
        return e.getRoundCreated() == 0L;
    }

    private boolean witness(@NonNull EventImpl x) {
        return this.round(x) > 0L && (!x.hasSelfParent() || this.round(x) != this.round(this.selfParent(x)));
    }

    @Nullable
    private EventImpl selfParent(@NonNull EventImpl x) {
        return this.ancient((EventImpl)x.getSelfParent()) ? null : (EventImpl)x.getSelfParent();
    }

    private boolean ancient(@Nullable EventImpl x) {
        return x == null || x.getBirthRound() < this.rounds.getAncientThreshold();
    }

    private long parentRound(@Nullable EventImpl x) {
        if (x == null) {
            return 0L;
        }
        long maxRound = 0L;
        for (EventImpl parent : x.getAllParents()) {
            if (this.ancient(parent)) continue;
            maxRound = Math.max(maxRound, this.round(parent));
        }
        return maxRound;
    }

    @Nullable
    private EventImpl lastSee(@Nullable EventImpl x, long m) {
        if (x == null) {
            return null;
        }
        if (ConsensusImpl.notRelevantForConsensus(x)) {
            return null;
        }
        if (x.sizeLastSee() != 0) {
            return x.getLastSee((int)m);
        }
        x.initLastSee(this.rosterLookup.numMembers());
        for (int mm = 0; mm < this.rosterLookup.numMembers(); ++mm) {
            if (this.rosterLookup.isIdAtIndex(x.getCreatorId(), mm)) {
                x.setLastSee(mm, x);
                continue;
            }
            if (x.getAllParents().isEmpty()) {
                x.setLastSee(mm, null);
                continue;
            }
            EventImpl latestEventSeen = null;
            EventImpl parentWhichSeesLatestEvent = null;
            for (EventImpl parent : x.getAllParents()) {
                EventImpl candidate;
                if (this.ancient(parent) || (candidate = this.lastSee(parent, mm)) == null) continue;
                if (latestEventSeen == null) {
                    latestEventSeen = candidate;
                    parentWhichSeesLatestEvent = parent;
                    continue;
                }
                if (this.round(candidate) <= this.round(latestEventSeen) && (candidate.getDeGen() <= latestEventSeen.getDeGen() || this.firstSee(parent, mm) != this.firstSee(parentWhichSeesLatestEvent, mm))) continue;
                latestEventSeen = candidate;
                parentWhichSeesLatestEvent = parent;
            }
            x.setLastSee(mm, latestEventSeen);
        }
        return x.getLastSee((int)m);
    }

    @Nullable
    private EventImpl seeThru(@Nullable EventImpl x, int m, int m2) {
        if (x == null) {
            return null;
        }
        if (ConsensusImpl.notRelevantForConsensus(x)) {
            return null;
        }
        if (m == m2 && this.rosterLookup.isIdAtIndex(x.getCreatorId(), m2)) {
            return this.firstSelfWitnessS(this.selfParent(x));
        }
        return this.firstSee(this.lastSee(x, m2), m);
    }

    @Nullable
    private EventImpl stronglySeeP(@Nullable EventImpl x, long m) {
        if (x == null) {
            return null;
        }
        if (ConsensusImpl.notRelevantForConsensus(x)) {
            return null;
        }
        if (x.sizeStronglySeeP() != 0) {
            return x.getStronglySeeP((int)m);
        }
        long prx = this.parentRound(x);
        x.initStronglySeeP(this.rosterLookup.numMembers());
        block0: for (int mm = 0; mm < this.rosterLookup.numMembers(); ++mm) {
            for (EventImpl parent : x.getAllParents()) {
                if (this.ancient(parent) || this.stronglySeeP(parent, mm) == null || this.parentRound(parent) != prx) continue;
                x.setStronglySeeP(mm, this.stronglySeeP(parent, mm));
                continue block0;
            }
            EventImpl st = this.seeThru(x, mm, mm);
            if (this.round(st) != prx) {
                x.setStronglySeeP(mm, null);
                continue;
            }
            long weight = 0L;
            for (int m3 = 0; m3 < this.rosterLookup.numMembers(); ++m3) {
                if (this.seeThru(x, mm, m3) != st) continue;
                weight += this.rosterLookup.getWeight(m3);
            }
            if (Threshold.SUPER_MAJORITY.isSatisfiedBy(weight, this.rosterLookup.rosterTotalWeight())) {
                x.setStronglySeeP(mm, st);
                continue;
            }
            x.setStronglySeeP(mm, null);
        }
        return x.getStronglySeeP((int)m);
    }

    private long round(@Nullable EventImpl x) {
        if (x == null) {
            return 0L;
        }
        if (x.getRoundCreated() >= 0L) {
            return x.getRoundCreated();
        }
        if (this.rounds.isOlderThanDecidedRoundGeneration(x) || x.isConsensus()) {
            x.setRoundCreated(0L);
            return 0L;
        }
        if (x.getAllParents().isEmpty()) {
            x.setRoundCreated(1L);
            return x.getRoundCreated();
        }
        long greatestParentRound = 0L;
        long previousParentRound = Long.MIN_VALUE;
        boolean allParentsHaveTheSameRound = true;
        for (EventImpl parent : x.getAllParents()) {
            if (this.ancient(parent)) continue;
            long parentRound = this.round(parent);
            if (parentRound > greatestParentRound) {
                greatestParentRound = parentRound;
            }
            if (previousParentRound != Long.MIN_VALUE && parentRound != previousParentRound) {
                allParentsHaveTheSameRound = false;
            }
            previousParentRound = parentRound;
        }
        if (!allParentsHaveTheSameRound && !this.rosterLookup.nodeHasSupermajorityWeight()) {
            x.setRoundCreated(greatestParentRound);
            return x.getRoundCreated();
        }
        if (greatestParentRound == 0L) {
            x.setRoundCreated(0L);
            return x.getRoundCreated();
        }
        int numMembers = this.rosterLookup.numMembers();
        long weight = 0L;
        int numStronglySeen = 0;
        for (int m = 0; m < numMembers; ++m) {
            if (this.timedStronglySeeP(x, m) == null) continue;
            weight += this.rosterLookup.getWeight(m);
            ++numStronglySeen;
        }
        this.consensusMetrics.witnessesStronglySeen(numStronglySeen);
        if (Threshold.SUPER_MAJORITY.isSatisfiedBy(weight, this.rosterLookup.rosterTotalWeight())) {
            x.setRoundCreated(1L + this.parentRound(x));
            this.consensusMetrics.roundIncrementedByStronglySeen();
            return x.getRoundCreated();
        }
        x.setRoundCreated(this.parentRound(x));
        return x.getRoundCreated();
    }

    @Nullable
    private EventImpl firstSelfWitnessS(@Nullable EventImpl x) {
        if (x == null) {
            return null;
        }
        if (ConsensusImpl.notRelevantForConsensus(x)) {
            return null;
        }
        if (x.getFirstSelfWitnessS() != null) {
            return x.getFirstSelfWitnessS();
        }
        if (this.round(x) > this.round(this.selfParent(x))) {
            x.setFirstSelfWitnessS(x);
        } else {
            x.setFirstSelfWitnessS(this.firstSelfWitnessS(this.selfParent(x)));
        }
        return x.getFirstSelfWitnessS();
    }

    @Nullable
    private EventImpl firstWitnessS(@Nullable EventImpl x) {
        if (x == null) {
            return null;
        }
        if (ConsensusImpl.notRelevantForConsensus(x)) {
            return null;
        }
        if (x.getFirstWitnessS() != null) {
            return x.getFirstWitnessS();
        }
        if (this.round(x) > this.parentRound(x)) {
            x.setFirstWitnessS(x);
            return x;
        }
        for (EventImpl parent : x.getAllParents()) {
            if (this.round(parent) != this.round(x)) continue;
            x.setFirstWitnessS(this.firstWitnessS(parent));
            return x.getFirstWitnessS();
        }
        x.setFirstWitnessS(x);
        return x;
    }

    @Nullable
    private EventImpl stronglySeeS1(@Nullable EventImpl x, long m) {
        return this.timedStronglySeeP(this.firstWitnessS(x), m);
    }

    @Nullable
    private EventImpl firstSee(@Nullable EventImpl x, long m) {
        return this.firstSelfWitnessS(this.lastSee(x, m));
    }

    @Override
    public long getMaxRound() {
        return this.rounds.getMaxRound();
    }

    @Override
    public long getFameDecidedBelow() {
        return this.rounds.getFameDecidedBelow();
    }
}

