/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.service.registry.ActivationPhase;
import io.helidon.service.registry.ActivationRequestBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.service.registry.ActivationRequestBlueprint")
public interface ActivationRequest
extends ActivationRequestBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ActivationRequest instance) {
        return (Builder)ActivationRequest.builder().from(instance);
    }

    public static ActivationRequest create() {
        return ActivationRequest.builder().buildPrototype();
    }

    @Override
    public Optional<ActivationPhase> startingPhase();

    @Override
    public ActivationPhase targetPhase();

    @Override
    public boolean throwIfError();

    public static class Builder
    extends BuilderBase<Builder, ActivationRequest>
    implements io.helidon.common.Builder<Builder, ActivationRequest> {
        private Builder() {
        }

        public ActivationRequest buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ActivationRequestImpl(this);
        }

        public ActivationRequest build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ActivationRequest>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private ActivationPhase startingPhase;
        private ActivationPhase targetPhase;
        private boolean throwIfError = true;

        protected BuilderBase() {
        }

        public BUILDER from(ActivationRequest prototype) {
            this.startingPhase(prototype.startingPhase());
            this.targetPhase(prototype.targetPhase());
            this.throwIfError(prototype.throwIfError());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.startingPhase().ifPresent(this::startingPhase);
            builder.targetPhase().ifPresent(this::targetPhase);
            this.throwIfError(builder.throwIfError());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearStartingPhase() {
            this.startingPhase = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER startingPhase(ActivationPhase startingPhase) {
            Objects.requireNonNull(startingPhase);
            this.startingPhase = startingPhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER targetPhase(ActivationPhase targetPhase) {
            Objects.requireNonNull(targetPhase);
            this.targetPhase = targetPhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER throwIfError(boolean throwIfError) {
            this.throwIfError = throwIfError;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ActivationPhase> startingPhase() {
            return Optional.ofNullable(this.startingPhase);
        }

        public Optional<ActivationPhase> targetPhase() {
            return Optional.ofNullable(this.targetPhase);
        }

        public boolean throwIfError() {
            return this.throwIfError;
        }

        public String toString() {
            return "ActivationRequestBuilder{startingPhase=" + String.valueOf((Object)this.startingPhase) + ",targetPhase=" + String.valueOf((Object)this.targetPhase) + ",throwIfError=" + this.throwIfError + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.targetPhase == null) {
                collector.fatal(this.getClass(), "Property \"targetPhase\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER startingPhase(Optional<? extends ActivationPhase> startingPhase) {
            Objects.requireNonNull(startingPhase);
            this.startingPhase = startingPhase.map(ActivationPhase.class::cast).orElse(this.startingPhase);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ActivationRequestImpl
        implements ActivationRequest {
            private final ActivationPhase targetPhase;
            private final boolean throwIfError;
            private final Optional<ActivationPhase> startingPhase;

            protected ActivationRequestImpl(BuilderBase<?, ?> builder) {
                this.startingPhase = builder.startingPhase().map(Function.identity());
                this.targetPhase = builder.targetPhase().get();
                this.throwIfError = builder.throwIfError();
            }

            @Override
            public Optional<ActivationPhase> startingPhase() {
                return this.startingPhase;
            }

            @Override
            public ActivationPhase targetPhase() {
                return this.targetPhase;
            }

            @Override
            public boolean throwIfError() {
                return this.throwIfError;
            }

            public String toString() {
                return "ActivationRequest{startingPhase=" + String.valueOf(this.startingPhase) + ",targetPhase=" + String.valueOf((Object)this.targetPhase) + ",throwIfError=" + this.throwIfError + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ActivationRequest)) {
                    return false;
                }
                ActivationRequest other = (ActivationRequest)o;
                return Objects.equals(this.startingPhase, other.startingPhase()) && Objects.equals((Object)this.targetPhase, (Object)other.targetPhase()) && this.throwIfError == other.throwIfError();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.startingPhase, this.targetPhase, this.throwIfError});
            }
        }
    }
}

