/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AddressIdConverter;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.ClassicTransfersCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.Erc721TransferFromTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.SpecialRewardReceivers;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.TransferEventLoggingUtils;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class Erc721TransferFromCall
extends AbstractCall {
    private final long serialNo;
    private final Address from;
    private final Address to;
    private final TokenID tokenId;
    private final VerificationStrategy verificationStrategy;
    private final AccountID senderId;
    private final AddressIdConverter addressIdConverter;
    private final SpecialRewardReceivers specialRewardReceivers;

    public Erc721TransferFromCall(long serialNo, @NonNull Address from, @NonNull Address to, @NonNull TokenID tokenId, @NonNull VerificationStrategy verificationStrategy, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull SystemContractGasCalculator gasCalculator, @NonNull AccountID senderId, @NonNull AddressIdConverter addressIdConverter, @NonNull SpecialRewardReceivers specialRewardReceivers) {
        super(gasCalculator, enhancement, false);
        this.from = Objects.requireNonNull(from);
        this.to = Objects.requireNonNull(to);
        this.tokenId = tokenId;
        this.verificationStrategy = Objects.requireNonNull(verificationStrategy);
        this.senderId = Objects.requireNonNull(senderId);
        this.addressIdConverter = Objects.requireNonNull(addressIdConverter);
        this.serialNo = serialNo;
        this.specialRewardReceivers = Objects.requireNonNull(specialRewardReceivers);
    }

    @Override
    @NonNull
    public Call.PricedResult execute(MessageFrame frame) {
        if (this.tokenId == null) {
            return this.reversionWith(ResponseCodeEnum.INVALID_TOKEN_ID, this.gasCalculator.canonicalGasRequirement(DispatchType.TRANSFER_NFT));
        }
        TransactionBody syntheticTransfer = this.syntheticTransfer(this.senderId);
        long gasRequirement = ClassicTransfersCall.transferGasRequirement(syntheticTransfer, this.gasCalculator, this.enhancement, this.senderId);
        ContractCallStreamBuilder recordBuilder = this.systemContractOperations().dispatch(syntheticTransfer, this.verificationStrategy, this.senderId, ContractCallStreamBuilder.class);
        ResponseCodeEnum status = recordBuilder.status();
        if (status != ResponseCodeEnum.SUCCESS) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(recordBuilder, gasRequirement), status, false);
        }
        NftTransfer nftTransfer = (NftTransfer)((TokenTransferList)syntheticTransfer.cryptoTransferOrThrow().tokenTransfers().get(0)).nftTransfers().get(0);
        TransferEventLoggingUtils.logSuccessfulNftTransfer(this.tokenId, nftTransfer, this.readableAccountStore(), frame);
        return Call.PricedResult.gasOnly(FullResult.successResult(Erc721TransferFromTranslator.ERC_721_TRANSFER_FROM.getOutputs().encode((Object)Tuple.EMPTY), gasRequirement, recordBuilder), status, false);
    }

    private TransactionBody syntheticTransfer(@NonNull AccountID spenderId) {
        AccountID ownerId = this.getOwner();
        AccountID fromId = this.addressIdConverter.convert(this.from);
        AccountID receiverId = this.addressIdConverter.convertCredit(this.to);
        return TransactionBody.newBuilder().cryptoTransfer(CryptoTransferTransactionBody.newBuilder().tokenTransfers(new TokenTransferList[]{TokenTransferList.newBuilder().token(this.tokenId).nftTransfers(new NftTransfer[]{NftTransfer.newBuilder().serialNumber(this.serialNo).senderAccountID(fromId).receiverAccountID(receiverId).isApproval(!spenderId.equals((Object)ownerId)).build()}).build()})).build();
    }

    @Nullable
    private AccountID getOwner() {
        Nft nft = this.nativeOperations().getNft(this.tokenId, this.serialNo);
        Token token = this.nativeOperations().getToken(this.tokenId);
        return nft != null ? nft.ownerIdOrElse(token.treasuryAccountIdOrThrow()) : null;
    }
}

