/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.tracers;

import com.hedera.hapi.streams.ContractAction;
import com.hedera.hapi.streams.ContractActionType;
import com.hedera.node.app.service.contract.impl.exec.ActionSidecarContentTracer;
import com.hedera.node.app.service.contract.impl.exec.utils.ActionStack;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.operation.Operation;

public class EvmActionTracer
implements ActionSidecarContentTracer {
    private static final Logger log = LogManager.getLogger(EvmActionTracer.class);
    private final ActionStack actionStack;

    public EvmActionTracer(@NonNull ActionStack actionStack) {
        this.actionStack = Objects.requireNonNull(actionStack);
    }

    @Override
    public void traceOriginAction(@NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        if (FrameUtils.hasActionSidecarsEnabled(frame)) {
            this.actionStack.pushActionOfTopLevel(frame);
        }
    }

    @Override
    public void sanitizeTracedActions(@NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        if (FrameUtils.hasValidatedActionSidecarsEnabled(frame)) {
            this.actionStack.sanitizeFinalActionsAndLogAnomalies(frame, log, Level.WARN);
        }
    }

    public void tracePostExecution(@NonNull MessageFrame frame, @NonNull Operation.OperationResult operationResult) {
        Objects.requireNonNull(frame);
        Objects.requireNonNull(operationResult);
        if (!FrameUtils.hasActionSidecarsEnabled(frame)) {
            return;
        }
        MessageFrame.State state = frame.getState();
        if (state == MessageFrame.State.CODE_SUSPENDED) {
            this.actionStack.pushActionOfIntermediate(frame);
        } else if (state != MessageFrame.State.CODE_EXECUTING) {
            this.actionStack.finalizeLastAction(frame, this.stackValidationChoice(frame));
        }
    }

    @Override
    public void tracePrecompileResult(@NonNull MessageFrame frame, @NonNull ContractActionType type) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(frame);
        if (FrameUtils.hasActionSidecarsEnabled(frame)) {
            this.actionStack.finalizeLastStackActionAsPrecompile(frame, type, this.stackValidationChoice(frame));
        }
    }

    @Override
    @NonNull
    public List<ContractAction> contractActions() {
        return this.actionStack.asContractActions();
    }

    public void traceAccountCreationResult(@NonNull MessageFrame frame, @NonNull Optional<ExceptionalHaltReason> haltReason) {
        Objects.requireNonNull(frame);
        Objects.requireNonNull(haltReason);
        if (FrameUtils.hasActionSidecarsEnabled(frame) && haltReason.isPresent() && !this.actionStack.isEmpty()) {
            this.actionStack.finalizeLastAction(frame, this.stackValidationChoice(frame));
        }
    }

    private ActionStack.Validation stackValidationChoice(@NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        return FrameUtils.hasActionValidationEnabled(frame) ? ActionStack.Validation.ON : ActionStack.Validation.OFF;
    }
}

