/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.v038;

import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HederaSystemContract;
import com.hedera.node.app.service.contract.impl.exec.v030.Version030AddressChecks;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hyperledger.besu.datatypes.Address;

@Singleton
public class Version038AddressChecks
extends Version030AddressChecks {
    private static final int FIRST_USER_ACCOUNT = 1001;
    private final EntityIdFactory entityIdFactory;

    @Inject
    public Version038AddressChecks(@NonNull Map<Address, HederaSystemContract> systemContracts, @NonNull EntityIdFactory entityIdFactory) {
        super(systemContracts);
        this.entityIdFactory = entityIdFactory;
    }

    @Override
    public boolean isSystemAccount(@NonNull Address address) {
        if (address.numberOfLeadingZeroBytes() >= 18 && address.getInt(16) <= 750) {
            return true;
        }
        return ConversionUtils.isLongZero(address) && ConversionUtils.numberOfLongZero(address.toArray()) <= 750L;
    }

    @Override
    public boolean isNonUserAccount(@NonNull Address address) {
        if (address.numberOfLeadingZeroBytes() >= 18 && address.getInt(16) < 1001) {
            return true;
        }
        return ConversionUtils.isLongZero(address) && ConversionUtils.numberOfLongZero(address.toArray()) < 1001L;
    }
}

