/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.contractvalidation;

import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.code.CodeInvalid;
import org.hyperledger.besu.evm.contractvalidation.ContractValidationRule;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EOFValidationCodeRule
implements ContractValidationRule {
    private static final Logger LOG = LoggerFactory.getLogger(EOFValidationCodeRule.class);
    final int maxEofVersion;

    private EOFValidationCodeRule(int maxEofVersion) {
        this.maxEofVersion = maxEofVersion;
    }

    @Override
    public Optional<ExceptionalHaltReason> validate(Bytes contractCode, MessageFrame frame, EVM evm) {
        Code code = evm.getCode(Hash.hash((Bytes)contractCode), contractCode);
        if (!code.isValid()) {
            LOG.trace("EOF Validation Error: {}", (Object)((CodeInvalid)code).getInvalidReason());
            return Optional.of(ExceptionalHaltReason.INVALID_CODE);
        }
        if (frame.getCode().getEofVersion() != code.getEofVersion()) {
            LOG.trace("Cannot deploy older eof versions: initcode version - {} runtime code version - {}", (Object)frame.getCode().getEofVersion(), (Object)code.getEofVersion());
            return Optional.of(ExceptionalHaltReason.EOF_CREATE_VERSION_INCOMPATIBLE);
        }
        return Optional.empty();
    }

    @Deprecated(forRemoval=true, since="24.6.1")
    public static ContractValidationRule of(int maxEofVersion) {
        return new EOFValidationCodeRule(maxEofVersion);
    }

    public static ContractValidationRule from(EVM evm) {
        return new EOFValidationCodeRule(evm.getMaxEOFVersion());
    }
}

