/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.gascalculator.SpuriousDragonGasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.precompile.BigIntegerModularExponentiationPrecompiledContract;

public class ByzantiumGasCalculator
extends SpuriousDragonGasCalculator {
    private static final int GQUADDIVISOR = 20;
    private static final int WORD_SIZE = 32;
    private static final int BITS_IN_BYTE = 8;
    public static final int MAX_FIRST_EXPONENT_BYTES = 32;

    @Override
    public long modExpGasCost(Bytes input) {
        long baseLength = BigIntegerModularExponentiationPrecompiledContract.baseLength(input);
        long exponentLength = BigIntegerModularExponentiationPrecompiledContract.exponentLength(input);
        long modulusLength = BigIntegerModularExponentiationPrecompiledContract.modulusLength(input);
        long exponentOffset = Words.clampedAdd(96L, baseLength);
        long firstExponentBytesCap = Math.min(exponentLength, 32L);
        BigInteger firstExpBytes = BigIntegerModularExponentiationPrecompiledContract.extractParameter(input, Words.clampedToInt(exponentOffset), Words.clampedToInt(firstExponentBytesCap));
        long adjustedExponentLength = ByzantiumGasCalculator.adjustedExponentLength(exponentLength, firstExpBytes);
        long multiplicationComplexity = BigIntegerModularExponentiationPrecompiledContract.multiplicationComplexity(Math.max(baseLength, modulusLength));
        long numerator = Words.clampedMultiply(multiplicationComplexity, Math.max(adjustedExponentLength, 1L));
        return numerator == Long.MAX_VALUE ? Long.MAX_VALUE : numerator / 20L;
    }

    public static long adjustedExponentLength(long exponentLength, BigInteger firstExpBytes) {
        int bitLength = ByzantiumGasCalculator.bitLength(firstExpBytes);
        if (exponentLength < 32L) {
            return bitLength;
        }
        return Words.clampedAdd(Words.clampedMultiply(8L, exponentLength - 32L), bitLength);
    }

    private static int bitLength(BigInteger n) {
        return n.compareTo(BigInteger.ZERO) == 0 ? 0 : n.bitLength() - 1;
    }
}

