/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.crypto.Hash;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class Keccak256Operation
extends AbstractOperation {
    public Keccak256Operation(GasCalculator gasCalculator) {
        super(32, "KECCAK256", 2, 1, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long from = Words.clampedToLong(frame.popStackItem());
        long length = Words.clampedToLong(frame.popStackItem());
        long cost = this.gasCalculator().keccak256OperationGasCost(frame, from, length);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        MutableBytes bytes = frame.readMutableMemory(from, length);
        frame.pushStackItem((Bytes)Hash.keccak256((Bytes)bytes));
        return new Operation.OperationResult(cost, null);
    }
}

