/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.ReturnStack;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class RetFOperation
extends AbstractOperation {
    public static final int OPCODE = 228;
    static final Operation.OperationResult retfSuccess = new Operation.OperationResult(3L, null);

    public RetFOperation(GasCalculator gasCalculator) {
        super(228, "RETF", 0, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        ReturnStack rStack = frame.getReturnStack();
        ReturnStack.ReturnStackItem returnInfo = (ReturnStack.ReturnStackItem)rStack.pop();
        frame.setPC(returnInfo.pc());
        frame.setSection(returnInfo.codeSectionIndex());
        return retfSuccess;
    }
}

