/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.stack.savepoints;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.blocks.impl.BlockStreamBuilder;
import com.hedera.node.app.blocks.impl.PairedStreamBuilder;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.state.WrappedState;
import com.hedera.node.app.workflows.handle.record.RecordStreamBuilder;
import com.hedera.node.app.workflows.handle.stack.BuilderSink;
import com.hedera.node.app.workflows.handle.stack.Savepoint;
import com.hedera.node.app.workflows.handle.stack.savepoints.BuilderSinkImpl;
import com.hedera.node.config.types.StreamMode;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public abstract class AbstractSavepoint
extends BuilderSinkImpl
implements Savepoint {
    public static final EnumSet<ResponseCodeEnum> SUCCESSES = EnumSet.of(ResponseCodeEnum.OK, ResponseCodeEnum.SUCCESS, ResponseCodeEnum.FEE_SCHEDULE_FILE_PART_UPLOADED, ResponseCodeEnum.SUCCESS_BUT_MISSING_EXPECTED_OPERATION);
    protected final BuilderSink parent;
    protected final WrappedState state;
    private Status status = Status.PENDING;
    private long nodeFeesCollected = 0L;

    protected AbstractSavepoint(@NonNull WrappedState state, @NonNull BuilderSink parent, int maxPreceding, int maxFollowing) {
        super(maxPreceding, maxFollowing);
        this.state = Objects.requireNonNull(state);
        this.parent = Objects.requireNonNull(parent);
    }

    protected AbstractSavepoint(@NonNull WrappedState state, @NonNull BuilderSink parent, int maxTotal) {
        super(maxTotal);
        this.state = Objects.requireNonNull(state);
        this.parent = Objects.requireNonNull(parent);
    }

    @Override
    public State state() {
        return this.state;
    }

    @Override
    public void commit() {
        this.assertNotFinished();
        this.commitBuilders();
        this.state.commit();
        this.status = Status.FINISHED;
        BuilderSink builderSink = this.parent;
        if (builderSink instanceof Savepoint) {
            Savepoint savepoint = (Savepoint)builderSink;
            savepoint.trackCollectedNodeFee(this.nodeFeesCollected);
        }
    }

    @Override
    public void rollback() {
        this.assertNotFinished();
        this.rollback(this.precedingBuilders);
        this.rollback(this.followingBuilders);
        this.commitBuilders();
        this.status = Status.FINISHED;
        this.nodeFeesCollected = 0L;
    }

    @Override
    public StreamBuilder createBuilder(@NonNull StreamBuilder.ReversingBehavior reversingBehavior, @NonNull HandleContext.TransactionCategory txnCategory, @NonNull StreamBuilder.SignedTxCustomizer customizer, @NonNull StreamMode streamMode, boolean isBaseBuilder) {
        Object builder;
        Objects.requireNonNull(reversingBehavior);
        Objects.requireNonNull(txnCategory);
        Objects.requireNonNull(customizer);
        switch (streamMode) {
            default: {
                throw new MatchException(null, null);
            }
            case RECORDS: {
                Object object = new RecordStreamBuilder(reversingBehavior, customizer, txnCategory);
                break;
            }
            case BLOCKS: {
                Object object = new BlockStreamBuilder(reversingBehavior, customizer, txnCategory);
                break;
            }
            case BOTH: {
                Object object = builder = new PairedStreamBuilder(reversingBehavior, customizer, txnCategory);
            }
        }
        if (!customizer.isSuppressed()) {
            if (txnCategory == HandleContext.TransactionCategory.PRECEDING && !isBaseBuilder) {
                this.addPrecedingOrThrow((StreamBuilder)builder);
            } else {
                this.addFollowingOrThrow((StreamBuilder)builder);
            }
        }
        return builder;
    }

    @Override
    public void trackCollectedNodeFee(long amount) {
        this.nodeFeesCollected += amount;
    }

    @Override
    public void trackRefundedNodeFee(long amount) {
        this.nodeFeesCollected -= amount;
    }

    @Override
    public long getNodeFeesCollected() {
        return this.nodeFeesCollected;
    }

    abstract void commitBuilders();

    private void rollback(@NonNull List<StreamBuilder> builders) {
        ListIterator<StreamBuilder> iterator = builders.listIterator();
        while (iterator.hasNext()) {
            StreamBuilder builder = iterator.next();
            if (builder.reversingBehavior() == StreamBuilder.ReversingBehavior.REVERSIBLE) {
                builder.nullOutSideEffectFields();
                if (!SUCCESSES.contains(builder.status())) continue;
                builder.status(ResponseCodeEnum.REVERTED_SUCCESS);
                continue;
            }
            if (builder.reversingBehavior() != StreamBuilder.ReversingBehavior.REMOVABLE) continue;
            iterator.remove();
        }
    }

    private void assertNotFinished() {
        if (this.status == Status.FINISHED) {
            throw new IllegalStateException("Savepoint has already been committed or rolled back");
        }
    }

    private static enum Status {
        PENDING,
        FINISHED;

    }
}

