/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.query;

import com.hedera.hapi.node.transaction.Query;
import com.hedera.node.app.spi.workflows.QueryHandler;
import com.hedera.node.app.workflows.query.QueryHandlers;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class QueryDispatcher {
    private static final String QUERY_NOT_SET = "Query not set";
    private final QueryHandlers handlers;

    @Inject
    public QueryDispatcher(@NonNull QueryHandlers handlers) {
        this.handlers = Objects.requireNonNull(handlers);
    }

    @NonNull
    public QueryHandler getHandler(@NonNull Query query) {
        return switch ((Query.QueryOneOfType)query.query().kind()) {
            default -> throw new MatchException(null, null);
            case Query.QueryOneOfType.CONSENSUS_GET_TOPIC_INFO -> this.handlers.consensusGetTopicInfoHandler();
            case Query.QueryOneOfType.GET_BY_SOLIDITY_ID -> this.handlers.contractGetBySolidityIDHandler();
            case Query.QueryOneOfType.CONTRACT_CALL_LOCAL -> this.handlers.contractCallLocalHandler();
            case Query.QueryOneOfType.CONTRACT_GET_INFO -> this.handlers.contractGetInfoHandler();
            case Query.QueryOneOfType.CONTRACT_GET_BYTECODE -> this.handlers.contractGetBytecodeHandler();
            case Query.QueryOneOfType.CONTRACT_GET_RECORDS -> this.handlers.contractGetRecordsHandler();
            case Query.QueryOneOfType.CRYPTOGET_ACCOUNT_BALANCE -> this.handlers.cryptoGetAccountBalanceHandler();
            case Query.QueryOneOfType.CRYPTO_GET_INFO -> this.handlers.cryptoGetAccountInfoHandler();
            case Query.QueryOneOfType.CRYPTO_GET_ACCOUNT_RECORDS -> this.handlers.cryptoGetAccountRecordsHandler();
            case Query.QueryOneOfType.CRYPTO_GET_LIVE_HASH -> this.handlers.cryptoGetLiveHashHandler();
            case Query.QueryOneOfType.CRYPTO_GET_PROXY_STAKERS -> this.handlers.cryptoGetStakersHandler();
            case Query.QueryOneOfType.FILE_GET_CONTENTS -> this.handlers.fileGetContentsHandler();
            case Query.QueryOneOfType.FILE_GET_INFO -> this.handlers.fileGetInfoHandler();
            case Query.QueryOneOfType.ACCOUNT_DETAILS -> this.handlers.networkGetAccountDetailsHandler();
            case Query.QueryOneOfType.GET_BY_KEY -> this.handlers.networkGetByKeyHandler();
            case Query.QueryOneOfType.NETWORK_GET_VERSION_INFO -> this.handlers.networkGetVersionInfoHandler();
            case Query.QueryOneOfType.NETWORK_GET_EXECUTION_TIME -> this.handlers.networkGetExecutionTimeHandler();
            case Query.QueryOneOfType.TRANSACTION_GET_RECEIPT -> this.handlers.networkTransactionGetReceiptHandler();
            case Query.QueryOneOfType.TRANSACTION_GET_RECORD -> this.handlers.networkTransactionGetRecordHandler();
            case Query.QueryOneOfType.TRANSACTION_GET_FAST_RECORD -> this.handlers.networkTransactionGetFastRecordHandler();
            case Query.QueryOneOfType.SCHEDULE_GET_INFO -> this.handlers.scheduleGetInfoHandler();
            case Query.QueryOneOfType.TOKEN_GET_INFO -> this.handlers.tokenGetInfoHandler();
            case Query.QueryOneOfType.TOKEN_GET_ACCOUNT_NFT_INFOS -> this.handlers.tokenGetAccountNftInfosHandler();
            case Query.QueryOneOfType.TOKEN_GET_NFT_INFO -> this.handlers.tokenGetNftInfoHandler();
            case Query.QueryOneOfType.TOKEN_GET_NFT_INFOS -> this.handlers.tokenGetNftInfosHandler();
            case Query.QueryOneOfType.UNSET -> throw new UnsupportedOperationException(QUERY_NOT_SET);
        };
    }
}

