/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.utils;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.gas.TinybarValues;
import com.hedera.node.app.service.contract.impl.exec.utils.InvalidAddressContext;
import com.hedera.node.app.service.contract.impl.exec.utils.OpsDurationCounter;
import com.hedera.node.app.service.contract.impl.exec.utils.PendingCreationMetadata;
import com.hedera.node.app.service.contract.impl.exec.utils.PendingCreationMetadataRef;
import com.hedera.node.app.service.contract.impl.exec.utils.PropagatedCallFailureRef;
import com.hedera.node.app.service.contract.impl.hevm.HevmPropagatedCallFailure;
import com.hedera.node.app.service.contract.impl.infra.StorageAccessTracker;
import com.hedera.node.app.service.contract.impl.records.ContractOperationStreamBuilder;
import com.hedera.node.app.service.contract.impl.state.HederaEvmAccount;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.spi.workflows.record.DeleteCapableTransactionStreamBuilder;
import com.hedera.node.config.data.ContractsConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class FrameUtils {
    public static final String CONFIG_CONTEXT_VARIABLE = "contractsConfig";
    public static final String TRACKER_CONTEXT_VARIABLE = "storageAccessTracker";
    public static final String ACTION_SIDECARS_VARIABLE = "actionSidecars";
    public static final String ACTION_SIDECARS_VALIDATION_VARIABLE = "actionSidecarsValidation";
    public static final String BYTECODE_SIDECARS_VARIABLE = "bytecodeSidecars";
    public static final String TINYBAR_VALUES_CONTEXT_VARIABLE = "tinybarValues";
    public static final String HAPI_RECORD_BUILDER_CONTEXT_VARIABLE = "hapiRecordBuilder";
    public static final String PROPAGATED_CALL_FAILURE_CONTEXT_VARIABLE = "propagatedCallFailure";
    public static final String SYSTEM_CONTRACT_GAS_CALCULATOR_CONTEXT_VARIABLE = "systemContractGasCalculator";
    public static final String PENDING_CREATION_BUILDER_CONTEXT_VARIABLE = "pendingCreationBuilder";
    public static final String OPS_DURATION_COUNTER = "opsDurationCounter";
    public static final String INVALID_ADDRESS_CONTEXT_VARIABLE = "invalidAddressContext";
    public static final String HOOK_OWNER_ADDRESS = "hookOwnerAddress";

    private FrameUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    @NonNull
    public static Configuration configOf(@NonNull MessageFrame frame) {
        return Objects.requireNonNull((Configuration)FrameUtils.initialFrameOf(frame).getContextVariable(CONFIG_CONTEXT_VARIABLE));
    }

    @NonNull
    public static ContractsConfig contractsConfigOf(@NonNull MessageFrame frame) {
        return (ContractsConfig)FrameUtils.configOf(frame).getConfigData(ContractsConfig.class);
    }

    public static boolean hasBytecodeSidecarsEnabled(@NonNull MessageFrame frame) {
        return FrameUtils.initialFrameOf(frame).hasContextVariable(BYTECODE_SIDECARS_VARIABLE);
    }

    public static boolean hasActionSidecarsEnabled(@NonNull MessageFrame frame) {
        return FrameUtils.initialFrameOf(frame).hasContextVariable(ACTION_SIDECARS_VARIABLE);
    }

    public static boolean hasActionValidationEnabled(@NonNull MessageFrame frame) {
        return FrameUtils.initialFrameOf(frame).hasContextVariable(ACTION_SIDECARS_VALIDATION_VARIABLE);
    }

    public static boolean hasValidatedActionSidecarsEnabled(@NonNull MessageFrame frame) {
        MessageFrame initialFrame = FrameUtils.initialFrameOf(frame);
        return initialFrame.hasContextVariable(ACTION_SIDECARS_VARIABLE) && initialFrame.hasContextVariable(ACTION_SIDECARS_VALIDATION_VARIABLE);
    }

    @Nullable
    public static StorageAccessTracker accessTrackerFor(@NonNull MessageFrame frame) {
        return (StorageAccessTracker)FrameUtils.initialFrameOf(frame).getContextVariable(TRACKER_CONTEXT_VARIABLE);
    }

    public static void setPropagatedCallFailure(@NonNull MessageFrame frame, @NonNull HevmPropagatedCallFailure failure) {
        Objects.requireNonNull(frame);
        Objects.requireNonNull(failure);
        FrameUtils.propagatedCallFailureReference(frame).set(failure);
    }

    @NonNull
    public static HevmPropagatedCallFailure getAndClearPropagatedCallFailure(@NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        return FrameUtils.propagatedCallFailureReference(frame).getAndClear();
    }

    @NonNull
    public static PendingCreationMetadata getAndClearPendingCreationMetadata(@NonNull MessageFrame frame, @NonNull ContractID contractID) {
        Objects.requireNonNull(frame);
        Objects.requireNonNull(contractID);
        return FrameUtils.pendingCreationMetadataRef(frame).getAndClearOrThrowFor(contractID);
    }

    @NonNull
    public static ProxyWorldUpdater proxyUpdaterFor(@NonNull MessageFrame frame) {
        return (ProxyWorldUpdater)frame.getWorldUpdater();
    }

    @NonNull
    public static TinybarValues tinybarValuesFor(@NonNull MessageFrame frame) {
        return (TinybarValues)FrameUtils.initialFrameOf(frame).getContextVariable(TINYBAR_VALUES_CONTEXT_VARIABLE);
    }

    @NonNull
    public static DeleteCapableTransactionStreamBuilder selfDestructBeneficiariesFor(@NonNull MessageFrame frame) {
        return Objects.requireNonNull((DeleteCapableTransactionStreamBuilder)FrameUtils.initialFrameOf(frame).getContextVariable(HAPI_RECORD_BUILDER_CONTEXT_VARIABLE));
    }

    public static boolean isTopLevelTransaction(@NonNull MessageFrame frame) {
        return FrameUtils.initialFrameOf(frame).hasContextVariable(HAPI_RECORD_BUILDER_CONTEXT_VARIABLE);
    }

    @NonNull
    public static ContractOperationStreamBuilder recordBuilderFor(@NonNull MessageFrame frame) {
        return Objects.requireNonNull((ContractOperationStreamBuilder)FrameUtils.initialFrameOf(frame).getContextVariable(HAPI_RECORD_BUILDER_CONTEXT_VARIABLE));
    }

    @NonNull
    public static SystemContractGasCalculator systemContractGasCalculatorOf(@NonNull MessageFrame frame) {
        return (SystemContractGasCalculator)FrameUtils.initialFrameOf(frame).getContextVariable(SYSTEM_CONTRACT_GAS_CALCULATOR_CONTEXT_VARIABLE);
    }

    public static boolean acquiredSenderAuthorizationViaDelegateCall(@NonNull MessageFrame frame) {
        Iterator iter = frame.getMessageFrameStack().iterator();
        MessageFrame executingFrame = (MessageFrame)iter.next();
        if (frame != executingFrame) {
            throw new IllegalArgumentException("Only the executing frame should be tested for delegate sender authorization");
        }
        if (!iter.hasNext()) {
            return false;
        }
        MessageFrame parent = (MessageFrame)iter.next();
        return FrameUtils.isDelegateCall(parent);
    }

    public static boolean isDelegateCall(@NonNull MessageFrame frame) {
        return !frame.getRecipientAddress().equals((Object)frame.getContractAddress());
    }

    public static boolean transfersValue(@NonNull MessageFrame frame) {
        return !frame.getValue().isZero();
    }

    public static boolean alreadyHalted(@NonNull MessageFrame frame) {
        return frame.getState() == MessageFrame.State.EXCEPTIONAL_HALT;
    }

    public static Optional<MessageFrame> maybeNext(@NonNull MessageFrame frame) {
        Deque stack = frame.getMessageFrameStack();
        Iterator frames = stack.iterator();
        return frames.hasNext() ? Optional.of((MessageFrame)frames.next()) : Optional.empty();
    }

    public static boolean stackIncludesActiveAddress(@NonNull MessageFrame frame, @NonNull Address address) {
        Iterator iter = frame.getMessageFrameStack().iterator();
        iter.next();
        while (iter.hasNext()) {
            MessageFrame ancestor = (MessageFrame)iter.next();
            if (!address.equals((Object)ancestor.getRecipientAddress())) continue;
            return true;
        }
        return false;
    }

    public static CallType callTypeOf(MessageFrame frame, EntityType expectedEntityType) {
        CallType viableType;
        if (!FrameUtils.isDelegateCall(frame)) {
            return CallType.DIRECT_OR_PROXY_REDIRECT;
        }
        if (FrameUtils.isExpectedEntityType(frame, expectedEntityType)) {
            viableType = CallType.DIRECT_OR_PROXY_REDIRECT;
        } else if (FrameUtils.isQualifiedDelegate(frame.getRecipientAddress(), frame)) {
            viableType = CallType.QUALIFIED_DELEGATE;
        } else {
            return CallType.UNQUALIFIED_DELEGATE;
        }
        return FrameUtils.validateParentCallType(frame, viableType);
    }

    private static CallType validateParentCallType(@NonNull MessageFrame frame, @NonNull CallType viableType) {
        Objects.requireNonNull(frame);
        Objects.requireNonNull(viableType);
        Deque stack = frame.getMessageFrameStack();
        Iterator frames = stack.iterator();
        frames.next();
        if (!frames.hasNext()) {
            throw new IllegalStateException("No parent frame for delegate call");
        }
        return FrameUtils.isDelegateCall((MessageFrame)frames.next()) ? CallType.UNQUALIFIED_DELEGATE : viableType;
    }

    public static boolean contractRequired(@NonNull MessageFrame frame, @NonNull Address address, @NonNull FeatureFlags featureFlags) {
        Objects.requireNonNull(frame);
        Objects.requireNonNull(address);
        Objects.requireNonNull(featureFlags);
        Long maybeGrandfatheredNumber = null;
        if (ConversionUtils.isLongZero(address)) {
            try {
                maybeGrandfatheredNumber = ConversionUtils.asNumberedContractId(FrameUtils.entityIdFactory(frame), address).contractNum();
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return !featureFlags.isAllowCallsToNonContractAccountsEnabled(FrameUtils.contractsConfigOf(frame), maybeGrandfatheredNumber);
    }

    private static boolean isExpectedEntityType(MessageFrame frame, EntityType expectedEntity) {
        Objects.requireNonNull(frame);
        Address recipientAddress = frame.getRecipientAddress();
        ProxyWorldUpdater updater = (ProxyWorldUpdater)frame.getWorldUpdater();
        HederaEvmAccount recipient = updater.getHederaAccount(recipientAddress);
        if (recipient != null) {
            return switch (expectedEntity.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> recipient.isTokenFacade();
                case 1 -> recipient.isScheduleTxnFacade();
                case 2 -> recipient.isRegularAccount();
            };
        }
        return false;
    }

    @NonNull
    public static MessageFrame initialFrameOf(@NonNull MessageFrame frame) {
        Deque stack = frame.getMessageFrameStack();
        return stack.isEmpty() ? frame : (MessageFrame)stack.getLast();
    }

    private static PropagatedCallFailureRef propagatedCallFailureReference(@NonNull MessageFrame frame) {
        return (PropagatedCallFailureRef)FrameUtils.initialFrameOf(frame).getContextVariable(PROPAGATED_CALL_FAILURE_CONTEXT_VARIABLE);
    }

    private static PendingCreationMetadataRef pendingCreationMetadataRef(@NonNull MessageFrame frame) {
        return (PendingCreationMetadataRef)FrameUtils.initialFrameOf(frame).getContextVariable(PENDING_CREATION_BUILDER_CONTEXT_VARIABLE);
    }

    private static boolean isQualifiedDelegate(@NonNull Address recipient, @NonNull MessageFrame frame) {
        return ConversionUtils.isLongZero(recipient) && FrameUtils.contractsConfigOf(frame).permittedDelegateCallers().contains(ConversionUtils.numberOfLongZero(recipient));
    }

    public static boolean isPrecompileEnabled(@NonNull Address precompileAddress, @NonNull MessageFrame frame) {
        return FrameUtils.contractsConfigOf(frame).disabledPrecompiles().stream().map(Address::precompiled).filter(arg_0 -> ((Address)precompileAddress).equals(arg_0)).findAny().isEmpty();
    }

    public static boolean isHookExecution(@NonNull MessageFrame frame) {
        return FrameUtils.initialFrameOf(frame).getContextVariable(HOOK_OWNER_ADDRESS) != null;
    }

    public static Address hookOwnerAddress(@NonNull MessageFrame frame) {
        return (Address)FrameUtils.initialFrameOf(frame).getContextVariable(HOOK_OWNER_ADDRESS);
    }

    public static InvalidAddressContext invalidAddressContext(@NonNull MessageFrame frame) {
        return (InvalidAddressContext)FrameUtils.initialFrameOf(frame).getContextVariable(INVALID_ADDRESS_CONTEXT_VARIABLE);
    }

    public static EntityIdFactory entityIdFactory(@NonNull MessageFrame frame) {
        return FrameUtils.proxyUpdaterFor(frame).entityIdFactory();
    }

    public static OpsDurationCounter opsDurationCounter(@NonNull MessageFrame frame) {
        return (OpsDurationCounter)FrameUtils.initialFrameOf(frame).getContextVariable(OPS_DURATION_COUNTER);
    }

    public static enum CallType {
        QUALIFIED_DELEGATE,
        UNQUALIFIED_DELEGATE,
        DIRECT_OR_PROXY_REDIRECT;

    }

    public static enum EntityType {
        TOKEN,
        SCHEDULE_TXN,
        REGULAR_ACCOUNT;

    }
}

