/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.hedera.node.app.service.contract.impl.exec.operations.CustomizedOpcodes;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CustomPrevRandaoOperation
extends AbstractOperation {
    private final Operation.OperationResult successResult;
    private final Operation.OperationResult insufficientGasResult;
    private final long gasCost;

    public CustomPrevRandaoOperation(@NonNull GasCalculator gasCalculator) {
        super(CustomizedOpcodes.PREVRANDAO.opcode(), "PRNGSEED", 0, 1, Objects.requireNonNull(gasCalculator));
        this.gasCost = gasCalculator.getBaseTierGasCost();
        this.successResult = new Operation.OperationResult(this.gasCost, null);
        this.insufficientGasResult = new Operation.OperationResult(this.gasCost, ExceptionalHaltReason.INSUFFICIENT_GAS);
    }

    public Operation.OperationResult execute(@NonNull MessageFrame frame, @NonNull EVM evm) {
        Objects.requireNonNull(evm);
        Objects.requireNonNull(frame);
        if (frame.getRemainingGas() < this.gasCost) {
            return this.insufficientGasResult;
        }
        Bytes entropy = FrameUtils.proxyUpdaterFor(frame).entropy();
        if (entropy.size() > 32) {
            frame.pushStackItem(entropy.slice(0, 32));
        } else {
            frame.pushStackItem(entropy);
        }
        return this.successResult;
    }
}

