/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.cache.VirtualNodeCache;
import com.swirlds.virtualmap.internal.merkle.VirtualMapMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class RecordAccessor {
    private final VirtualMapMetadata state;
    private final VirtualNodeCache cache;
    private final VirtualDataSource dataSource;

    public RecordAccessor(@NonNull VirtualMapMetadata state, @NonNull VirtualNodeCache cache, @NonNull VirtualDataSource dataSource) {
        this.state = Objects.requireNonNull(state);
        this.cache = Objects.requireNonNull(cache);
        this.dataSource = dataSource;
    }

    @Nullable
    public Hash findHash(long path) {
        assert (path >= 0L);
        Hash hash = this.cache.lookupHashByPath(path);
        if (hash != null) {
            return hash;
        }
        try {
            return this.dataSource.loadHash(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read node hash from data source by path", e);
        }
    }

    public boolean findAndWriteHash(long path, SerializableDataOutputStream out) throws IOException {
        assert (path >= 0L);
        Hash hash = this.cache.lookupHashByPath(path);
        if (hash != null) {
            hash.serialize(out);
            return true;
        }
        return this.dataSource.loadAndWriteHash(path, out);
    }

    @Nullable
    public VirtualLeafBytes findLeafRecord(@NonNull Bytes key) {
        VirtualLeafBytes rec = this.cache.lookupLeafByKey(key);
        if (rec == null) {
            try {
                rec = this.dataSource.loadLeafRecord(key);
                if (rec != null) assert (rec.keyBytes().equals((Object)key)) : "The key we found from the DB does not match the one we were looking for! key=" + String.valueOf(key);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to read a leaf record from the data source by key", ex);
            }
        }
        return rec == VirtualNodeCache.DELETED_LEAF_RECORD ? null : rec;
    }

    @Nullable
    public VirtualLeafBytes findLeafRecord(long path) {
        assert (path != -1L);
        assert (path != 0L);
        if (path < this.state.getFirstLeafPath() || path > this.state.getLastLeafPath()) {
            return null;
        }
        VirtualLeafBytes rec = this.cache.lookupLeafByPath(path);
        if (rec == null) {
            try {
                rec = this.dataSource.loadLeafRecord(path);
                if (rec != null) assert (rec.path() == path) : "The path we found from the DB does not match the one we were looking for! path=" + path;
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to read a leaf record from the data source by path", ex);
            }
        }
        return rec == VirtualNodeCache.DELETED_LEAF_RECORD ? null : rec;
    }

    public long findPath(@NonNull Bytes key) {
        VirtualLeafBytes rec = this.cache.lookupLeafByKey(key);
        if (rec != null) {
            return rec.path();
        }
        try {
            return this.dataSource.findKey(key);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to find key in the data source", ex);
        }
    }

    public void close() throws IOException {
        this.dataSource.close();
    }
}

