/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.fees.congestion.CongestionMultipliers;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.QueryFeeCalculator;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.fees.HighVolumePricingCalculator;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.ExtraFeeReference;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;
import org.hiero.hapi.support.fees.VariableRateDefinition;

public class SimpleFeeCalculatorImpl
implements SimpleFeeCalculator {
    private static final Logger log = LogManager.getLogger(SimpleFeeCalculatorImpl.class);
    protected final FeeSchedule feeSchedule;
    private final Map<TransactionBody.DataOneOfType, ServiceFeeCalculator> serviceFeeCalculators;
    private final Map<Query.QueryOneOfType, QueryFeeCalculator> queryFeeCalculators;
    private final CongestionMultipliers congestionMultipliers;
    private static final Set<HederaFunctionality> HIGH_VOLUME_FUNCTIONS = Set.of(HederaFunctionality.CRYPTO_CREATE, HederaFunctionality.CONSENSUS_CREATE_TOPIC, HederaFunctionality.SCHEDULE_CREATE, HederaFunctionality.CRYPTO_APPROVE_ALLOWANCE, HederaFunctionality.FILE_CREATE, HederaFunctionality.FILE_APPEND, HederaFunctionality.CONTRACT_CREATE, HederaFunctionality.HOOK_STORE, HederaFunctionality.TOKEN_ASSOCIATE_TO_ACCOUNT, HederaFunctionality.TOKEN_AIRDROP, HederaFunctionality.TOKEN_CLAIM_AIRDROP, HederaFunctionality.TOKEN_MINT, HederaFunctionality.TOKEN_CREATE);

    public SimpleFeeCalculatorImpl(@NonNull FeeSchedule feeSchedule, @NonNull Set<ServiceFeeCalculator> serviceFeeCalculators, @NonNull Set<QueryFeeCalculator> queryFeeCalculators, @NonNull CongestionMultipliers congestionMultipliers) {
        this.feeSchedule = Objects.requireNonNull(feeSchedule);
        this.serviceFeeCalculators = serviceFeeCalculators.stream().collect(Collectors.toMap(ServiceFeeCalculator::getTransactionType, Function.identity()));
        this.queryFeeCalculators = queryFeeCalculators.stream().collect(Collectors.toMap(QueryFeeCalculator::getQueryType, Function.identity()));
        this.congestionMultipliers = congestionMultipliers;
    }

    @VisibleForTesting
    public SimpleFeeCalculatorImpl(@NonNull FeeSchedule feeSchedule, @NonNull Set<ServiceFeeCalculator> serviceFeeCalculators, @NonNull Set<QueryFeeCalculator> queryFeeCalculators) {
        this(feeSchedule, serviceFeeCalculators, queryFeeCalculators, null);
    }

    @VisibleForTesting
    public SimpleFeeCalculatorImpl(@NonNull FeeSchedule feeSchedule, @NonNull Set<ServiceFeeCalculator> serviceFeeCalculators) {
        this(feeSchedule, serviceFeeCalculators, Set.of());
    }

    private void addNodeExtras(@NonNull FeeResult result, @NonNull Iterable<ExtraFeeReference> extras, long signatures, long bytes) {
        for (ExtraFeeReference ref : extras) {
            long used = switch (ref.name()) {
                case Extra.SIGNATURES -> signatures;
                case Extra.PROCESSING_BYTES -> bytes;
                default -> 0L;
            };
            long unitFee = this.getExtraFee(ref.name());
            result.addNodeExtraFeeTinycents(ref.name().name(), unitFee, used, (long)ref.includedCount());
        }
    }

    @NonNull
    public FeeResult calculateTxFee(@NonNull TransactionBody txnBody, @NonNull SimpleFeeContext simpleFeeContext) {
        long signatures = simpleFeeContext.numTxnSignatures();
        long bytes = simpleFeeContext.numTxnBytes();
        FeeResult result = new FeeResult();
        result.setNodeBaseFeeTinycents(Objects.requireNonNull(this.feeSchedule.node()).baseFee());
        this.addNodeExtras(result, this.feeSchedule.node().extras(), signatures, bytes);
        int multiplier = Objects.requireNonNull(this.feeSchedule.network()).multiplier();
        result.setNetworkMultiplier(multiplier);
        ServiceFeeCalculator serviceFeeCalculator = this.serviceFeeCalculators.get(txnBody.data().kind());
        serviceFeeCalculator.accumulateServiceFee(txnBody, simpleFeeContext, result, this.feeSchedule);
        HederaFunctionality functionality = simpleFeeContext.functionality();
        boolean isHighVolumeFunction = HIGH_VOLUME_FUNCTIONS.contains(functionality);
        if (txnBody.highVolume() && isHighVolumeFunction) {
            this.applyHighVolumeMultiplier(functionality, simpleFeeContext, result);
        } else {
            this.applyCongestionMultiplier(txnBody, simpleFeeContext, result, functionality);
        }
        return result;
    }

    private void applyCongestionMultiplier(@NonNull TransactionBody txnBody, @NonNull SimpleFeeContext simpleFeeContext, @NonNull FeeResult result, @NonNull HederaFunctionality functionality) {
        if (simpleFeeContext.feeContext() == null || this.congestionMultipliers == null) {
            return;
        }
        FeeContext feeContext = simpleFeeContext.feeContext();
        long congestionMultiplier = this.congestionMultipliers.maxCurrentMultiplier(txnBody, functionality, feeContext.readableStoreFactory());
        if (congestionMultiplier <= 1L) {
            return;
        }
        result.applyMultiplier(congestionMultiplier, 1L);
    }

    private void applyHighVolumeMultiplier(@NonNull HederaFunctionality functionality, @NonNull SimpleFeeContext feeContext, @NonNull FeeResult result) {
        if (feeContext.feeContext() == null) {
            return;
        }
        ServiceFeeDefinition serviceFeeDefinition = FeeScheduleUtils.lookupServiceFee((FeeSchedule)this.feeSchedule, (HederaFunctionality)functionality);
        if (serviceFeeDefinition == null || serviceFeeDefinition.highVolumeRates() == null) {
            log.error(" {} - No high volume rates defined for {}", (Object)"Possibly CATASTROPHIC failure", (Object)functionality);
            return;
        }
        int utilizationPercentBasisPoints = feeContext.getHighVolumeThrottleUtilization(functionality);
        long rawMultiplier = HighVolumePricingCalculator.calculateMultiplier((VariableRateDefinition)serviceFeeDefinition.highVolumeRates(), (int)utilizationPercentBasisPoints);
        result.applyMultiplier(rawMultiplier, 1000L);
    }

    public long getExtraFee(Extra extra) {
        return this.feeSchedule.extras().stream().filter(feeDefinition -> feeDefinition.name() == extra).findFirst().orElseThrow(() -> new IllegalArgumentException("Extra fee not found: " + String.valueOf(extra))).fee();
    }

    @NonNull
    public FeeResult calculateQueryFee(@NonNull Query query, @NonNull SimpleFeeContext simpleFeeContext) {
        FeeResult result = new FeeResult();
        QueryFeeCalculator queryFeeCalculator = this.queryFeeCalculators.get(query.query().kind());
        queryFeeCalculator.accumulateNodePayment(query, simpleFeeContext, result, this.feeSchedule);
        return result;
    }
}

