/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.fees.StandaloneFeeCalculator;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.SimpleFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.app.workflows.standalone.ExecutorComponent;
import com.hedera.node.app.workflows.standalone.TransactionExecutors;
import com.hedera.node.config.types.StreamMode;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.base.exceptions.NotImplementedException;
import org.hiero.hapi.fees.FeeResult;

public class StandaloneFeeCalculatorImpl
implements StandaloneFeeCalculator {
    private final SimpleFeeCalculator calc;

    public StandaloneFeeCalculatorImpl(State state, TransactionExecutors.Properties properties, EntityIdFactory entityIdFactory) {
        ExecutorComponent executor = TransactionExecutors.TRANSACTION_EXECUTORS.newExecutorComponent(properties.state(), properties.appProperties(), properties.customTracerBinding(), properties.customOps(), entityIdFactory);
        executor.stateNetworkInfo().initFrom(state);
        executor.initializer().initialize(state, StreamMode.BOTH);
        this.calc = executor.feeManager().getSimpleFeeCalculator();
    }

    @Override
    public FeeResult calculateIntrinsic(Transaction transaction) throws ParseException {
        StandaloneFeeContextImpl context = new StandaloneFeeContextImpl(this, transaction);
        return this.calc.calculateTxFee(context.body(), (SimpleFeeContext)context);
    }

    @Override
    public FeeResult calculateStateful(Transaction transaction) {
        throw new NotImplementedException();
    }

    private class StandaloneFeeContextImpl
    implements SimpleFeeContext {
        private final int numTxnSignatures;
        private final TransactionBody body;
        private final Transaction transaction;

        public StandaloneFeeContextImpl(StandaloneFeeCalculatorImpl standaloneFeeCalculatorImpl, Transaction transaction) throws ParseException {
            this.transaction = transaction;
            if (transaction.hasBody()) {
                this.body = transaction.bodyOrThrow();
                this.numTxnSignatures = transaction.sigMapOrElse(SignatureMap.DEFAULT).sigPair().size();
            } else {
                SignedTransaction signedTransaction = (SignedTransaction)SignedTransaction.PROTOBUF.parse((ReadableSequentialData)BufferedData.wrap((byte[])transaction.signedTransactionBytes().toByteArray()));
                this.body = (TransactionBody)TransactionBody.PROTOBUF.parse(signedTransaction.bodyBytes());
                this.numTxnSignatures = signedTransaction.sigMapOrElse(SignatureMap.DEFAULT).sigPair().size();
            }
        }

        public int numTxnSignatures() {
            return this.numTxnSignatures;
        }

        public int numTxnBytes() {
            return Transaction.PROTOBUF.measureRecord((Object)this.transaction);
        }

        public HederaFunctionality functionality() {
            try {
                return HapiUtils.functionOf((TransactionBody)this.body);
            }
            catch (UnknownHederaFunctionality e) {
                throw new IllegalStateException(e);
            }
        }

        public FeeContext feeContext() {
            return null;
        }

        public QueryContext queryContext() {
            return null;
        }

        @NonNull
        public TransactionBody body() {
            return this.body;
        }
    }
}

