/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.state.snapshot.SavedStateMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.hiero.consensus.io.RecycleBin;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.pces.config.PcesConfig;
import org.hiero.consensus.pces.impl.common.CommonPcesWriter;
import org.hiero.consensus.pces.impl.common.PcesFileManager;
import org.hiero.consensus.pces.impl.common.PcesFileReader;
import org.hiero.consensus.pces.impl.common.PcesFileTracker;
import org.hiero.consensus.pces.impl.common.PcesMultiFileIterator;

public final class SavedStateUtils {
    private static final String PCES_TEMPORARY_DIR = "pces-tmp";

    private SavedStateUtils() {
    }

    public static int prepareStateForTransplant(@NonNull Path statePath, @NonNull PlatformContext platformContext) throws IOException {
        Configuration configuration = platformContext.getConfiguration();
        Path pcesFiles = statePath.resolve(((PcesConfig)configuration.getConfigData(PcesConfig.class)).databaseDirectory());
        Path pcesTmp = statePath.resolve(PCES_TEMPORARY_DIR);
        Files.move(pcesFiles, pcesTmp, StandardCopyOption.REPLACE_EXISTING);
        SavedStateMetadata stateMetadata = SavedStateMetadata.parse(statePath.resolve("stateMetadata.txt"));
        PcesFileTracker fileTracker = PcesFileReader.readFilesFromDisk((Configuration)configuration, (RecycleBin)platformContext.getRecycleBin(), (Path)pcesTmp, (long)stateMetadata.round(), (boolean)false);
        PcesMultiFileIterator eventIterator = fileTracker.getEventIterator(stateMetadata.minimumBirthRoundNonAncient(), stateMetadata.round());
        CommonPcesWriter pcesWriter = new CommonPcesWriter(configuration, new PcesFileManager(configuration, platformContext.getMetrics(), platformContext.getTime(), new PcesFileTracker(), pcesFiles, stateMetadata.round()));
        pcesWriter.beginStreamingNewEvents();
        int discardedEventCount = 0;
        while (eventIterator.hasNext()) {
            PlatformEvent event = eventIterator.next();
            if (event.getBirthRound() > stateMetadata.round()) {
                ++discardedEventCount;
                continue;
            }
            pcesWriter.prepareOutputStream(event);
            pcesWriter.getCurrentMutableFile().writeEvent(event);
        }
        pcesWriter.closeCurrentMutableFile();
        FileUtils.deleteDirectory((Path)pcesTmp);
        return discardedEventCount;
    }
}

