/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.mapper.Value;
import io.helidon.common.media.type.ParserMode;
import io.helidon.http.ClientResponseHeadersImpl;
import io.helidon.http.DateTime;
import io.helidon.http.HeaderNames;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public interface ClientResponseHeaders
extends Headers {
    public static ClientResponseHeaders create(Headers responseHeaders) {
        return new ClientResponseHeadersImpl(responseHeaders, ParserMode.STRICT);
    }

    public static ClientResponseHeaders create(Headers responseHeaders, ParserMode parserMode) {
        return new ClientResponseHeadersImpl(responseHeaders, parserMode);
    }

    default public List<HttpMediaType> acceptPatches() {
        List<String> all = this.all(HeaderNames.ACCEPT_PATCH, List::of);
        ArrayList<HttpMediaType> mediaTypes = new ArrayList<HttpMediaType>(all.size());
        for (String value : all) {
            mediaTypes.add(HttpMediaType.create(value));
        }
        return mediaTypes;
    }

    default public Optional<URI> location() {
        if (this.contains(HeaderNames.LOCATION)) {
            return Optional.of(this.get(HeaderNames.LOCATION)).map(Value::get).map(URI::create);
        }
        return Optional.empty();
    }

    default public Optional<ZonedDateTime> lastModified() {
        if (this.contains(HeaderNames.LAST_MODIFIED)) {
            return Optional.of(this.get(HeaderNames.LAST_MODIFIED)).map(Value::get).map(DateTime::parse);
        }
        return Optional.empty();
    }

    default public Optional<ZonedDateTime> expires() {
        if (this.contains(HeaderNames.EXPIRES)) {
            return Optional.of(this.get(HeaderNames.EXPIRES)).map(Value::get).map(DateTime::parse);
        }
        return Optional.empty();
    }
}

