/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.impl;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.hints.CRSState;
import com.hedera.hapi.node.state.hints.HintsConstruction;
import com.hedera.hapi.node.state.hints.HintsKeySet;
import com.hedera.hapi.node.state.hints.HintsPartyId;
import com.hedera.hapi.node.state.hints.HintsScheme;
import com.hedera.hapi.node.state.hints.NodePartyId;
import com.hedera.hapi.node.state.hints.PreprocessedKeys;
import com.hedera.hapi.node.state.hints.PreprocessingVote;
import com.hedera.hapi.node.state.hints.PreprocessingVoteId;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.NodeId;
import com.hedera.hapi.services.auxiliary.hints.CrsPublicationTransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.hints.HintsService;
import com.hedera.node.app.hints.WritableHintsStore;
import com.hedera.node.app.hints.impl.ReadableHintsStoreImpl;
import com.hedera.node.app.hints.schemas.V059HintsSchema;
import com.hedera.node.app.hints.schemas.V060HintsSchema;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.roster.impl.ActiveRosters;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WritableHintsStoreImpl
extends ReadableHintsStoreImpl
implements WritableHintsStore {
    private static final Logger log = LogManager.getLogger(WritableHintsStoreImpl.class);
    private final WritableKVState<HintsPartyId, HintsKeySet> hintsKeys;
    private final WritableSingletonState<HintsConstruction> nextConstruction;
    private final WritableSingletonState<HintsConstruction> activeConstruction;
    private final WritableKVState<PreprocessingVoteId, PreprocessingVote> votes;
    private final WritableKVState<NodeId, CrsPublicationTransactionBody> crsPublications;
    private final WritableSingletonState<CRSState> crsState;

    public WritableHintsStoreImpl(@NonNull WritableStates states, WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        this.hintsKeys = states.get(V059HintsSchema.HINTS_KEY_SETS_STATE_ID);
        this.nextConstruction = states.getSingleton(V059HintsSchema.NEXT_HINTS_CONSTRUCTION_STATE_ID);
        this.activeConstruction = states.getSingleton(V059HintsSchema.ACTIVE_HINTS_CONSTRUCTION_STATE_ID);
        this.votes = states.get(V059HintsSchema.PREPROCESSING_VOTES_STATE_ID);
        this.crsState = states.getSingleton(V060HintsSchema.CRS_STATE_STATE_ID);
        this.crsPublications = states.get(V060HintsSchema.CRS_PUBLICATIONS_STATE_ID);
    }

    @Override
    @NonNull
    public HintsConstruction getOrCreateConstruction(@NonNull ActiveRosters activeRosters, @NonNull Instant now, @NonNull TssConfig tssConfig) {
        Objects.requireNonNull(activeRosters);
        Objects.requireNonNull(now);
        Objects.requireNonNull(tssConfig);
        ActiveRosters.Phase phase = activeRosters.phase();
        if (phase == ActiveRosters.Phase.HANDOFF) {
            throw new IllegalArgumentException("Handoff phase has no construction");
        }
        HintsConstruction construction = this.getConstructionFor(activeRosters);
        if (construction == null) {
            Duration gracePeriod = phase == ActiveRosters.Phase.BOOTSTRAP ? tssConfig.bootstrapHintsKeyGracePeriod() : tssConfig.transitionHintsKeyGracePeriod();
            construction = this.updateForNewConstruction(activeRosters.sourceRosterHash(), activeRosters.targetRosterHash(), arg_0 -> ((ActiveRosters)activeRosters).findRelatedRoster(arg_0), now, gracePeriod);
        }
        return construction;
    }

    @Override
    public boolean setHintsKey(long nodeId, int partyId, int numParties, @NonNull Bytes hintsKey, @NonNull Instant now) {
        HintsPartyId id = new HintsPartyId(partyId, numParties);
        HintsKeySet keySet = (HintsKeySet)this.hintsKeys.get((Object)id);
        boolean inUse = false;
        if (keySet == null) {
            inUse = true;
            keySet = HintsKeySet.newBuilder().key(hintsKey).nodeId(nodeId).adoptionTime(HapiUtils.asTimestamp((Instant)now)).build();
        } else {
            keySet = keySet.copyBuilder().nodeId(nodeId).nextKey(hintsKey).build();
        }
        this.hintsKeys.put((Object)id, (Object)keySet);
        return inUse;
    }

    @Override
    public void addPreprocessingVote(long nodeId, long constructionId, @NonNull PreprocessingVote vote) {
        this.votes.put((Object)new PreprocessingVoteId(constructionId, nodeId), (Object)vote);
    }

    @Override
    public HintsConstruction setHintsScheme(long constructionId, @NonNull PreprocessedKeys keys, @NonNull Map<Long, Integer> nodePartyIds, @NonNull Map<Long, Long> nodeWeights) {
        Objects.requireNonNull(keys);
        Objects.requireNonNull(nodePartyIds);
        return this.updateOrThrow(constructionId, b -> b.hintsScheme(new HintsScheme(keys, this.asList(nodePartyIds, nodeWeights))));
    }

    @Override
    public HintsConstruction setPreprocessingStartTime(long constructionId, @NonNull Instant now) {
        Objects.requireNonNull(now);
        return this.updateOrThrow(constructionId, b -> b.preprocessingStartTime(HapiUtils.asTimestamp((Instant)now)));
    }

    @Override
    public boolean handoff(@NonNull Roster fromRoster, @NonNull Roster toRoster, @NonNull Bytes toRosterHash, boolean forceHandoff) {
        Objects.requireNonNull(fromRoster);
        Objects.requireNonNull(toRoster);
        Objects.requireNonNull(toRosterHash);
        HintsConstruction upcomingConstruction = Objects.requireNonNull((HintsConstruction)this.nextConstruction.get());
        if (!upcomingConstruction.hasHintsScheme()) {
            if (forceHandoff) {
                log.warn("Ignoring forced handoff to incomplete construction #{}", (Object)upcomingConstruction.constructionId());
            }
            return false;
        }
        boolean handoffMatches = upcomingConstruction.targetRosterHash().equals((Object)toRosterHash);
        if (!handoffMatches) {
            if (forceHandoff) {
                log.warn("Forcing handoff to construction #{} with different target roster", (Object)upcomingConstruction.constructionId());
            } else {
                throw new IllegalStateException("Cannot handoff to construction #" + upcomingConstruction.constructionId() + " with different target roster (constructed for '" + String.valueOf(upcomingConstruction.targetRosterHash()) + " but incoming is '" + String.valueOf(toRosterHash) + "')");
            }
        }
        log.info("Handing off to upcoming construction #{}", (Object)upcomingConstruction.constructionId());
        this.purgeVotes(Objects.requireNonNull((HintsConstruction)this.activeConstruction.get()), ignore -> fromRoster);
        this.maybePurgeHintsKeys(HintsService.partySizeForRoster(toRoster), fromRoster);
        this.activeConstruction.put((Object)upcomingConstruction);
        this.nextConstruction.put((Object)HintsConstruction.DEFAULT);
        return true;
    }

    @Override
    public void setCrsState(@NonNull CRSState crsState) {
        this.crsState.put((Object)crsState);
    }

    @Override
    public void moveToNextNode(@Nullable Long nextNodeIdFromRoster, @NonNull Instant nextContributionTimeEnd) {
        CRSState crsState = Objects.requireNonNull((CRSState)this.crsState.get());
        CRSState newCrsState = crsState.copyBuilder().nextContributingNodeId(nextNodeIdFromRoster).contributionEndTime(HapiUtils.asTimestamp((Instant)nextContributionTimeEnd)).build();
        this.setCrsState(newCrsState);
    }

    @Override
    public void addCrsPublication(long nodeId, @NonNull CrsPublicationTransactionBody crsPublication) {
        this.crsPublications.put((Object)new NodeId(nodeId), (Object)crsPublication);
    }

    private HintsConstruction updateOrThrow(long constructionId, @NonNull UnaryOperator<HintsConstruction.Builder> spec) {
        HintsConstruction construction = (HintsConstruction)this.activeConstruction.get();
        if (Objects.requireNonNull(construction).constructionId() == constructionId) {
            construction = ((HintsConstruction.Builder)spec.apply(construction.copyBuilder())).build();
            this.activeConstruction.put((Object)construction);
        } else {
            construction = (HintsConstruction)this.nextConstruction.get();
            if (Objects.requireNonNull(construction).constructionId() == constructionId) {
                construction = ((HintsConstruction.Builder)spec.apply(construction.copyBuilder())).build();
                this.nextConstruction.put((Object)construction);
            } else {
                throw new IllegalArgumentException("No construction with id " + constructionId);
            }
        }
        return construction;
    }

    private HintsConstruction updateForNewConstruction(@NonNull Bytes sourceRosterHash, @NonNull Bytes targetRosterHash, @NonNull Function<Bytes, Roster> lookup, @NonNull Instant now, @NonNull Duration gracePeriod) {
        HintsConstruction construction = HintsConstruction.newBuilder().constructionId(this.newConstructionId()).sourceRosterHash(sourceRosterHash).targetRosterHash(targetRosterHash).gracePeriodEndTime(HapiUtils.asTimestamp((Instant)now.plus(gracePeriod))).build();
        if (Objects.requireNonNull((HintsConstruction)this.activeConstruction.get()).equals((Object)HintsConstruction.DEFAULT)) {
            this.activeConstruction.put((Object)construction);
        } else {
            if (!Objects.requireNonNull((HintsConstruction)this.nextConstruction.get()).equals((Object)HintsConstruction.DEFAULT)) {
                this.purgeVotes(Objects.requireNonNull((HintsConstruction)this.nextConstruction.get()), lookup);
            }
            this.nextConstruction.put((Object)construction);
        }
        Roster targetRoster = Objects.requireNonNull(lookup.apply(targetRosterHash));
        int numParties = HintsService.partySizeForRoster(targetRoster);
        Timestamp adoptionTime = HapiUtils.asTimestamp((Instant)now);
        for (int partyId = 0; partyId < numParties; ++partyId) {
            HintsPartyId hintsId = new HintsPartyId(partyId, numParties);
            HintsKeySet keySet = (HintsKeySet)this.hintsKeys.get((Object)hintsId);
            if (keySet == null || keySet.nextKey().length() <= 0L) continue;
            HintsKeySet rotatedKeySet = keySet.copyBuilder().key(keySet.nextKey()).adoptionTime(adoptionTime).nextKey(Bytes.EMPTY).build();
            this.hintsKeys.put((Object)hintsId, (Object)rotatedKeySet);
        }
        return construction;
    }

    private void purgeVotes(@NonNull HintsConstruction construction, @NonNull Function<Bytes, Roster> lookup) {
        Roster sourceRoster = Objects.requireNonNull(lookup.apply(construction.sourceRosterHash()));
        sourceRoster.rosterEntries().forEach(entry -> this.votes.remove((Object)new PreprocessingVoteId(construction.constructionId(), entry.nodeId())));
    }

    private void maybePurgeHintsKeys(int m, @NonNull Roster roster) {
        int n = HintsService.partySizeForRoster(roster);
        if (n != m) {
            for (int partyId = 0; partyId < n; ++partyId) {
                HintsPartyId hintsId = new HintsPartyId(partyId, n);
                this.hintsKeys.remove((Object)hintsId);
            }
        }
    }

    private long newConstructionId() {
        return Math.max(Objects.requireNonNull((HintsConstruction)this.activeConstruction.get()).constructionId(), Objects.requireNonNull((HintsConstruction)this.nextConstruction.get()).constructionId()) + 1L;
    }

    private List<NodePartyId> asList(@NonNull Map<Long, Integer> nodePartyIds, @NonNull Map<Long, Long> nodeWeights) {
        return nodePartyIds.entrySet().stream().map(entry -> {
            long nodeId = (Long)entry.getKey();
            return new NodePartyId(nodeId, ((Integer)entry.getValue()).intValue(), ((Long)nodeWeights.get(nodeId)).longValue());
        }).sorted(Comparator.comparingLong(NodePartyId::nodeId)).toList();
    }
}

