/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.features.metadata;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.features.metadata.DeprecationBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.features.metadata.DeprecationBlueprint")
public interface Deprecation
extends DeprecationBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Deprecation instance) {
        return (Builder)Deprecation.builder().from(instance);
    }

    public static Deprecation create() {
        return Deprecation.builder().buildPrototype();
    }

    @Override
    public boolean isDeprecated();

    @Override
    public Optional<String> since();

    @Override
    public Optional<String> description();

    public static class Builder
    extends BuilderBase<Builder, Deprecation>
    implements io.helidon.common.Builder<Builder, Deprecation> {
        private Builder() {
        }

        public Deprecation buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.DeprecationImpl(this);
        }

        public Deprecation build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Deprecation>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean isDeprecated = true;
        private String description;
        private String since;

        protected BuilderBase() {
        }

        public BUILDER from(Deprecation prototype) {
            this.isDeprecated(prototype.isDeprecated());
            this.since(prototype.since());
            this.description(prototype.description());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.isDeprecated(builder.isDeprecated());
            builder.since().ifPresent(this::since);
            builder.description().ifPresent(this::description);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER isDeprecated(boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSince() {
            this.since = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER since(String since) {
            Objects.requireNonNull(since);
            this.since = since;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDescription() {
            this.description = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER description(String description) {
            Objects.requireNonNull(description);
            this.description = description;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean isDeprecated() {
            return this.isDeprecated;
        }

        public Optional<String> since() {
            return Optional.ofNullable(this.since);
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        public String toString() {
            return "DeprecationBuilder{isDeprecated=" + this.isDeprecated + ",since=" + this.since + ",description=" + this.description + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER since(Optional<String> since) {
            Objects.requireNonNull(since);
            this.since = since.map(String.class::cast).orElse(this.since);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER description(Optional<String> description) {
            Objects.requireNonNull(description);
            this.description = description.map(String.class::cast).orElse(this.description);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class DeprecationImpl
        implements Deprecation {
            private final boolean isDeprecated;
            private final Optional<String> description;
            private final Optional<String> since;

            protected DeprecationImpl(BuilderBase<?, ?> builder) {
                this.isDeprecated = builder.isDeprecated();
                this.since = builder.since().map(Function.identity());
                this.description = builder.description().map(Function.identity());
            }

            @Override
            public boolean isDeprecated() {
                return this.isDeprecated;
            }

            @Override
            public Optional<String> since() {
                return this.since;
            }

            @Override
            public Optional<String> description() {
                return this.description;
            }

            public String toString() {
                return "Deprecation{isDeprecated=" + this.isDeprecated + ",since=" + String.valueOf(this.since) + ",description=" + String.valueOf(this.description) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Deprecation)) {
                    return false;
                }
                Deprecation other = (Deprecation)o;
                return this.isDeprecated == other.isDeprecated() && Objects.equals(this.since, other.since()) && Objects.equals(this.description, other.description());
            }

            public int hashCode() {
                return Objects.hash(this.isDeprecated, this.since, this.description);
            }
        }
    }
}

