/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.lifecycle;

import com.swirlds.config.api.Configuration;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Comparator;
import java.util.Map;

public interface MigrationContext<V> {
    public long roundNumber();

    @NonNull
    public ReadableStates previousStates();

    @NonNull
    public WritableStates newStates();

    @NonNull
    public Configuration appConfig();

    @NonNull
    public Configuration platformConfig();

    @Nullable
    public V previousVersion();

    public Map<String, Object> sharedValues();

    default public boolean isGenesis() {
        return this.previousVersion() == null;
    }

    public Comparator<V> getVersionComparator();

    default public <T extends Comparable<? super T>> boolean isUpgrade(@NonNull V currentVersion) {
        return this.getVersionComparator().compare(currentVersion, this.previousVersion()) > 0;
    }
}

