/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.lifecycle;

import com.hedera.pbj.runtime.Codec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public record StateDefinition<K, V>(int stateId, @NonNull String stateKey, @Nullable Codec<K> keyCodec, @NonNull Codec<V> valueCodec, boolean keyValue, boolean singleton, boolean queue) {
    private static final int NO_MAX = -1;

    public StateDefinition {
        if (singleton && queue) {
            throw new IllegalArgumentException("A state cannot both be 'singleton' and 'queue'");
        }
        if (singleton && keyValue) {
            throw new IllegalArgumentException("A state cannot both be 'singleton' and 'keyValue'");
        }
        if (queue && keyValue) {
            throw new IllegalArgumentException("A state cannot both be 'queue' and 'keyValue'");
        }
        if (!singleton && !queue) {
            Objects.requireNonNull(keyCodec, "keyCodec must be specified unless using singleton or queue types");
        }
        Objects.requireNonNull(stateKey, "stateKey must be specified");
        Objects.requireNonNull(valueCodec, "valueCodec must be specified");
    }

    public static <K, V> StateDefinition<K, V> keyValue(int stateId, @NonNull String stateKey, @NonNull Codec<K> keyCodec, @NonNull Codec<V> valueCodec) {
        return new StateDefinition<K, V>(stateId, stateKey, keyCodec, valueCodec, true, false, false);
    }

    public static <K, V> StateDefinition<K, V> singleton(int stateId, @NonNull String stateKey, @NonNull Codec<V> valueCodec) {
        return new StateDefinition<K, V>(stateId, stateKey, null, valueCodec, false, true, false);
    }

    public static <K, V> StateDefinition<K, V> queue(int stateId, @NonNull String stateKey, @NonNull Codec<V> elementCodec) {
        return new StateDefinition<K, V>(stateId, stateKey, null, elementCodec, false, false, true);
    }
}

