/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.wiring;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.stream.RunningEventHashOverride;
import com.swirlds.component.framework.wires.input.NoInput;
import com.swirlds.platform.builder.ApplicationCallbacks;
import com.swirlds.platform.components.EventWindowManager;
import com.swirlds.platform.state.hashlogger.HashLogger;
import com.swirlds.platform.state.iss.IssDetector;
import com.swirlds.platform.state.signed.StateSignatureCollector;
import com.swirlds.platform.state.snapshot.StateDumpRequest;
import com.swirlds.platform.state.snapshot.StateSnapshotManager;
import com.swirlds.platform.system.PlatformMonitor;
import com.swirlds.platform.system.status.StatusActionSubmitter;
import com.swirlds.platform.system.status.actions.PlatformStatusAction;
import com.swirlds.platform.wiring.PlatformComponents;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.io.IOIterator;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;

public record PlatformCoordinator(@NonNull PlatformComponents components, @NonNull ApplicationCallbacks callbacks) implements StatusActionSubmitter
{
    public PlatformCoordinator {
        Objects.requireNonNull(components);
        Objects.requireNonNull(callbacks);
    }

    public void flushIntakePipeline() {
        this.components.eventIntakeModule().flush();
        this.components.pcesModule().flush();
        this.components.gossipModule().flush();
        this.components.hashgraphModule().flush();
        this.components.applicationTransactionPrehandlerWiring().flush();
        this.components.eventCreatorModule().flush();
        this.components.branchDetectorWiring().flush();
    }

    public void startGossip() {
        this.components.gossipModule().startInputWire().inject((Object)NoInput.getInstance());
    }

    public void sendStateToHashLogger(@NonNull SignedState signedState) {
        if (signedState.getState().getHash() != null) {
            ReservedSignedState stateReservedForHasher = signedState.reserve("logging state hash");
            boolean offerResult = this.components.hashLoggerWiring().getInputWire(HashLogger::logHashes).offer((Object)stateReservedForHasher);
            if (!offerResult) {
                stateReservedForHasher.close();
            }
        }
    }

    public void updateRunningHash(@NonNull RunningEventHashOverride runningHashUpdate) {
        this.components.runningEventHashOverrideWiring().runningHashUpdateInput().inject((Object)runningHashUpdate);
    }

    public void overrideIssDetectorState(@NonNull ReservedSignedState state) {
        this.components.issDetectorWiring().getInputWire(IssDetector::overridingState).put((Object)state);
    }

    public void signalEndOfPcesReplay() {
        this.components.issDetectorWiring().getInputWire(IssDetector::signalEndOfPreconsensusReplay).put((Object)NoInput.getInstance());
    }

    public void updateEventWindow(@NonNull EventWindow eventWindow) {
        this.components.eventWindowManagerWiring().getInputWire(EventWindowManager::updateEventWindow).inject((Object)eventWindow);
        this.components.gossipModule().flush();
    }

    public void consensusSnapshotOverride(@NonNull ConsensusSnapshot consensusSnapshot) {
        this.components.hashgraphModule().consensusSnapshotInputWire().inject((Object)consensusSnapshot);
        if (this.callbacks.snapshotOverrideConsumer() != null) {
            this.callbacks.snapshotOverrideConsumer().accept(consensusSnapshot);
        }
    }

    public void flushTransactionHandler() {
        this.components.transactionHandlerWiring().flush();
    }

    public void flushStateHasher() {
        this.components.stateHasherWiring().flush();
    }

    public void start() {
        this.components.model().start();
    }

    public void stop() {
        this.components.model().stop();
    }

    @Override
    public void submitStatusAction(@NonNull PlatformStatusAction action) {
        this.components.platformMonitorWiring().getInputWire(PlatformMonitor::submitStatusAction).put((Object)action);
    }

    public void injectPcesMinimumGenerationToStore(@NonNull long minimumGenerationNonAncientForOldestState) {
        this.components.pcesModule().minimumAncientIdentifierInputWire().inject((Object)minimumGenerationNonAncientForOldestState);
    }

    public void injectPcesReplayerIterator(@NonNull IOIterator<PlatformEvent> iterator) {
        this.components.pcesReplayerWiring().pcesIteratorInputWire().inject(iterator);
    }

    public void dumpStateToDisk(@NonNull StateDumpRequest request) {
        this.components.stateSnapshotManagerWiring().getInputWire(StateSnapshotManager::dumpStateTask).put((Object)request);
    }

    public void injectSignatureCollectorState(@NonNull ReservedSignedState reservedSignedState) {
        this.components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::addReservedState).put((Object)reservedSignedState);
    }

    public void quiescenceCommand(@NonNull QuiescenceCommand quiescenceCommand) {
        this.components.platformMonitorWiring().getInputWire(PlatformMonitor::quiescenceCommand).inject((Object)quiescenceCommand);
        this.components.eventCreatorModule().quiescenceCommandInputWire().inject((Object)quiescenceCommand);
    }
}

