/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;

public class InstantUtils {
    public static final long MICROS_IN_SECOND = 1000000L;
    public static final long NANOS_IN_MICRO = 1000L;

    private InstantUtils() {
    }

    public static long instantToMicros(@NonNull Instant instant) {
        return instant.getEpochSecond() * 1000000L + (long)instant.getNano() / 1000L;
    }

    @NonNull
    public static Instant microsToInstant(long micros) {
        long seconds = micros / 1000000L;
        int nanos = (int)(micros % 1000000L * 1000L);
        return Instant.ofEpochSecond(seconds, nanos);
    }
}

