/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.socket.SocketContext;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.Http1HeadersParser;
import io.helidon.http.Method;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.http1.Http1CallChainBase;
import io.helidon.webclient.http1.Http1ClientImpl;
import io.helidon.webclient.http1.Http1ClientProtocolConfig;
import io.helidon.webclient.http1.Http1ClientRequest;
import io.helidon.webclient.http1.Http1ClientRequestImpl;
import io.helidon.webclient.http1.Http1ClientResponseImpl;
import io.helidon.webclient.http1.Http1StatusParser;
import io.helidon.webclient.http1.OutputStreamInterruptedException;
import io.helidon.webclient.http1.RedirectionProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

class Http1CallOutputStreamChain
extends Http1CallChainBase {
    private final Http1ClientImpl http1Client;
    private final CompletableFuture<WebClientServiceRequest> whenSent;
    private final ClientRequest.OutputStreamHandler osHandler;

    Http1CallOutputStreamChain(Http1ClientImpl http1Client, Http1ClientRequestImpl clientRequest, CompletableFuture<WebClientServiceRequest> whenSent, CompletableFuture<WebClientServiceResponse> whenComplete, ClientRequest.OutputStreamHandler osHandler) {
        super(http1Client, clientRequest, whenComplete);
        this.http1Client = http1Client;
        this.whenSent = whenSent;
        this.osHandler = osHandler;
    }

    @Override
    WebClientServiceResponse doProceed(ClientConnection connection, WebClientServiceRequest serviceRequest, ClientRequestHeaders headers, DataWriter writer, DataReader reader, BufferData writeBuffer) {
        Status responseStatus;
        ClientConnectionOutputStream cos = new ClientConnectionOutputStream(connection, writer, reader, writeBuffer, (WritableHeaders<?>)headers, this.http1Client.clientConfig(), this.http1Client.protocolConfig(), serviceRequest, this.originalRequest(), this.whenSent, this.whenComplete());
        boolean interrupted = false;
        try {
            this.osHandler.handle((OutputStream)cos);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (OutputStreamInterruptedException e) {
            interrupted = true;
        }
        if (interrupted || cos.interrupted()) {
            return cos.serviceResponse();
        }
        if (!cos.closed()) {
            throw new IllegalStateException("Output stream was not closed in handler");
        }
        reader = cos.reader;
        connection = cos.connection;
        try {
            responseStatus = Http1StatusParser.readStatus(reader, this.http1Client.protocolConfig().maxStatusLineLength());
            if (responseStatus == Status.CONTINUE_100) {
                this.readHeaders(reader);
                responseStatus = Http1StatusParser.readStatus(reader, this.http1Client.protocolConfig().maxStatusLineLength());
            }
        }
        catch (UncheckedIOException e) {
            try {
                connection.closeResource();
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
        connection.helidonSocket().log(LOGGER_RES_STATUS, System.Logger.Level.TRACE, "client received status %n%s", new Object[]{responseStatus});
        ClientResponseHeaders responseHeaders = this.readHeaders(reader);
        connection.helidonSocket().log(LOGGER_RES_HEADERS, System.Logger.Level.TRACE, "client received headers %n%s", new Object[]{responseHeaders});
        if (this.originalRequest().followRedirects() && RedirectionProcessor.redirectionStatusCode(responseStatus)) {
            Http1CallOutputStreamChain.checkRedirectHeaders((Headers)responseHeaders);
            URI newUri = URI.create((String)responseHeaders.get(HeaderNames.LOCATION).get());
            ClientUri redirectUri = ClientUri.create((URI)newUri);
            if (newUri.getHost() == null) {
                ClientUri resolvedUri = cos.lastRequest.resolvedUri();
                redirectUri.scheme(resolvedUri.scheme());
                redirectUri.host(resolvedUri.host());
                redirectUri.port(resolvedUri.port());
            }
            Http1ClientRequestImpl request = new Http1ClientRequestImpl(cos.lastRequest, Method.GET, redirectUri, (Map<String, String>)cos.lastRequest.properties());
            Http1ClientResponseImpl clientResponse = RedirectionProcessor.invokeWithFollowRedirects(request, 1, BufferData.EMPTY_BYTES);
            return Http1CallOutputStreamChain.createServiceResponse(this.clientConfig(), serviceRequest, clientResponse.connection(), clientResponse.connection().reader(), clientResponse.status(), clientResponse.headers(), this.whenComplete());
        }
        return Http1CallOutputStreamChain.createServiceResponse(this.clientConfig(), serviceRequest, connection, reader, responseStatus, responseHeaders, this.whenComplete());
    }

    private static void checkRedirectHeaders(Headers headerValues) {
        if (!headerValues.contains(HeaderNames.LOCATION)) {
            throw new IllegalStateException("There is no " + String.valueOf(HeaderNames.LOCATION) + " header present in the response! It is not clear where to redirect.");
        }
    }

    private static class ClientConnectionOutputStream
    extends OutputStream {
        private static final byte[] TERMINATING_CHUNK = "0\r\n\r\n".getBytes(StandardCharsets.UTF_8);
        private final WebClientServiceRequest request;
        private final Http1ClientRequestImpl originalRequest;
        private final CompletableFuture<WebClientServiceRequest> whenSent;
        private final CompletableFuture<WebClientServiceResponse> whenComplete;
        private final HttpClientConfig clientConfig;
        private final Http1ClientProtocolConfig protocolConfig;
        private final WritableHeaders<?> headers;
        private final BufferData prologue;
        private boolean chunked;
        private BufferData firstPacket;
        private long bytesWritten;
        private long contentLength;
        private boolean noData = true;
        private boolean closed;
        private boolean interrupted;
        private ClientConnection connection;
        private SocketContext ctx;
        private DataWriter writer;
        private DataReader reader;
        private Http1ClientRequestImpl lastRequest;
        private Http1ClientResponseImpl response;
        private WebClientServiceResponse serviceResponse;

        private ClientConnectionOutputStream(ClientConnection connection, DataWriter writer, DataReader reader, BufferData prologue, WritableHeaders<?> headers, HttpClientConfig clientConfig, Http1ClientProtocolConfig protocolConfig, WebClientServiceRequest request, Http1ClientRequestImpl originalRequest, CompletableFuture<WebClientServiceRequest> whenSent, CompletableFuture<WebClientServiceResponse> whenComplete) {
            this.connection = connection;
            this.ctx = connection.helidonSocket();
            this.writer = writer;
            this.reader = reader;
            this.headers = headers;
            this.prologue = prologue;
            this.clientConfig = clientConfig;
            this.protocolConfig = protocolConfig;
            this.contentLength = headers.contentLength().orElse(-1L);
            this.chunked = this.contentLength == -1L || headers.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED);
            this.request = request;
            this.originalRequest = originalRequest;
            this.lastRequest = originalRequest;
            this.whenSent = whenSent;
            this.whenComplete = whenComplete;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] data = new byte[]{(byte)b};
            this.write(data, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.interrupted) {
                return;
            }
            if (this.closed) {
                throw new IOException("Output stream already closed");
            }
            if (!this.chunked && this.contentLength > 0L) {
                if (!this.whenSent.isDone()) {
                    this.sendPrologueAndHeader();
                    this.noData = false;
                }
                this.writeContent(BufferData.create((byte[])b, (int)off, (int)len));
                return;
            }
            if (!this.chunked) {
                if (this.firstPacket == null) {
                    BufferData first = BufferData.create((int)(len - off));
                    first.write(b, off, len);
                    this.firstPacket = first;
                } else {
                    this.chunked = true;
                    this.sendFirstChunk();
                }
                this.noData = false;
            }
            if (this.chunked) {
                if (this.noData) {
                    this.noData = false;
                    this.sendPrologueAndHeader();
                }
                this.writeChunked(BufferData.create((byte[])b, (int)off, (int)len));
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed || this.interrupted) {
                return;
            }
            this.closed = true;
            if (this.chunked) {
                if (this.firstPacket != null) {
                    this.sendFirstChunk();
                } else if (this.noData) {
                    this.sendPrologueAndHeader();
                }
                BufferData terminating = BufferData.create((byte[])TERMINATING_CHUNK);
                if (Http1CallChainBase.LOGGER_REQ_ENTITY.isLoggable(System.Logger.Level.TRACE)) {
                    this.ctx.log(Http1CallChainBase.LOGGER_REQ_ENTITY, System.Logger.Level.TRACE, "send data%n%s", new Object[]{terminating.debugDataHex()});
                }
                this.writer.write(terminating);
            } else if (this.contentLength > 0L) {
                if (this.contentLength != this.bytesWritten) {
                    throw new IOException("Content length is set to " + this.contentLength + ", but the number of bytes written was " + this.bytesWritten);
                }
            } else {
                this.headers.remove(HeaderNames.TRANSFER_ENCODING);
                if (this.noData) {
                    this.headers.set(HeaderValues.CONTENT_LENGTH_ZERO);
                    this.contentLength = 0L;
                }
                if (this.noData || this.firstPacket != null) {
                    this.sendPrologueAndHeader();
                }
                if (this.firstPacket != null) {
                    this.writeContent(this.firstPacket);
                }
            }
            this.writer.close();
            super.close();
        }

        WebClientServiceResponse serviceResponse() {
            if (this.serviceResponse != null) {
                return this.serviceResponse;
            }
            return Http1CallChainBase.createServiceResponse(this.clientConfig, this.request, this.response.connection(), this.response.connection().reader(), this.response.status(), this.response.headers(), this.whenComplete);
        }

        boolean closed() {
            return this.closed;
        }

        boolean interrupted() {
            return this.interrupted;
        }

        Http1ClientResponseImpl response() {
            return this.response;
        }

        private void writeChunked(BufferData buffer) {
            int available = buffer.available();
            byte[] hex = Integer.toHexString(available).getBytes(StandardCharsets.UTF_8);
            BufferData toWrite = BufferData.create((int)(available + hex.length + 4));
            toWrite.write(hex);
            toWrite.write(13);
            toWrite.write(10);
            toWrite.write(buffer);
            toWrite.write(13);
            toWrite.write(10);
            if (Http1CallChainBase.LOGGER_REQ_ENTITY.isLoggable(System.Logger.Level.TRACE)) {
                this.ctx.log(Http1CallChainBase.LOGGER_REQ_ENTITY, System.Logger.Level.TRACE, "send data:%n%s", new Object[]{toWrite.debugDataHex()});
            }
            this.writer.write(toWrite);
        }

        private void writeContent(BufferData buffer) throws IOException {
            this.bytesWritten += (long)buffer.available();
            if (this.contentLength != -1L && this.bytesWritten > this.contentLength) {
                throw new IOException("Content length was set to " + this.contentLength + ", but you are writing additional " + (this.bytesWritten - this.contentLength) + " bytes");
            }
            if (Http1CallChainBase.LOGGER_REQ_ENTITY.isLoggable(System.Logger.Level.TRACE)) {
                this.ctx.log(Http1CallChainBase.LOGGER_REQ_ENTITY, System.Logger.Level.TRACE, "send data:%n%s", new Object[]{buffer.debugDataHex()});
            }
            this.writer.write(buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendPrologueAndHeader() {
            boolean expects100Continue;
            boolean bl = expects100Continue = this.connection.allowExpectContinue() && !this.noData && this.originalRequest.sendExpectContinue().orElse(this.clientConfig.sendExpectContinue()) != false;
            if (expects100Continue) {
                this.headers.add(HeaderValues.EXPECT_100);
            }
            if (this.chunked) {
                if (!this.headers.contains(HeaderNames.TRANSFER_ENCODING)) {
                    this.headers.set(HeaderValues.TRANSFER_ENCODING_CHUNKED);
                } else if (!this.headers.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED)) {
                    this.headers.add(HeaderValues.TRANSFER_ENCODING_CHUNKED);
                }
                this.headers.remove(HeaderNames.CONTENT_LENGTH);
            }
            BufferData buffer = BufferData.growing((int)512);
            buffer.write(this.prologue);
            if (Http1CallChainBase.LOGGER_REQ_PROLOGUE.isLoggable(System.Logger.Level.TRACE)) {
                this.ctx.log(Http1CallChainBase.LOGGER_REQ_PROLOGUE, System.Logger.Level.TRACE, "send prologue: %n%s", new Object[]{this.prologue.debugDataHex()});
            }
            if (Http1CallChainBase.LOGGER_REQ_HEADERS.isLoggable(System.Logger.Level.TRACE)) {
                this.ctx.log(Http1CallChainBase.LOGGER_REQ_HEADERS, System.Logger.Level.TRACE, "send headers:%n%s", new Object[]{this.headers});
            }
            Http1CallChainBase.writeHeaders(this.connection, this.headers, buffer, this.protocolConfig.validateRequestHeaders());
            this.writer.write(buffer);
            this.whenSent.complete(this.request);
            if (expects100Continue) {
                Status responseStatus;
                try {
                    this.writer.flush();
                    this.connection.readTimeout(this.originalRequest.readContinueTimeout());
                    responseStatus = Http1StatusParser.readStatus(this.reader, this.protocolConfig.maxStatusLineLength());
                    this.connection.helidonSocket().log(Http1CallChainBase.LOGGER_RES_STATUS, System.Logger.Level.TRACE, "recv status: %n%s", new Object[]{responseStatus});
                }
                catch (UncheckedIOException ignored) {
                    responseStatus = null;
                    this.connection.allowExpectContinue(false);
                }
                finally {
                    this.connection.readTimeout(this.originalRequest.readTimeout());
                }
                if (responseStatus == Status.CONTINUE_100) {
                    Http1HeadersParser.readHeaders((DataReader)this.reader, (int)this.protocolConfig.maxHeaderSize(), (boolean)this.protocolConfig.validateResponseHeaders());
                }
                if (responseStatus == null) {
                    responseStatus = Status.CONTINUE_100;
                }
                if (responseStatus != Status.CONTINUE_100) {
                    WritableHeaders responseHeaders = Http1HeadersParser.readHeaders((DataReader)this.reader, (int)this.protocolConfig.maxHeaderSize(), (boolean)this.protocolConfig.validateResponseHeaders());
                    this.connection.helidonSocket().log(Http1CallChainBase.LOGGER_RES_HEADERS, System.Logger.Level.TRACE, "client received headers %n%s", new Object[]{responseHeaders});
                    if (RedirectionProcessor.redirectionStatusCode(responseStatus) && this.originalRequest.followRedirects()) {
                        this.reader.skip(this.reader.available());
                        Http1CallOutputStreamChain.checkRedirectHeaders((Headers)responseHeaders);
                        this.redirect(responseStatus, responseHeaders);
                    } else {
                        this.interrupted = true;
                        this.serviceResponse = Http1CallChainBase.createServiceResponse(this.clientConfig, this.request, this.connection, this.reader, responseStatus, ClientResponseHeaders.create((Headers)responseHeaders), this.whenComplete);
                        throw new OutputStreamInterruptedException();
                    }
                }
            }
        }

        private void redirect(Status lastStatus, WritableHeaders<?> headerValues) {
            boolean sendEntity;
            Method method;
            String redirectedUri = (String)headerValues.get(HeaderNames.LOCATION).get();
            ClientUri lastUri = this.originalRequest.uri();
            if (lastStatus == Status.TEMPORARY_REDIRECT_307 || lastStatus == Status.PERMANENT_REDIRECT_308) {
                method = this.originalRequest.method();
                sendEntity = true;
            } else {
                method = Method.GET;
                sendEntity = false;
            }
            for (int i = 0; i < this.clientConfig.maxRedirects(); ++i) {
                Http1ClientResponseImpl response;
                URI newUri = URI.create(redirectedUri);
                ClientUri redirectUri = ClientUri.create((URI)newUri);
                if (newUri.getHost() == null) {
                    redirectUri.scheme(lastUri.scheme());
                    redirectUri.host(lastUri.host());
                    redirectUri.port(lastUri.port());
                }
                lastUri = redirectUri;
                this.connection.releaseResource();
                Http1ClientRequestImpl clientRequest = new Http1ClientRequestImpl(this.originalRequest, method, redirectUri, (Map<String, String>)this.request.properties());
                if (sendEntity) {
                    response = (Http1ClientResponseImpl)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)clientRequest.header(HeaderValues.EXPECT_100)).header(HeaderValues.TRANSFER_ENCODING_CHUNKED)).readTimeout(this.originalRequest.readContinueTimeout())).request();
                    response.connection().readTimeout(this.originalRequest.readTimeout());
                } else {
                    response = (Http1ClientResponseImpl)clientRequest.request();
                }
                this.lastRequest = clientRequest;
                this.connection = response.connection();
                this.ctx = this.connection.helidonSocket();
                this.reader = this.connection.reader();
                this.writer = this.connection.writer();
                if (RedirectionProcessor.redirectionStatusCode(response.status())) {
                    try (Http1ClientResponseImpl http1ClientResponseImpl = response;){
                        Http1CallOutputStreamChain.checkRedirectHeaders((Headers)response.headers());
                        if (response.status() != Status.TEMPORARY_REDIRECT_307 && response.status() != Status.PERMANENT_REDIRECT_308) {
                            method = Method.GET;
                            sendEntity = false;
                        }
                        redirectedUri = (String)response.headers().get(HeaderNames.LOCATION).get();
                        continue;
                    }
                }
                if (!sendEntity) {
                    this.interrupted = true;
                    this.response = response;
                    throw new OutputStreamInterruptedException();
                }
                this.reader.skip(this.reader.available());
                return;
            }
            throw new IllegalStateException("Maximum number of request redirections (" + this.clientConfig.maxRedirects() + ") reached.");
        }

        private void sendFirstChunk() {
            this.sendPrologueAndHeader();
            this.writeChunked(this.firstPacket);
            this.firstPacket = null;
        }
    }
}

