/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import java.util.List;

public enum TokenKycStatus implements EnumWithProtoMetadata
{
    KYC_NOT_APPLICABLE(0, "KycNotApplicable"),
    GRANTED(1, "Granted"),
    REVOKED(2, "Revoked"),
    UNRECOGNIZED(-1, "UNRECOGNIZED");

    private final int protoOrdinal;
    private final String protoName;

    private TokenKycStatus(int protoOrdinal, String protoName) {
        this.protoOrdinal = protoOrdinal;
        this.protoName = protoName;
    }

    public int protoOrdinal() {
        return this.protoOrdinal;
    }

    public String protoName() {
        return this.protoName;
    }

    public static TokenKycStatus fromProtobufOrdinal(int ordinal) {
        return switch (ordinal) {
            case 0 -> KYC_NOT_APPLICABLE;
            case 1 -> GRANTED;
            case 2 -> REVOKED;
            default -> UNRECOGNIZED;
        };
    }

    public static TokenKycStatus fromString(String name) {
        return switch (name) {
            case "KycNotApplicable", "KYC_NOT_APPLICABLE" -> KYC_NOT_APPLICABLE;
            case "Granted", "GRANTED" -> GRANTED;
            case "Revoked", "REVOKED" -> REVOKED;
            default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
        };
    }

    public static TokenKycStatus fromObject(Object obj) {
        if (obj == null) {
            return TokenKycStatus.fromProtobufOrdinal(0);
        }
        if (obj instanceof TokenKycStatus) {
            TokenKycStatus pbjEnum = (TokenKycStatus)((Object)obj);
            return pbjEnum;
        }
        return UNRECOGNIZED;
    }

    public static List<TokenKycStatus> fromObjects(List<?> list) {
        return list.stream().map(TokenKycStatus::fromObject).toList();
    }

    public static int toProtoOrdinal(Object obj) {
        if (obj instanceof TokenKycStatus) {
            TokenKycStatus pbjEnum = (TokenKycStatus)((Object)obj);
            return pbjEnum.protoOrdinal();
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return i;
        }
        throw new IllegalArgumentException("Neither TokenKycStatus, nor Integer, but: " + obj.getClass().getName());
    }

    public static List<Integer> toProtoOrdinals(List<?> list) {
        return list.stream().map(TokenKycStatus::toProtoOrdinal).toList();
    }

    public static int compare(Object o1, Object o2) {
        int i2;
        int i1;
        if (o1 instanceof TokenKycStatus) {
            TokenKycStatus e1 = (TokenKycStatus)((Object)o1);
            if (o2 instanceof TokenKycStatus) {
                TokenKycStatus e2 = (TokenKycStatus)((Object)o2);
                return e1.compareTo(e2);
            }
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 instanceof TokenKycStatus) {
            TokenKycStatus e1 = (TokenKycStatus)((Object)o1);
            i1 = e1.protoOrdinal();
        } else if (o1 instanceof Integer) {
            Integer ii1 = (Integer)o1;
            i1 = ii1;
        } else {
            throw new IllegalArgumentException("o1 is neither TokenKycStatus, nor Integer. It's: " + o1.getClass().getName());
        }
        if (o2 instanceof TokenKycStatus) {
            TokenKycStatus e2 = (TokenKycStatus)((Object)o2);
            i2 = e2.protoOrdinal();
        } else if (o2 instanceof Integer) {
            Integer ii2 = (Integer)o2;
            i2 = ii2;
        } else {
            throw new IllegalArgumentException("o2 is neither TokenKycStatus, nor Integer. It's: " + o2.getClass().getName());
        }
        return Integer.compare(i1, i2);
    }
}

