/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.binary.QueueState;
import com.swirlds.state.merkle.StateKeyUtils;
import com.swirlds.state.merkle.StateValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public final class StateUtils {
    public static final int STATE_VALUE_QUEUE_STATE = 8001;
    private static final Bytes[] VIRTUAL_MAP_KEY_CACHE = new Bytes[65536];

    private StateUtils() {
    }

    public static Bytes getStateKeyForSingleton(int stateId) {
        Bytes key = VIRTUAL_MAP_KEY_CACHE[stateId];
        if (key == null) {
            StateUtils.VIRTUAL_MAP_KEY_CACHE[stateId] = key = StateKeyUtils.singletonKey(stateId);
        }
        return key;
    }

    public static Bytes getStateKeyForQueue(int stateId, long index) {
        return StateKeyUtils.queueKey(stateId, index);
    }

    public static <K> Bytes getStateKeyForKv(int stateId, K key, Codec<K> keyCodec) {
        return StateKeyUtils.kvKey(stateId, key, keyCodec);
    }

    public static <V> StateValue<V> getStateValueForSingleton(int stateId, V value) {
        return new StateValue<V>(stateId, value);
    }

    public static <V> StateValue<V> getStateValueForQueue(int stateId, V value) {
        return new StateValue<V>(stateId, value);
    }

    public static StateValue<QueueState> getStateValueForQueueState(QueueState queueState) {
        return new StateValue<QueueState>(8001, queueState);
    }

    public static <V> StateValue<V> getStateValueForKv(int stateId, V value) {
        return new StateValue<V>(stateId, value);
    }

    static Bytes wrapValue(int stateId, @NonNull Bytes rawValue) {
        int tag = stateId << 3 | ProtoConstants.WIRE_TYPE_DELIMITED.ordinal();
        int valueLength = (int)rawValue.length();
        int tagSize = ProtoWriterTools.sizeOfVarInt32((int)tag);
        int valueSize = ProtoWriterTools.sizeOfVarInt32((int)valueLength);
        int total = tagSize + valueSize + valueLength;
        byte[] buffer = new byte[total];
        BufferedData out = BufferedData.wrap((byte[])buffer);
        out.writeVarInt(tag, false);
        out.writeVarInt(valueLength, false);
        int offset = (int)out.position();
        rawValue.writeTo(buffer, offset);
        return Bytes.wrap((byte[])buffer);
    }

    @NonNull
    public static Bytes unwrap(@NonNull Bytes stateValueBytes) {
        Bytes bytes;
        block9: {
            ReadableSequentialData sequentialData = stateValueBytes.toReadableSequentialData();
            sequentialData.readVarInt(false);
            int valueSize = sequentialData.readVarInt(false);
            assert ((long)valueSize == sequentialData.remaining()) : "Value size mismatch";
            InputStream is = sequentialData.asInputStream();
            try {
                bytes = Bytes.wrap((byte[])is.readAllBytes());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return bytes;
    }
}

