/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.iskyc;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.iskyc.IsKycCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class IsKycTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod IS_KYC = SystemContractMethod.declare("isKyc(address,address)", "(int32,bool)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.TOKEN_QUERY, SystemContractMethod.Category.KYC);

    @Inject
    public IsKycTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(IS_KYC);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(IS_KYC);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        Tuple args = IS_KYC.decodeCall(attempt.input().toArrayUnsafe());
        Token token = attempt.linkedToken(ConversionUtils.fromHeadlongAddress((Address)args.get(0)));
        return new IsKycCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.isStaticCall(), token, (Address)args.get(1));
    }
}

