/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.authorization;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.file.SystemDeleteTransactionBody;
import com.hedera.hapi.node.file.SystemUndeleteTransactionBody;
import com.hedera.hapi.node.token.CryptoUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.authorization.SystemPrivilege;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.LedgerConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;

public class PrivilegesVerifier {
    private static final long FIRST_SYSTEM_FILE_ENTITY = 101L;
    private static final long FIRST_POST_SYSTEM_FILE_ENTITY = 200L;
    private final AccountsConfig accountsConfig;
    private final FilesConfig filesConfig;
    private final long numReservedSystemEntities;

    @Inject
    public PrivilegesVerifier(@NonNull ConfigProvider configProvider) {
        Objects.requireNonNull(configProvider, "configProvider cannot be null");
        VersionedConfiguration configuration = configProvider.getConfiguration();
        this.accountsConfig = (AccountsConfig)configuration.getConfigData(AccountsConfig.class);
        this.filesConfig = (FilesConfig)configuration.getConfigData(FilesConfig.class);
        this.numReservedSystemEntities = ((LedgerConfig)configuration.getConfigData(LedgerConfig.class)).numReservedSystemEntities();
    }

    public SystemPrivilege hasPrivileges(@NonNull AccountID payerId, @NonNull HederaFunctionality functionality, @NonNull TransactionBody txBody) {
        return switch (functionality) {
            case HederaFunctionality.FREEZE -> this.checkFreeze(payerId);
            case HederaFunctionality.SYSTEM_DELETE -> this.checkSystemDelete(payerId, txBody.systemDeleteOrThrow());
            case HederaFunctionality.SYSTEM_UNDELETE -> this.checkSystemUndelete(payerId, txBody.systemUndeleteOrThrow());
            case HederaFunctionality.UNCHECKED_SUBMIT -> this.checkUncheckedSubmit(payerId);
            case HederaFunctionality.FILE_UPDATE -> this.checkFileChange(payerId, txBody.fileUpdateOrThrow().fileIDOrThrow().fileNum());
            case HederaFunctionality.FILE_APPEND -> this.checkFileChange(payerId, txBody.fileAppendOrThrow().fileIDOrThrow().fileNum());
            case HederaFunctionality.CRYPTO_UPDATE -> this.checkCryptoUpdate(payerId, txBody.cryptoUpdateAccountOrThrow());
            case HederaFunctionality.FILE_DELETE -> this.checkEntityDelete(txBody.fileDeleteOrThrow().fileIDOrThrow().fileNum());
            case HederaFunctionality.CRYPTO_DELETE -> this.checkCryptoDelete(this.effectiveNumber(txBody.cryptoDeleteOrThrow().deleteAccountIDOrElse(AccountID.DEFAULT)));
            case HederaFunctionality.NODE_CREATE -> this.checkNodeCreate(payerId);
            default -> SystemPrivilege.UNNECESSARY;
        };
    }

    private boolean isSuperUser(@NonNull AccountID accountID) {
        long accountNum = this.effectiveNumber(accountID);
        return accountNum == this.accountsConfig.treasury() || accountNum == this.accountsConfig.systemAdmin();
    }

    private boolean isTreasury(@NonNull AccountID accountID) {
        return this.effectiveNumber(accountID) == this.accountsConfig.treasury();
    }

    private boolean hasSoftwareUpdatePrivilege(@NonNull AccountID accountID) {
        return this.effectiveNumber(accountID) == this.accountsConfig.softwareUpdateAdmin() || this.isSuperUser(accountID);
    }

    private boolean hasFreezePrivilege(@NonNull AccountID accountID) {
        return this.effectiveNumber(accountID) == this.accountsConfig.freezeAdmin() || this.isSuperUser(accountID);
    }

    private boolean hasSystemDeletePrivilege(@NonNull AccountID accountID) {
        return this.effectiveNumber(accountID) == this.accountsConfig.systemDeleteAdmin() || this.isSuperUser(accountID);
    }

    private boolean hasSystemUndeletePrivilege(@NonNull AccountID accountID) {
        return this.effectiveNumber(accountID) == this.accountsConfig.systemUndeleteAdmin() || this.isSuperUser(accountID);
    }

    private boolean hasAddressBookPrivilege(@NonNull AccountID accountID) {
        return this.effectiveNumber(accountID) == this.accountsConfig.addressBookAdmin() || this.isSuperUser(accountID);
    }

    private boolean hasExchangeRatePrivilege(@NonNull AccountID accountID) {
        return this.effectiveNumber(accountID) == this.accountsConfig.exchangeRatesAdmin() || this.isSuperUser(accountID);
    }

    private boolean hasFeeSchedulePrivilege(@NonNull AccountID accountID) {
        return this.effectiveNumber(accountID) == this.accountsConfig.feeSchedulesAdmin() || this.isSuperUser(accountID);
    }

    private boolean hasNodeCreatePrivilege(@NonNull AccountID accountID) {
        return this.effectiveNumber(accountID) == this.accountsConfig.addressBookAdmin() || this.isSuperUser(accountID);
    }

    private SystemPrivilege checkFreeze(@NonNull AccountID accountID) {
        return this.hasFreezePrivilege(accountID) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
    }

    private SystemPrivilege checkSystemDelete(@NonNull AccountID accountID, @NonNull SystemDeleteTransactionBody op) {
        long entityNum;
        long l = entityNum = op.hasFileID() ? op.fileIDOrThrow().fileNum() : this.effectiveNumber(op.contractIDOrThrow());
        if (this.isSystemEntity(entityNum)) {
            return SystemPrivilege.IMPERMISSIBLE;
        }
        return this.hasSystemDeletePrivilege(accountID) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
    }

    private SystemPrivilege checkSystemUndelete(@NonNull AccountID accountID, @NonNull SystemUndeleteTransactionBody op) {
        long entityNum;
        long l = entityNum = op.hasFileID() ? op.fileIDOrThrow().fileNum() : this.effectiveNumber(op.contractIDOrThrow());
        if (this.isSystemEntity(entityNum)) {
            return SystemPrivilege.IMPERMISSIBLE;
        }
        return this.hasSystemUndeletePrivilege(accountID) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
    }

    private SystemPrivilege checkUncheckedSubmit(@NonNull AccountID accountID) {
        return this.isSuperUser(accountID) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
    }

    private SystemPrivilege checkFileChange(@NonNull AccountID accountID, long entityNum) {
        if (!this.isSystemEntity(entityNum)) {
            return SystemPrivilege.UNNECESSARY;
        }
        if (entityNum == this.filesConfig.addressBook() || entityNum == this.filesConfig.nodeDetails()) {
            return this.hasAddressBookPrivilege(accountID) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
        }
        if (entityNum == this.filesConfig.networkProperties() || entityNum == this.filesConfig.hapiPermissions()) {
            return this.hasAddressBookPrivilege(accountID) || this.hasExchangeRatePrivilege(accountID) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
        }
        if (entityNum == this.filesConfig.feeSchedules()) {
            return this.hasFeeSchedulePrivilege(accountID) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
        }
        if (entityNum == this.filesConfig.simpleFeesSchedules()) {
            return this.hasFeeSchedulePrivilege(accountID) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
        }
        if (entityNum == this.filesConfig.exchangeRates()) {
            return this.hasExchangeRatePrivilege(accountID) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
        }
        if (this.filesConfig.softwareUpdateRange().left() <= entityNum && entityNum <= this.filesConfig.softwareUpdateRange().right()) {
            return this.hasSoftwareUpdatePrivilege(accountID) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
        }
        if (entityNum == this.filesConfig.throttleDefinitions()) {
            return this.hasAddressBookPrivilege(accountID) || this.hasExchangeRatePrivilege(accountID) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
        }
        return SystemPrivilege.UNAUTHORIZED;
    }

    private SystemPrivilege checkCryptoUpdate(@NonNull AccountID payerId, @NonNull CryptoUpdateTransactionBody op) {
        AccountID targetId = op.accountIDToUpdateOrElse(AccountID.DEFAULT);
        long targetNum = this.effectiveNumber(targetId);
        if (!this.isSystemEntity(targetNum)) {
            return SystemPrivilege.UNNECESSARY;
        }
        long payerNum = payerId.accountNumOrElse(Long.valueOf(0L));
        if (payerNum == this.accountsConfig.treasury()) {
            return SystemPrivilege.AUTHORIZED;
        }
        if (payerNum == this.accountsConfig.systemAdmin()) {
            return this.isTreasury(targetId) ? SystemPrivilege.UNAUTHORIZED : SystemPrivilege.AUTHORIZED;
        }
        return this.isTreasury(targetId) ? SystemPrivilege.UNAUTHORIZED : SystemPrivilege.UNNECESSARY;
    }

    private SystemPrivilege checkNodeCreate(@NonNull AccountID payerId) {
        return this.hasNodeCreatePrivilege(payerId) ? SystemPrivilege.AUTHORIZED : SystemPrivilege.UNAUTHORIZED;
    }

    private SystemPrivilege checkEntityDelete(long entityNum) {
        return this.isSystemEntity(entityNum) ? SystemPrivilege.IMPERMISSIBLE : SystemPrivilege.UNNECESSARY;
    }

    private SystemPrivilege checkCryptoDelete(long entityNum) {
        return this.isSystemEntity(entityNum) && !this.isSystemFile(entityNum) ? SystemPrivilege.IMPERMISSIBLE : SystemPrivilege.UNNECESSARY;
    }

    private boolean isSystemFile(long entityNum) {
        return 101L <= entityNum && entityNum < 200L;
    }

    private boolean isSystemEntity(long entityNum) {
        return 1L <= entityNum && entityNum <= this.numReservedSystemEntities;
    }

    private long effectiveNumber(@NonNull AccountID accountID) {
        if (accountID.hasAlias()) {
            byte[] rawAlias = accountID.aliasOrThrow().toByteArray();
            if (ConversionUtils.isLongZeroAddress((byte[])rawAlias)) {
                return ConversionUtils.numberOfLongZero((byte[])rawAlias);
            }
            return 0L;
        }
        return accountID.accountNumOrElse(Long.valueOf(0L));
    }

    private long effectiveNumber(@NonNull ContractID contractID) {
        if (contractID.hasEvmAddress()) {
            byte[] rawAlias = contractID.evmAddressOrThrow().toByteArray();
            if (ConversionUtils.isLongZeroAddress((byte[])rawAlias)) {
                return ConversionUtils.numberOfLongZero((byte[])rawAlias);
            }
            return 0L;
        }
        return contractID.contractNumOrElse(Long.valueOf(0L));
    }
}

