/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.pricing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hedera.node.app.hapi.fees.pricing.UsableResource;
import com.hederahashgraph.api.proto.java.HederaFunctionality;
import com.hederahashgraph.api.proto.java.SubType;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AssetsLoader {
    private static final String CAPACITIES_RESOURCE = "capacities.json";
    private static final String CONSTANT_WEIGHTS_RESOURCE = "constant-weights.json";
    private static final String CANONICAL_PRICES_RESOURCE = "canonical-prices.json";
    private Map<UsableResource, BigDecimal> cachedCapacities = null;
    private Map<HederaFunctionality, BigDecimal> cachedConstWeights = null;
    private Map<HederaFunctionality, Map<SubType, BigDecimal>> cachedCanonicalPrices = null;

    @Inject
    public AssetsLoader() {
    }

    Map<HederaFunctionality, BigDecimal> loadConstWeights() throws IOException {
        if (this.cachedConstWeights != null) {
            return this.cachedConstWeights;
        }
        try (InputStream fin = AssetsLoader.class.getClassLoader().getResourceAsStream(CONSTANT_WEIGHTS_RESOURCE);){
            ObjectMapper om = new ObjectMapper();
            Map constWeights = (Map)om.readValue(fin, Map.class);
            EnumMap<HederaFunctionality, BigDecimal> typedConstWeights = new EnumMap<HederaFunctionality, BigDecimal>(HederaFunctionality.class);
            constWeights.forEach((funcName, weight) -> {
                HederaFunctionality function = HederaFunctionality.valueOf((String)((String)funcName));
                BigDecimal bdWeight = BigDecimal.valueOf((Double)weight);
                typedConstWeights.put(function, bdWeight);
            });
            this.cachedConstWeights = typedConstWeights;
            EnumMap<HederaFunctionality, BigDecimal> enumMap = typedConstWeights;
            return enumMap;
        }
    }

    Map<UsableResource, BigDecimal> loadCapacities() throws IOException {
        if (this.cachedCapacities != null) {
            return this.cachedCapacities;
        }
        try (InputStream fin = AssetsLoader.class.getClassLoader().getResourceAsStream(CAPACITIES_RESOURCE);){
            ObjectMapper om = new ObjectMapper();
            Map capacities = (Map)om.readValue(fin, Map.class);
            EnumMap<UsableResource, BigDecimal> typedCapacities = new EnumMap<UsableResource, BigDecimal>(UsableResource.class);
            capacities.forEach((resourceName, amount) -> {
                BigDecimal bigDecimal;
                UsableResource resource = UsableResource.valueOf((String)resourceName);
                if (amount instanceof Long) {
                    Long val = (Long)amount;
                    bigDecimal = BigDecimal.valueOf(val);
                } else {
                    bigDecimal = BigDecimal.valueOf(((Integer)amount).intValue());
                }
                BigDecimal bdAmount = bigDecimal;
                typedCapacities.put(resource, bdAmount);
            });
            this.cachedCapacities = typedCapacities;
            EnumMap<UsableResource, BigDecimal> enumMap = typedCapacities;
            return enumMap;
        }
    }

    public Map<HederaFunctionality, Map<SubType, BigDecimal>> loadCanonicalPrices() throws IOException {
        if (this.cachedCanonicalPrices != null) {
            return this.cachedCanonicalPrices;
        }
        try (InputStream fin = AssetsLoader.class.getClassLoader().getResourceAsStream(CANONICAL_PRICES_RESOURCE);){
            ObjectMapper om = new ObjectMapper();
            Map prices = (Map)om.readValue(fin, Map.class);
            EnumMap<HederaFunctionality, Map<SubType, BigDecimal>> typedPrices = new EnumMap<HederaFunctionality, Map<SubType, BigDecimal>>(HederaFunctionality.class);
            prices.forEach((funName, priceMap) -> {
                HederaFunctionality function = HederaFunctionality.valueOf((String)((String)funName));
                EnumMap scopedPrices = new EnumMap(SubType.class);
                ((Map)priceMap).forEach((typeName, price) -> {
                    BigDecimal bigDecimal;
                    SubType type = SubType.valueOf((String)((String)typeName));
                    if (price instanceof Double) {
                        Double val = (Double)price;
                        bigDecimal = BigDecimal.valueOf(val);
                    } else {
                        bigDecimal = BigDecimal.valueOf(((Integer)price).intValue());
                    }
                    BigDecimal bdPrice = bigDecimal;
                    scopedPrices.put(type, bdPrice);
                });
                typedPrices.put(function, scopedPrices);
            });
            this.cachedCanonicalPrices = typedPrices;
            EnumMap<HederaFunctionality, Map<SubType, BigDecimal>> enumMap = typedPrices;
            return enumMap;
        }
    }
}

