/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.addressbook.codec;

import com.hedera.hapi.node.addressbook.NodeUpdateTransactionBody;
import com.hedera.hapi.node.addressbook.schema.NodeUpdateTransactionBodySchema;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class NodeUpdateTransactionBodyJsonCodec
implements JsonCodec<NodeUpdateTransactionBody> {
    @NonNull
    public NodeUpdateTransactionBody parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_node_id = 0L;
            AccountID temp_account_id = null;
            String temp_description = null;
            List temp_gossip_endpoint = Collections.emptyList();
            List temp_service_endpoint = Collections.emptyList();
            Bytes temp_gossip_ca_certificate = null;
            Bytes temp_grpc_certificate_hash = null;
            Key temp_admin_key = null;
            Boolean temp_decline_reward = null;
            ServiceEndpoint temp_grpc_proxy_endpoint = null;
            List<Long> temp_associated_registered_node = Collections.emptyList();
            block28: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "nodeId": {
                        temp_node_id = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block28;
                    }
                    case "accountId": {
                        temp_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block28;
                    }
                    case "description": {
                        temp_description = JsonTools.unescape((String)JsonTools.checkSize((String)"description", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block28;
                    }
                    case "gossipEndpoint": {
                        temp_gossip_endpoint = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"gossip_endpoint", (List)kvPair.value().arr().value(), (int)maxSize), ServiceEndpoint.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block28;
                    }
                    case "serviceEndpoint": {
                        temp_service_endpoint = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"service_endpoint", (List)kvPair.value().arr().value(), (int)maxSize), ServiceEndpoint.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block28;
                    }
                    case "gossipCaCertificate": {
                        temp_gossip_ca_certificate = Bytes.fromBase64((String)JsonTools.checkSize((String)"gossip_ca_certificate", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block28;
                    }
                    case "grpcCertificateHash": {
                        temp_grpc_certificate_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"grpc_certificate_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block28;
                    }
                    case "adminKey": {
                        temp_admin_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block28;
                    }
                    case "declineReward": {
                        temp_decline_reward = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block28;
                    }
                    case "grpcProxyEndpoint": {
                        temp_grpc_proxy_endpoint = (ServiceEndpoint)ServiceEndpoint.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block28;
                    }
                    case "associatedRegisteredNode": {
                        temp_associated_registered_node = JsonTools.checkSize((String)"associated_registered_node", (List)kvPair.value().arr().value(), (int)maxSize).stream().map(v -> JsonTools.parseLong((JSONParser.ValueContext)v)).toList();
                        continue block28;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new NodeUpdateTransactionBody(temp_node_id, temp_account_id, temp_description, temp_gossip_endpoint, temp_service_endpoint, temp_gossip_ca_certificate, temp_grpc_certificate_hash, temp_admin_key, temp_decline_reward, temp_grpc_proxy_endpoint, temp_associated_registered_node);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull NodeUpdateTransactionBody data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.nodeId() != 0L) {
            fieldLines.add(JsonTools.field((String)"nodeId", (long)data.nodeId()));
        }
        if (data.accountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"accountId", AccountID.JSON, (Object)data.accountId()));
        }
        if (data.description() != null) {
            fieldLines.add(JsonTools.field((String)"description", (String)data.description()));
        }
        if (!data.gossipEndpoint().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"gossipEndpoint", ServiceEndpoint.JSON, data.gossipEndpoint()));
        }
        if (!data.serviceEndpoint().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"serviceEndpoint", ServiceEndpoint.JSON, data.serviceEndpoint()));
        }
        if (data.gossipCaCertificate() != null) {
            fieldLines.add(JsonTools.field((String)"gossipCaCertificate", (Bytes)data.gossipCaCertificate()));
        }
        if (data.grpcCertificateHash() != null) {
            fieldLines.add(JsonTools.field((String)"grpcCertificateHash", (Bytes)data.grpcCertificateHash()));
        }
        if (data.adminKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"adminKey", Key.JSON, (Object)data.adminKey()));
        }
        if (data.declineReward() != null) {
            fieldLines.add(JsonTools.field((String)"declineReward", (Boolean)data.declineReward()));
        }
        if (data.grpcProxyEndpoint() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"grpcProxyEndpoint", ServiceEndpoint.JSON, (Object)data.grpcProxyEndpoint()));
        }
        if (!data.associatedRegisteredNode().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"associatedRegisteredNode", (FieldDefinition)NodeUpdateTransactionBodySchema.ASSOCIATED_REGISTERED_NODE, data.associatedRegisteredNode()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

