/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import java.util.List;

public enum BlockHashAlgorithm implements EnumWithProtoMetadata
{
    SHA2_384(0, "SHA2_384"),
    UNRECOGNIZED(-1, "UNRECOGNIZED");

    private final int protoOrdinal;
    private final String protoName;

    private BlockHashAlgorithm(int protoOrdinal, String protoName) {
        this.protoOrdinal = protoOrdinal;
        this.protoName = protoName;
    }

    public int protoOrdinal() {
        return this.protoOrdinal;
    }

    public String protoName() {
        return this.protoName;
    }

    public static BlockHashAlgorithm fromProtobufOrdinal(int ordinal) {
        return switch (ordinal) {
            case 0 -> SHA2_384;
            default -> UNRECOGNIZED;
        };
    }

    public static BlockHashAlgorithm fromString(String name) {
        switch (name) {
            case "SHA2_384": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown token kyc status " + name);
            }
        }
        return SHA2_384;
    }

    public static BlockHashAlgorithm fromObject(Object obj) {
        if (obj == null) {
            return BlockHashAlgorithm.fromProtobufOrdinal(0);
        }
        if (obj instanceof BlockHashAlgorithm) {
            BlockHashAlgorithm pbjEnum = (BlockHashAlgorithm)((Object)obj);
            return pbjEnum;
        }
        return UNRECOGNIZED;
    }

    public static List<BlockHashAlgorithm> fromObjects(List<?> list) {
        return list.stream().map(BlockHashAlgorithm::fromObject).toList();
    }

    public static int toProtoOrdinal(Object obj) {
        if (obj instanceof BlockHashAlgorithm) {
            BlockHashAlgorithm pbjEnum = (BlockHashAlgorithm)((Object)obj);
            return pbjEnum.protoOrdinal();
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return i;
        }
        throw new IllegalArgumentException("Neither BlockHashAlgorithm, nor Integer, but: " + obj.getClass().getName());
    }

    public static List<Integer> toProtoOrdinals(List<?> list) {
        return list.stream().map(BlockHashAlgorithm::toProtoOrdinal).toList();
    }

    public static int compare(Object o1, Object o2) {
        int i2;
        int i1;
        if (o1 instanceof BlockHashAlgorithm) {
            BlockHashAlgorithm e1 = (BlockHashAlgorithm)((Object)o1);
            if (o2 instanceof BlockHashAlgorithm) {
                BlockHashAlgorithm e2 = (BlockHashAlgorithm)((Object)o2);
                return e1.compareTo(e2);
            }
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 instanceof BlockHashAlgorithm) {
            BlockHashAlgorithm e1 = (BlockHashAlgorithm)((Object)o1);
            i1 = e1.protoOrdinal();
        } else if (o1 instanceof Integer) {
            Integer ii1 = (Integer)o1;
            i1 = ii1;
        } else {
            throw new IllegalArgumentException("o1 is neither BlockHashAlgorithm, nor Integer. It's: " + o1.getClass().getName());
        }
        if (o2 instanceof BlockHashAlgorithm) {
            BlockHashAlgorithm e2 = (BlockHashAlgorithm)((Object)o2);
            i2 = e2.protoOrdinal();
        } else if (o2 instanceof Integer) {
            Integer ii2 = (Integer)o2;
            i2 = ii2;
        } else {
            throw new IllegalArgumentException("o2 is neither BlockHashAlgorithm, nor Integer. It's: " + o2.getClass().getName());
        }
        return Integer.compare(i1, i2);
    }
}

