/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.intake.impl;

import com.swirlds.base.time.Time;
import com.swirlds.component.framework.component.ComponentWiring;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.transformers.WireTransformer;
import com.swirlds.component.framework.wires.SolderType;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.hiero.consensus.crypto.ConsensusCryptoUtils;
import org.hiero.consensus.crypto.DefaultEventHasher;
import org.hiero.consensus.crypto.EventHasher;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.event.intake.EventIntakeModule;
import org.hiero.consensus.event.intake.config.EventIntakeWiringConfig;
import org.hiero.consensus.event.intake.impl.deduplication.EventDeduplicator;
import org.hiero.consensus.event.intake.impl.deduplication.StandardEventDeduplicator;
import org.hiero.consensus.event.intake.impl.signature.DefaultEventSignatureValidator;
import org.hiero.consensus.event.intake.impl.signature.EventSignatureValidator;
import org.hiero.consensus.event.intake.impl.validation.DefaultInternalEventValidator;
import org.hiero.consensus.event.intake.impl.validation.InternalEventValidator;
import org.hiero.consensus.metrics.statistics.EventPipelineTracker;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.orphan.DefaultOrphanBuffer;
import org.hiero.consensus.orphan.OrphanBuffer;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.transaction.TransactionLimits;

public class DefaultEventIntakeModule
implements EventIntakeModule {
    @Nullable
    private WireTransformer<EventWindow, EventWindow> eventWindowDispatcher;
    @Nullable
    private WireTransformer<Object, Object> clearCommandDispatcher;
    @Nullable
    private ComponentWiring<EventHasher, PlatformEvent> eventHasherWiring;
    @Nullable
    private ComponentWiring<InternalEventValidator, PlatformEvent> eventValidatorWiring;
    @Nullable
    private ComponentWiring<EventDeduplicator, PlatformEvent> eventDeduplicatorWiring;
    @Nullable
    private ComponentWiring<EventSignatureValidator, PlatformEvent> eventSignatureValidatorWiring;
    @Nullable
    private ComponentWiring<OrphanBuffer, List<PlatformEvent>> orphanBufferWiring;

    public void initialize(@NonNull WiringModel model, @NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull RosterHistory rosterHistory, @NonNull IntakeEventCounter intakeEventCounter, @NonNull TransactionLimits transactionLimits, @Nullable EventPipelineTracker pipelineTracker) {
        if (this.eventHasherWiring != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.eventWindowDispatcher = new WireTransformer(model, "EventWindowDispatcher", "event window", UnaryOperator.identity());
        this.clearCommandDispatcher = new WireTransformer(model, "ClearCommandDispatcher", "clear commands", UnaryOperator.identity());
        EventIntakeWiringConfig wiringConfig = (EventIntakeWiringConfig)configuration.getConfigData(EventIntakeWiringConfig.class);
        this.eventHasherWiring = new ComponentWiring(model, EventHasher.class, wiringConfig.eventHasher());
        this.eventValidatorWiring = new ComponentWiring(model, InternalEventValidator.class, wiringConfig.internalEventValidator());
        this.eventDeduplicatorWiring = new ComponentWiring(model, EventDeduplicator.class, wiringConfig.eventDeduplicator());
        this.eventSignatureValidatorWiring = new ComponentWiring(model, EventSignatureValidator.class, wiringConfig.eventSignatureValidator());
        this.orphanBufferWiring = new ComponentWiring(model, OrphanBuffer.class, wiringConfig.orphanBuffer());
        this.eventHasherWiring.getOutputWire().solderTo(this.eventValidatorWiring.getInputWire(InternalEventValidator::validateEvent));
        this.eventValidatorWiring.getOutputWire().solderTo(this.eventDeduplicatorWiring.getInputWire(EventDeduplicator::handleEvent));
        this.eventWindowDispatcher.getOutputWire().solderTo(this.eventDeduplicatorWiring.getInputWire(EventDeduplicator::setEventWindow), SolderType.INJECT);
        this.clearCommandDispatcher.getOutputWire().solderTo(this.eventDeduplicatorWiring.getInputWire(EventDeduplicator::clear), SolderType.INJECT);
        this.eventDeduplicatorWiring.getOutputWire().solderTo(this.eventSignatureValidatorWiring.getInputWire(EventSignatureValidator::validateSignature));
        this.eventWindowDispatcher.getOutputWire().solderTo(this.eventSignatureValidatorWiring.getInputWire(EventSignatureValidator::setEventWindow), SolderType.INJECT);
        this.eventSignatureValidatorWiring.getOutputWire().solderTo(this.orphanBufferWiring.getInputWire(OrphanBuffer::handleEvent, "unordered events"));
        this.eventWindowDispatcher.getOutputWire().solderTo(this.orphanBufferWiring.getInputWire(OrphanBuffer::setEventWindow, "event window"), SolderType.INJECT);
        this.clearCommandDispatcher.getOutputWire().solderTo(this.orphanBufferWiring.getInputWire(OrphanBuffer::clear), SolderType.INJECT);
        if (pipelineTracker != null) {
            pipelineTracker.registerMetric("hashing");
            this.eventHasherWiring.getOutputWire().solderForMonitoring(platformEvent -> pipelineTracker.recordEvent("hashing", platformEvent.getTimeReceived()));
            pipelineTracker.registerMetric("validation");
            this.eventValidatorWiring.getOutputWire().solderForMonitoring(platformEvent -> pipelineTracker.recordEvent("validation", platformEvent.getTimeReceived()));
            pipelineTracker.registerMetric("deduplication");
            this.eventDeduplicatorWiring.getOutputWire().solderForMonitoring(platformEvent -> pipelineTracker.recordEvent("deduplication", platformEvent.getTimeReceived()));
            pipelineTracker.registerMetric("verification");
            this.eventSignatureValidatorWiring.getOutputWire().solderForMonitoring(platformEvent -> pipelineTracker.recordEvent("verification", platformEvent.getTimeReceived()));
            pipelineTracker.registerMetric("orphanBuffer");
            this.orphanBufferWiring.getSplitOutput().solderForMonitoring(platformEvent -> pipelineTracker.recordEvent("orphanBuffer", ((PlatformEvent)platformEvent).getTimeReceived()));
        }
        this.eventDeduplicatorWiring.getInputWire(EventDeduplicator::clear);
        this.eventSignatureValidatorWiring.getInputWire(EventSignatureValidator::updateRosterHistory);
        this.orphanBufferWiring.getInputWire(OrphanBuffer::clear);
        DefaultEventHasher eventHasher = new DefaultEventHasher();
        this.eventHasherWiring.bind((Object)eventHasher);
        DefaultInternalEventValidator internalEventValidator = new DefaultInternalEventValidator(metrics, time, intakeEventCounter, transactionLimits);
        this.eventValidatorWiring.bind((Object)internalEventValidator);
        StandardEventDeduplicator eventDeduplicator = new StandardEventDeduplicator(metrics, intakeEventCounter);
        this.eventDeduplicatorWiring.bind((Object)eventDeduplicator);
        DefaultEventSignatureValidator eventSignatureValidator = new DefaultEventSignatureValidator(metrics, time, ConsensusCryptoUtils::verifySignature, rosterHistory, intakeEventCounter);
        this.eventSignatureValidatorWiring.bind((Object)eventSignatureValidator);
        DefaultOrphanBuffer orphanBuffer = new DefaultOrphanBuffer(metrics, intakeEventCounter);
        this.orphanBufferWiring.bind((Object)orphanBuffer);
    }

    @NonNull
    public OutputWire<PlatformEvent> validatedEventsOutputWire() {
        return Objects.requireNonNull(this.orphanBufferWiring, "Not initialized").getSplitOutput();
    }

    @NonNull
    public InputWire<PlatformEvent> unhashedEventsInputWire() {
        return Objects.requireNonNull(this.eventHasherWiring, "Not initialized").getInputWire(EventHasher::hashEvent);
    }

    @NonNull
    public InputWire<PlatformEvent> nonValidatedEventsInputWire() {
        return Objects.requireNonNull(this.eventValidatorWiring, "Not initialized").getInputWire(InternalEventValidator::validateEvent);
    }

    @NonNull
    public InputWire<EventWindow> eventWindowInputWire() {
        return Objects.requireNonNull(this.eventWindowDispatcher, "Not initialized").getInputWire();
    }

    @NonNull
    public InputWire<RosterHistory> rosterHistoryInputWire() {
        return Objects.requireNonNull(this.eventSignatureValidatorWiring, "Not initialized").getInputWire(EventSignatureValidator::updateRosterHistory);
    }

    @NonNull
    public InputWire<Object> clearComponentsInputWire() {
        return Objects.requireNonNull(this.clearCommandDispatcher, "Not initialized").getInputWire();
    }

    public void flush() {
        Objects.requireNonNull(this.eventHasherWiring, "Not initialized").flush();
        Objects.requireNonNull(this.eventValidatorWiring, "Not initialized").flush();
        Objects.requireNonNull(this.eventDeduplicatorWiring, "Not initialized").flush();
        Objects.requireNonNull(this.eventSignatureValidatorWiring, "Not initialized").flush();
        Objects.requireNonNull(this.orphanBufferWiring, "Not initialized").flush();
    }

    public void destroy() {
        throw new UnsupportedOperationException("Shutdown mechanism not implemented yet");
    }
}

