/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server;

import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import javax.net.ssl.KeyManager;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public abstract class ConnectorServer {
    private static final String IMPL_NAME = "org.identityconnectors.framework.server.impl.ConnectorServerImpl";
    private int _port = 0;
    private int _maxConnections = 300;
    private String _keyHash;
    private int _minWorkers = 10;
    private int _maxWorkers = 100;
    private InetAddress _ifAddress = null;
    private boolean _useSSL = false;
    private List<URL> _bundleURLs = null;
    private ClassLoader bundleParentClassLoader;
    private List<KeyManager> _keyManagers = CollectionUtil.newReadOnlyList((Object[])new KeyManager[0]);

    public static ConnectorServer newInstance() {
        try {
            Class<?> clazz = Class.forName(IMPL_NAME);
            return (ConnectorServer)clazz.newInstance();
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private void assertNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("Operation cannot be performed while server is running");
        }
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this.assertNotStarted();
        this._port = port;
    }

    public int getMaxConnections() {
        return this._maxConnections;
    }

    public void setMaxConnections(int max) {
        this.assertNotStarted();
        this._maxConnections = max;
    }

    public int getMaxWorkers() {
        return this._maxWorkers;
    }

    public void setMaxWorkers(int maxWorkers) {
        this.assertNotStarted();
        this._maxWorkers = maxWorkers;
    }

    public int getMinWorkers() {
        return this._minWorkers;
    }

    public void setMinWorkers(int minWorkers) {
        this.assertNotStarted();
        this._minWorkers = minWorkers;
    }

    public InetAddress getIfAddress() {
        return this._ifAddress;
    }

    public void setIfAddress(InetAddress addr) {
        this.assertNotStarted();
        this._ifAddress = addr;
    }

    public boolean getUseSSL() {
        return this._useSSL;
    }

    public void setUseSSL(boolean ssl) {
        this.assertNotStarted();
        this._useSSL = ssl;
    }

    public String getKeyHash() {
        return this._keyHash;
    }

    public void setKeyHash(String hash) {
        this.assertNotStarted();
        this._keyHash = hash;
    }

    public List<KeyManager> getKeyManagers() {
        return this._keyManagers;
    }

    public void setKeyManagers(List<KeyManager> keyManagers) {
        this.assertNotStarted();
        this._keyManagers = CollectionUtil.newReadOnlyList(keyManagers);
    }

    public List<URL> getBundleURLs() {
        return this._bundleURLs;
    }

    public void setBundleURLs(List<URL> urls) {
        this.assertNotStarted();
        this._bundleURLs = CollectionUtil.newReadOnlyList(urls);
    }

    public ClassLoader getBundleParentClassLoader() {
        return this.bundleParentClassLoader;
    }

    public void setBundleParentClassLoader(ClassLoader bundleParentClassLoader) {
        this.bundleParentClassLoader = bundleParentClassLoader;
    }

    public abstract void start();

    public abstract void stop();

    public abstract boolean isStarted();

    public abstract void awaitStop() throws InterruptedException;
}

