/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.networkadmin.impl.handlers;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.service.addressbook.AddressBookHelper;
import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.file.ReadableUpgradeFileStore;
import com.hedera.node.app.service.networkadmin.ReadableFreezeStore;
import com.hedera.node.app.service.networkadmin.impl.handlers.UnzipUtility;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.hedera.node.config.data.NetworkAdminConfig;
import com.hedera.node.config.data.NodesConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.platformstate.ReadablePlatformStateStore;

public class ReadableFreezeUpgradeActions {
    private static final Logger log = LogManager.getLogger(ReadableFreezeUpgradeActions.class);
    private final NodesConfig nodesConfig;
    private final NetworkAdminConfig networkAdminConfig;
    private final ReadableFreezeStore freezeStore;
    private final ReadableUpgradeFileStore upgradeFileStore;
    private final FileID upgradeFileId;
    private final EntityIdFactory entityIdFactory;
    private final ReadableNodeStore nodeStore;
    private final ReadableStakingInfoStore stakingInfoStore;
    private final Executor executor;
    public static final String PREPARE_UPGRADE_DESC = "software";
    public static final String TELEMETRY_UPGRADE_DESC = "telemetry";
    public static final String MANUAL_REMEDIATION_ALERT = "Manual remediation may be necessary to avoid node ISS";
    public static final String NOW_FROZEN_MARKER = "now_frozen.mf";
    public static final String EXEC_IMMEDIATE_MARKER = "execute_immediate.mf";
    public static final String EXEC_TELEMETRY_MARKER = "execute_telemetry.mf";
    public static final String FREEZE_SCHEDULED_MARKER = "freeze_scheduled.mf";
    public static final String FREEZE_ABORTED_MARKER = "freeze_aborted.mf";
    public static final long UPGRADE_FILE_ID = 150L;
    public static final String MARK = "\u2713";

    public ReadableFreezeUpgradeActions(@NonNull Configuration configuration, @NonNull ReadableFreezeStore freezeStore, @NonNull Executor executor, @NonNull ReadableUpgradeFileStore upgradeFileStore, @NonNull ReadableNodeStore nodeStore, @NonNull ReadableStakingInfoStore stakingInfoStore, @NonNull EntityIdFactory entityIdFactory) {
        Objects.requireNonNull(configuration, "configuration is required for freeze upgrade actions");
        Objects.requireNonNull(freezeStore, "Freeze store is required for freeze upgrade actions");
        Objects.requireNonNull(executor, "Executor is required for freeze upgrade actions");
        Objects.requireNonNull(upgradeFileStore, "Upgrade file store is required for freeze upgrade actions");
        Objects.requireNonNull(nodeStore, "Node store is required for freeze upgrade actions");
        Objects.requireNonNull(stakingInfoStore, "Staking info store is required for freeze upgrade actions");
        this.networkAdminConfig = (NetworkAdminConfig)configuration.getConfigData(NetworkAdminConfig.class);
        this.nodesConfig = (NodesConfig)configuration.getConfigData(NodesConfig.class);
        this.freezeStore = freezeStore;
        this.executor = executor;
        this.upgradeFileStore = upgradeFileStore;
        this.nodeStore = nodeStore;
        this.stakingInfoStore = stakingInfoStore;
        this.entityIdFactory = entityIdFactory;
        this.upgradeFileId = entityIdFactory.newFileId(150L);
    }

    public void externalizeFreezeIfUpgradePending() {
        log.info("Externalizing freeze if upgrade pending, updateFileHash: {}", (Object)this.freezeStore.updateFileHash());
        if (this.freezeStore.updateFileHash() != null) {
            this.writeCheckMarker(NOW_FROZEN_MARKER);
        }
    }

    protected void writeMarker(@NonNull String file, @Nullable Timestamp now) {
        Objects.requireNonNull(file);
        Path artifactsDirPath = com.swirlds.common.io.utility.FileUtils.getAbsolutePath((String)this.networkAdminConfig.upgradeArtifactsPath());
        Path filePath = artifactsDirPath.resolve(file);
        try {
            if (!artifactsDirPath.toFile().exists()) {
                Files.createDirectories(artifactsDirPath, new FileAttribute[0]);
            }
            String contents = now == null ? MARK : String.valueOf(now.seconds());
            Files.writeString(filePath, (CharSequence)contents, new OpenOption[0]);
            log.info("Wrote marker {}", (Object)filePath);
        }
        catch (IOException e) {
            log.error("Failed to write NMT marker {}", (Object)filePath, (Object)e);
            log.error(MANUAL_REMEDIATION_ALERT);
        }
    }

    protected void writeCheckMarker(@NonNull String file) {
        Objects.requireNonNull(file);
        this.writeMarker(file, null);
    }

    protected void writeSecondMarker(@NonNull String file, @Nullable Timestamp now) {
        Objects.requireNonNull(file);
        this.writeMarker(file, now);
    }

    public void catchUpOnMissedSideEffects(@NonNull ReadablePlatformStateStore platformStateStore) {
        this.catchUpOnMissedFreezeScheduling(platformStateStore);
        this.catchUpOnMissedUpgradePrep();
    }

    public boolean isPreparedFileHashValidGiven(byte[] curSpecialFilesHash, byte[] hashFromTxnBody) {
        return Arrays.equals(curSpecialFilesHash, hashFromTxnBody);
    }

    public CompletableFuture<Void> extractTelemetryUpgrade(@NonNull Bytes archiveData, @Nullable Timestamp now) {
        Objects.requireNonNull(archiveData);
        return this.extractNow(archiveData, TELEMETRY_UPGRADE_DESC, EXEC_TELEMETRY_MARKER, now);
    }

    public CompletableFuture<Void> extractSoftwareUpgrade(@NonNull Bytes archiveData) {
        Objects.requireNonNull(archiveData);
        return this.extractNow(archiveData, PREPARE_UPGRADE_DESC, EXEC_IMMEDIATE_MARKER, null);
    }

    public boolean isFreezeScheduled(@NonNull ReadablePlatformStateStore platformStateStore) {
        Objects.requireNonNull(platformStateStore, "Cannot check freeze schedule without access to the platform state");
        Instant freezeTime = platformStateStore.getFreezeTime();
        return freezeTime != null && !freezeTime.equals(platformStateStore.getLastFrozenTime());
    }

    private CompletableFuture<Void> extractNow(@NonNull Bytes archiveData, @NonNull String desc, @NonNull String marker, @Nullable Timestamp now) {
        Objects.requireNonNull(archiveData);
        Objects.requireNonNull(desc);
        Objects.requireNonNull(marker);
        Path artifactsLoc = com.swirlds.common.io.utility.FileUtils.getAbsolutePath((String)this.networkAdminConfig.upgradeArtifactsPath());
        Path keysLoc = com.swirlds.common.io.utility.FileUtils.getAbsolutePath((String)this.networkAdminConfig.keysPath());
        Objects.requireNonNull(artifactsLoc);
        Objects.requireNonNull(keysLoc);
        long size = archiveData.length();
        log.info("About to unzip {} bytes for {} update into {}", (Object)size, (Object)desc, (Object)artifactsLoc);
        List<ActiveNode> activeNodes = desc.equals(PREPARE_UPGRADE_DESC) ? this.allActiveNodes() : null;
        return CompletableFuture.runAsync(() -> this.extractAndReplaceArtifacts(artifactsLoc, keysLoc, archiveData, size, desc, marker, now, activeNodes), this.executor);
    }

    private List<ActiveNode> allActiveNodes() {
        return this.nodeStore.keys().stream().mapToLong(EntityNumber::number).sorted().mapToObj(arg_0 -> ((ReadableNodeStore)this.nodeStore).get(arg_0)).filter(node -> node != null && !node.deleted()).map(node -> new ActiveNode((Node)node, this.stakingInfoStore.get(node.nodeId()))).toList();
    }

    private void extractAndReplaceArtifacts(@NonNull Path artifactsLoc, @NonNull Path keysLoc, @NonNull Bytes archiveData, long size, @NonNull String desc, @NonNull String marker, @Nullable Timestamp now, @Nullable List<ActiveNode> nodes) {
        try {
            File artifactsDir = artifactsLoc.toFile();
            File keysDir = keysLoc.toFile();
            if (!FileUtils.isDirectory((File)artifactsDir, (LinkOption[])new LinkOption[0])) {
                FileUtils.forceMkdir((File)artifactsDir);
            }
            FileUtils.cleanDirectory((File)artifactsDir);
            if (!FileUtils.isDirectory((File)keysDir, (LinkOption[])new LinkOption[0])) {
                FileUtils.forceMkdir((File)keysDir);
            }
            FileUtils.cleanDirectory((File)keysDir);
            UnzipUtility.unzip(archiveData.toByteArray(), artifactsLoc);
            log.info("Finished unzipping {} bytes for {} update into {}", (Object)size, (Object)desc, (Object)artifactsLoc);
            if (nodes != null && this.nodesConfig.enableDAB() && this.networkAdminConfig.exportCandidateRoster()) {
                this.generateConfigPem(artifactsLoc, keysLoc, nodes);
                log.info("Finished generating config.txt and pem files into {}", (Object)artifactsLoc);
            }
            this.writeSecondMarker(marker, now);
        }
        catch (Exception t) {
            log.error("Failed to unzip archive for NMT consumption", (Throwable)t);
            log.error(MANUAL_REMEDIATION_ALERT);
        }
    }

    private void generateConfigPem(@NonNull Path artifactsLoc, @NonNull Path keysLoc, @NonNull List<ActiveNode> activeNodes) {
        Objects.requireNonNull(artifactsLoc, "Cannot generate config.txt without a valid artifacts location");
        Objects.requireNonNull(keysLoc, "Cannot generate pem files without a valid keys location");
        Objects.requireNonNull(activeNodes, "Cannot generate config.txt without a valid list of active nodes");
        Path configTxt = artifactsLoc.resolve("config.txt");
        if (activeNodes.isEmpty()) {
            log.error("Node state is empty, which should be impossible");
            return;
        }
        try (FileWriter fw = new FileWriter(configTxt.toFile());
             BufferedWriter bw = new BufferedWriter(fw);){
            activeNodes.forEach(node -> this.writeConfigLineAndPem((ActiveNode)node, bw, keysLoc));
            bw.flush();
        }
        catch (IOException e) {
            log.error("Failed to generate {} with exception : {}", (Object)configTxt, (Object)e);
        }
    }

    private void writeConfigLineAndPem(@NonNull ActiveNode activeNode, @NonNull BufferedWriter bw, @NonNull Path keysLoc) {
        List gossipEndpoints;
        Objects.requireNonNull(activeNode);
        Objects.requireNonNull(bw);
        Objects.requireNonNull(keysLoc);
        StringBuilder line = new StringBuilder();
        long weight = 0L;
        Node node = activeNode.node();
        String name = "node" + (node.nodeId() + 1L);
        String alias = com.swirlds.common.utility.CommonUtils.nameToAlias((String)name);
        Path pemFile = keysLoc.resolve("s-public-" + alias + ".pem");
        boolean INT = false;
        boolean EXT = true;
        StakingNodeInfo stakingNodeInfo = activeNode.stakingInfo();
        if (stakingNodeInfo != null) {
            weight = stakingNodeInfo.stake();
        }
        if ((gossipEndpoints = node.gossipEndpoint()).size() > 1) {
            line.append("address, ").append(node.nodeId()).append(", ").append(node.nodeId()).append(", ").append(name).append(", ").append(weight).append(", ").append(this.hostNameFor((ServiceEndpoint)gossipEndpoints.get(0))).append(", ").append(((ServiceEndpoint)gossipEndpoints.get(0)).port()).append(", ").append(this.hostNameFor((ServiceEndpoint)gossipEndpoints.get(1))).append(", ").append(((ServiceEndpoint)gossipEndpoints.get(1)).port()).append(", ").append(node.accountId().shardNum() + "." + node.accountId().realmNum() + "." + node.accountId().accountNum()).append("\n");
            try {
                bw.write(line.toString());
            }
            catch (IOException e) {
                log.error("Failed to write line {} with exception : {}", (Object)line, (Object)e);
            }
            try {
                AddressBookHelper.writeCertificatePemFile((Path)pemFile, (byte[])node.gossipCaCertificate().toByteArray());
            }
            catch (IOException e) {
                log.error("Failed to write to {} with exception : {}", (Object)pemFile, (Object)e);
            }
        } else {
            log.error("Node has {} gossip endpoints, expected greater than 1", (Object)gossipEndpoints.size());
        }
    }

    private String hostNameFor(@NonNull ServiceEndpoint endpoint) {
        return endpoint.ipAddressV4().length() == 4L ? this.ipV4AddressFromOctets(endpoint.ipAddressV4()) : endpoint.domainName();
    }

    private String ipV4AddressFromOctets(@NonNull Bytes encoded) {
        return (encoded.getByte(0L) & 0xFF) + "." + (encoded.getByte(1L) & 0xFF) + "." + (encoded.getByte(2L) & 0xFF) + "." + (encoded.getByte(3L) & 0xFF);
    }

    private void catchUpOnMissedFreezeScheduling(@NonNull ReadablePlatformStateStore platformState) {
        boolean isUpgradePrepared;
        boolean bl = isUpgradePrepared = this.freezeStore.updateFileHash() != null;
        if (this.isFreezeScheduled(platformState) && isUpgradePrepared) {
            Instant freezeTime = Objects.requireNonNull(platformState.getFreezeTime());
            this.writeMarker(FREEZE_SCHEDULED_MARKER, Timestamp.newBuilder().nanos(freezeTime.getNano()).seconds(freezeTime.getEpochSecond()).build());
        }
    }

    private void catchUpOnMissedUpgradePrep() {
        if (this.freezeStore.updateFileHash() == null) {
            return;
        }
        long shard = this.upgradeFileId.shardNum();
        long realm = this.upgradeFileId.realmNum();
        try {
            Bytes curSpecialFileContents = this.upgradeFileStore.getFull(this.upgradeFileId);
            if (!this.isPreparedFileHashValidGiven(CommonUtils.noThrowSha384HashOf((byte[])curSpecialFileContents.toByteArray()), this.freezeStore.updateFileHash().toByteArray())) {
                log.error("Cannot redo NMT upgrade prep, file {}.{}.{} changed since FREEZE_UPGRADE", (Object)shard, (Object)realm, (Object)this.upgradeFileId.fileNum());
                log.error(MANUAL_REMEDIATION_ALERT);
                return;
            }
            this.extractSoftwareUpgrade(curSpecialFileContents).join();
        }
        catch (IOException e) {
            log.error("Cannot redo NMT upgrade prep, file {}.{}.{} changed since FREEZE_UPGRADE", (Object)shard, (Object)realm, (Object)this.upgradeFileId.fileNum(), (Object)e);
            log.error(MANUAL_REMEDIATION_ALERT);
        }
    }

    private record ActiveNode(@NonNull Node node, @Nullable StakingNodeInfo stakingInfo) {
    }
}

