/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.state.signed;

import com.hedera.hapi.platform.state.NodeIdSignaturePair;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.swirlds.common.FastCopyable;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hiero.base.crypto.Signature;
import org.hiero.base.crypto.SignatureType;
import org.hiero.consensus.model.node.NodeId;

public class SigSet
implements FastCopyable,
Iterable<NodeId> {
    public static final int MAX_SIGNATURE_COUNT = 1024;
    private final Map<NodeId, Signature> signatures = new HashMap<NodeId, Signature>();

    public SigSet() {
    }

    private SigSet(SigSet that) {
        this.signatures.putAll(that.signatures);
    }

    public void addSignature(@NonNull NodeId nodeId, @NonNull Signature signature) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        Objects.requireNonNull(signature, "signature must not be null");
        this.signatures.put(nodeId, signature);
    }

    public void removeSignature(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        this.signatures.remove(nodeId);
    }

    @Nullable
    public Signature getSignature(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        return this.signatures.get(nodeId);
    }

    public boolean hasSignature(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        return this.signatures.containsKey(nodeId);
    }

    @Override
    @NonNull
    public Iterator<NodeId> iterator() {
        final Iterator<NodeId> iterator = this.signatures.keySet().iterator();
        return new Iterator<NodeId>(this){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public NodeId next() {
                return (NodeId)iterator.next();
            }
        };
    }

    @NonNull
    public List<NodeId> getSigningNodes() {
        return new ArrayList<NodeId>(this.signatures.keySet());
    }

    public int size() {
        return this.signatures.size();
    }

    @NonNull
    public SigSet copy() {
        return new SigSet(this);
    }

    public void serialize(@NonNull WritableStreamingData out) throws IOException {
        List sortedIds = this.getSigningNodes().stream().sorted().toList();
        ArrayList<NodeIdSignaturePair> signaturePairs = new ArrayList<NodeIdSignaturePair>(sortedIds.size());
        for (NodeId nodeId : sortedIds) {
            Signature signature = this.signatures.get(nodeId);
            Bytes signatureBytes = signature.getBytes();
            signaturePairs.add(new NodeIdSignaturePair(nodeId.id(), signature.getType().ordinal(), signatureBytes));
        }
        com.hedera.hapi.platform.state.SigSet sigSet = new com.hedera.hapi.platform.state.SigSet(signaturePairs);
        out.writeVarInt(com.hedera.hapi.platform.state.SigSet.PROTOBUF.measureRecord((Object)sigSet), false);
        com.hedera.hapi.platform.state.SigSet.PROTOBUF.write((Object)sigSet, (WritableSequentialData)out);
    }

    public void deserialize(@NonNull ReadableStreamingData in) throws IOException, ParseException {
        this.signatures.clear();
        long length = in.readVarInt(false);
        long limitBefore = in.limit();
        in.limit(in.position() + length);
        com.hedera.hapi.platform.state.SigSet sigSet = (com.hedera.hapi.platform.state.SigSet)com.hedera.hapi.platform.state.SigSet.PROTOBUF.parse((ReadableSequentialData)in);
        in.limit(limitBefore);
        List nodeIdSignaturePairs = sigSet.nodeIdSignaturePairs();
        if (nodeIdSignaturePairs.size() > 1024) {
            throw new IOException("Signature count of " + this.signatures.size() + " exceeds maximum of 1024");
        }
        for (NodeIdSignaturePair nodeIdSignaturePair : nodeIdSignaturePairs) {
            this.signatures.put(NodeId.of((long)nodeIdSignaturePair.nodeId()), new Signature(SignatureType.from((int)nodeIdSignaturePair.signatureType(), (SignatureType)SignatureType.RSA), nodeIdSignaturePair.signatureBytes()));
        }
    }
}

