/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.hashgraph.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hiero.base.Clearable;
import org.hiero.consensus.hashgraph.impl.consensus.CandidateWitness;
import org.hiero.consensus.hashgraph.impl.consensus.DeGen;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.LinkedEvent;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;

public class EventImpl
extends LinkedEvent<EventImpl>
implements Clearable {
    private long roundReceived = -1L;
    private boolean isWitness;
    private boolean isFamous;
    private boolean isFameDecided;
    private boolean isJudge;
    private boolean isConsensus;
    private Instant preliminaryConsensusTimestamp;
    private EventImpl[] lastSee;
    private EventImpl[] stronglySeeP;
    private EventImpl firstSelfWitnessS;
    private EventImpl firstWitnessS;
    private int mark = 0;
    private List<Instant> recTimes;
    private long roundCreated = -1L;
    private boolean[] votes;
    private int cGen = 0;
    private int deGen = 0;

    public EventImpl(@NonNull PlatformEvent platformEvent, @NonNull List<EventImpl> allParents) {
        super(platformEvent, allParents);
    }

    @NonNull
    public PlatformEvent getBaseEvent() {
        return this.getPlatformEvent();
    }

    public long getRoundReceived() {
        return this.roundReceived;
    }

    public void setRoundReceived(long roundReceived) {
        this.roundReceived = roundReceived;
    }

    public boolean isWitness() {
        return this.isWitness;
    }

    public void setWitness(boolean witness) {
        this.isWitness = witness;
    }

    public boolean isFamous() {
        return this.isFamous;
    }

    public void setFamous(boolean famous) {
        this.isFamous = famous;
    }

    public boolean isFameDecided() {
        return this.isFameDecided;
    }

    public void setFameDecided(boolean fameDecided) {
        this.isFameDecided = fameDecided;
    }

    public boolean isJudge() {
        return this.isJudge;
    }

    public void setJudgeTrue() {
        this.isJudge = true;
    }

    public boolean isConsensus() {
        return this.isConsensus;
    }

    public void setConsensus(boolean consensus) {
        this.isConsensus = consensus;
    }

    @Nullable
    public Instant getPreliminaryConsensusTimestamp() {
        return this.preliminaryConsensusTimestamp;
    }

    public void setPreliminaryConsensusTimestamp(@Nullable Instant preliminaryConsensusTimestamp) {
        this.preliminaryConsensusTimestamp = preliminaryConsensusTimestamp;
    }

    @Nullable
    public EventImpl getLastSee(int m) {
        return this.lastSee[m];
    }

    public void setLastSee(int m, @Nullable EventImpl event) {
        this.lastSee[m] = event;
    }

    public void initLastSee(int n) {
        this.lastSee = n == 0 ? null : new EventImpl[n];
    }

    public int sizeLastSee() {
        return this.lastSee == null ? 0 : this.lastSee.length;
    }

    @Nullable
    public EventImpl getStronglySeeP(int m) {
        return this.stronglySeeP[m];
    }

    public EventImpl[] getStronglySeeP() {
        return this.stronglySeeP;
    }

    public void setStronglySeeP(int m, @Nullable EventImpl event) {
        this.stronglySeeP[m] = event;
    }

    public void initStronglySeeP(int n) {
        this.stronglySeeP = n == 0 ? null : new EventImpl[n];
    }

    public int sizeStronglySeeP() {
        return this.stronglySeeP == null ? 0 : this.stronglySeeP.length;
    }

    @Nullable
    public EventImpl getFirstSelfWitnessS() {
        return this.firstSelfWitnessS;
    }

    public void setFirstSelfWitnessS(@Nullable EventImpl firstSelfWitnessS) {
        this.firstSelfWitnessS = firstSelfWitnessS;
    }

    @Nullable
    public EventImpl getFirstWitnessS() {
        return this.firstWitnessS;
    }

    public void setFirstWitnessS(@Nullable EventImpl firstWitnessS) {
        this.firstWitnessS = firstWitnessS;
    }

    public int getMark() {
        return this.mark;
    }

    public void setMark(int mark) {
        this.mark = mark;
    }

    @Nullable
    public List<Instant> getRecTimes() {
        return this.recTimes;
    }

    public void setRecTimes(@Nullable List<Instant> recTimes) {
        this.recTimes = recTimes;
    }

    public long getRoundCreated() {
        return this.roundCreated;
    }

    public void setRoundCreated(long roundCreated) {
        this.roundCreated = roundCreated;
    }

    public void initVoting(int numWitnesses) {
        if (this.votes == null || this.votes.length < numWitnesses) {
            this.votes = new boolean[numWitnesses];
            return;
        }
        Arrays.fill(this.votes, false);
    }

    public boolean getVote(@NonNull CandidateWitness witness) {
        return this.votes != null && this.votes.length > witness.getElectionIndex() && this.votes[witness.getElectionIndex()];
    }

    public boolean getVote(int electionIndex) {
        return this.votes != null && this.votes.length > electionIndex && this.votes[electionIndex];
    }

    public int getVotesSize() {
        return this.votes == null ? 0 : this.votes.length;
    }

    public void setVote(@NonNull CandidateWitness witness, boolean vote) {
        this.votes[witness.getElectionIndex()] = vote;
    }

    public void clear() {
        super.clear();
        this.clearMetadata();
    }

    public void clearMetadata() {
        this.clearJudgeFlags();
        this.clearNonJudgeMetadata();
        DeGen.clearDeGen(this);
    }

    private void clearJudgeFlags() {
        this.setWitness(false);
        this.setFamous(false);
        this.setFameDecided(false);
        this.isJudge = false;
    }

    private void clearNonJudgeMetadata() {
        this.initLastSee(0);
        this.initStronglySeeP(0);
        this.setFirstSelfWitnessS(null);
        this.setFirstWitnessS(null);
        this.setRecTimes(null);
    }

    public boolean hasSelfParent() {
        return this.getPlatformEvent().getSelfParent() != null;
    }

    public Instant getTimeCreated() {
        return this.getPlatformEvent().getTimeCreated();
    }

    public Instant getConsensusTimestamp() {
        return this.getPlatformEvent().getConsensusTimestamp();
    }

    public long getNGen() {
        return this.getPlatformEvent().getNGen();
    }

    public long getBirthRound() {
        return this.getPlatformEvent().getBirthRound();
    }

    @NonNull
    public NodeId getCreatorId() {
        return this.getPlatformEvent().getCreatorId();
    }

    public int getCGen() {
        return this.cGen;
    }

    public void setCGen(int cGen) {
        this.cGen = cGen;
    }

    public int getDeGen() {
        return this.deGen;
    }

    public void setDeGen(int deGen) {
        this.deGen = deGen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EventImpl event = (EventImpl)((Object)o);
        return Objects.equals(this.getPlatformEvent(), event.getPlatformEvent()) && this.roundReceived == event.roundReceived;
    }

    public int hashCode() {
        return Objects.hash(this.getPlatformEvent(), this.roundReceived);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.getPlatformEvent().getDescriptor().shortString(sb);
        List allParents = this.getPlatformEvent().getAllParents();
        for (EventDescriptorWrapper parent : allParents) {
            parent.shortString(sb);
        }
        return sb.toString();
    }

    public String shortString() {
        return this.getPlatformEvent().getDescriptor().shortString();
    }
}

