/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.OpsDurationCounter;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.hevm.OpsDurationSchedule;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import com.hedera.node.app.service.contract.impl.state.EvmFrameStateFactory;
import com.hedera.node.app.service.contract.impl.state.HederaEvmAccount;
import com.hedera.node.app.service.contract.impl.state.PendingCreation;
import com.hedera.node.app.service.contract.impl.state.TxStorageUsage;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.ResourceExhaustedException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public class ProxyWorldUpdater
implements HederaWorldUpdater {
    private static final String CANNOT_CREATE = "Cannot create ";
    @Nullable
    private final WorldUpdater parent;
    protected final EvmFrameStateFactory evmFrameStateFactory;
    protected final EvmFrameState evmFrameState;
    protected final HederaWorldUpdater.Enhancement enhancement;
    @Nullable
    protected PendingCreation pendingCreation;
    protected boolean reverted = false;
    protected boolean contractMustBePresent = true;

    public ProxyWorldUpdater(@NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull EvmFrameStateFactory evmFrameStateFactory, @Nullable WorldUpdater parent) {
        this.parent = parent;
        this.enhancement = Objects.requireNonNull(enhancement);
        this.evmFrameStateFactory = Objects.requireNonNull(evmFrameStateFactory);
        this.evmFrameState = (EvmFrameState)evmFrameStateFactory.get();
    }

    @Nullable
    public PendingCreation getPendingCreation() {
        return this.pendingCreation;
    }

    @Override
    @NonNull
    public HederaWorldUpdater.Enhancement enhancement() {
        return this.enhancement;
    }

    @Override
    @Nullable
    public HederaEvmAccount getHederaAccount(@NonNull AccountID accountId) {
        Address address;
        if (accountId.hasAlias()) {
            address = ConversionUtils.pbjToBesuAddress(accountId.aliasOrThrow());
        } else {
            try {
                address = this.evmFrameState.getAddress(accountId);
            }
            catch (IllegalArgumentException ignore) {
                return null;
            }
        }
        return address == null ? null : (HederaEvmAccount)this.get(address);
    }

    @Override
    public ContractID getHederaContractId(@NonNull Address address) {
        Objects.requireNonNull(address);
        HederaEvmAccount account = (HederaEvmAccount)this.get(address);
        if (account == null) {
            if (this.pendingCreation != null && this.pendingCreation.address().equals((Object)address)) {
                return this.entityIdFactory().newContractId(this.pendingCreation.number());
            }
            if (!this.contractMustBePresent) {
                return ConversionUtils.isLongZero(address) ? ConversionUtils.asNumberedContractId(this.entityIdFactory(), address) : ConversionUtils.asEvmContractId(this.entityIdFactory(), address);
            }
            throw new IllegalArgumentException("No contract pending or extant at " + String.valueOf(address));
        }
        return account.hederaContractId();
    }

    @Override
    @NonNull
    public Bytes entropy() {
        return ConversionUtils.pbjToTuweniBytes(this.enhancement.operations().entropy());
    }

    @Override
    @Nullable
    public HederaEvmAccount getHederaAccount(@NonNull ContractID contractId) {
        Address address;
        Objects.requireNonNull(contractId);
        contractId = this.enhancement.operations().shardAndRealmValidated(contractId);
        if (contractId.hasEvmAddress()) {
            address = ConversionUtils.pbjToBesuAddress(contractId.evmAddressOrThrow());
        } else {
            try {
                address = this.evmFrameState.getAddress(contractId.contractNumOrElse(Long.valueOf(0L)));
            }
            catch (IllegalArgumentException ignore) {
                return null;
            }
        }
        return address == null ? null : (HederaEvmAccount)this.get(address);
    }

    @Override
    public void collectGasFee(@NonNull AccountID payerId, long amount, boolean withNonceIncrement) {
        Objects.requireNonNull(payerId);
        this.enhancement.operations().collectGasFee(payerId, amount, withNonceIncrement);
    }

    @Override
    public void refundGasFee(@NonNull AccountID payerId, long amount) {
        Objects.requireNonNull(payerId);
        this.enhancement.operations().refundGasFee(payerId, amount);
    }

    @Override
    public Optional<ExceptionalHaltReason> tryTransfer(@NonNull Address from, @NonNull Address to, long amount, boolean delegateCall) {
        return this.evmFrameState.tryTransfer(from, to, amount, delegateCall);
    }

    @Override
    public Optional<ExceptionalHaltReason> tryLazyCreation(@NonNull Address recipient, @NonNull MessageFrame frame) {
        long gasCost = this.enhancement.operations().lazyCreationCostInGas(recipient);
        if (gasCost > frame.getRemainingGas()) {
            return Optional.of(ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Optional<ExceptionalHaltReason> maybeHaltReason = this.evmFrameState.tryLazyCreation(recipient);
        if (maybeHaltReason.isPresent()) {
            return maybeHaltReason;
        }
        frame.decrementRemainingGas(gasCost);
        OpsDurationCounter opsDurationCounter = FrameUtils.opsDurationCounter(frame);
        OpsDurationSchedule opsDurationSchedule = opsDurationCounter.schedule();
        long opsDurationCost = gasCost * opsDurationSchedule.accountLazyCreationOpsDurationMultiplier() / opsDurationSchedule.multipliersDenominator();
        opsDurationCounter.recordOpsDurationUnitsConsumed(opsDurationCost);
        return Optional.empty();
    }

    @Override
    public boolean isHollowAccount(@NonNull Address address) {
        return this.evmFrameState.isHollowAccount(address);
    }

    @Override
    public Address setupTopLevelCreate(@NonNull ContractCreateTransactionBody body) {
        this.setupPendingCreation(null, Objects.requireNonNull(body), null);
        return Objects.requireNonNull(this.pendingCreation).address();
    }

    @Override
    public void setupTopLevelLazyCreate(@NonNull Address alias) {
        this.setupPendingCreation(null, null, Objects.requireNonNull(alias));
    }

    @Override
    public void setupAliasedTopLevelCreate(@NonNull ContractCreateTransactionBody body, @NonNull Address alias) {
        this.setupPendingCreation(null, Objects.requireNonNull(body), Objects.requireNonNull(alias));
    }

    @Override
    public Address setupInternalCreate(@NonNull Address origin) {
        this.setupPendingCreation(origin, null, null);
        return Objects.requireNonNull(this.pendingCreation).address();
    }

    @Override
    public void setupInternalAliasedCreate(@NonNull Address origin, @NonNull Address alias) {
        this.setupPendingCreation(origin, null, Objects.requireNonNull(alias));
    }

    @Override
    public void finalizeHollowAccount(@NonNull Address address, @NonNull Address parent) {
        this.evmFrameState.finalizeHollowAccount(address);
        this.pendingCreation = null;
        this.enhancement.operations().externalizeHollowAccountMerge(this.getHederaContractId(address), ConversionUtils.aliasFrom(address));
    }

    @Override
    @NonNull
    public TxStorageUsage getTxStorageUsage() {
        throw new UnsupportedOperationException("Only root updater can summarize transaction storage usage");
    }

    @Override
    public Optional<ExceptionalHaltReason> tryTrackingSelfDestructBeneficiary(@NonNull Address deleted, @NonNull Address beneficiary, @NonNull MessageFrame frame) {
        return this.evmFrameState.tryTrackingSelfDestructBeneficiary(deleted, beneficiary, frame);
    }

    @Override
    public void trackSelfDestructBeneficiary(@NonNull Address deleted, @NonNull Address beneficiary, @NonNull MessageFrame frame) {
        this.evmFrameState.trackSelfDestructBeneficiary(deleted, beneficiary, frame);
    }

    @Nullable
    public Account get(@NonNull Address address) {
        return this.evmFrameState.getAccount(address);
    }

    public MutableAccount getAccount(@NonNull Address address) {
        return this.evmFrameState.getMutableAccount(address);
    }

    public MutableAccount createAccount(@NonNull Address address, long nonce, @NonNull Wei balance) {
        if (this.pendingCreation == null) {
            throw new IllegalStateException(CANNOT_CREATE + String.valueOf(address) + " without a pending creation");
        }
        long newEntityCount = this.evmFrameState.numBytecodesInState() + 1L;
        if (newEntityCount > this.enhancement.operations().contractCreationLimit() || newEntityCount > this.enhancement.operations().accountCreationLimit()) {
            throw new ResourceExhaustedException(ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
        }
        long number = this.getValidatedCreationNumber(address, balance, this.pendingCreation);
        if (this.pendingCreation.isHapiCreation()) {
            this.enhancement.operations().createContract(number, Objects.requireNonNull(this.pendingCreation.body()), this.pendingCreation.aliasIfApplicable());
        } else {
            this.enhancement.operations().createContract(number, this.pendingCreation.parentNumber(), this.pendingCreation.aliasIfApplicable());
        }
        return this.evmFrameState.getMutableAccount(this.pendingCreation.address());
    }

    public void deleteAccount(@NonNull Address address) {
        if (ConversionUtils.isLongZero(address)) {
            this.enhancement.operations().deleteUnaliasedContract(ConversionUtils.numberOfLongZero(address));
        } else {
            this.enhancement.operations().deleteAliasedContract(ConversionUtils.aliasFrom(address));
        }
    }

    public void revert() {
        this.enhancement.operations().revert();
        this.reverted = true;
    }

    @Override
    public void setContractNotRequired() {
        this.contractMustBePresent = false;
    }

    public void commit() {
        if (!this.reverted) {
            this.enhancement.operations().commit();
        }
    }

    @NonNull
    public Optional<WorldUpdater> parentUpdater() {
        return Optional.ofNullable(this.parent);
    }

    @NonNull
    public ProxyWorldUpdater updater() {
        this.enhancement.operations().begin();
        ProxyWorldUpdater child = new ProxyWorldUpdater(this.enhancement, this.evmFrameStateFactory, this);
        if (this.pendingCreation != null) {
            child.pendingCreation = this.pendingCreation;
        }
        child.contractMustBePresent = this.contractMustBePresent;
        return child;
    }

    @NonNull
    public Collection<? extends Account> getTouchedAccounts() {
        List<Long> modifiedNumbers = this.enhancement.operations().getModifiedAccountNumbers();
        ArrayList<Account> touched = new ArrayList<Account>();
        for (Long number : modifiedNumbers) {
            Address address = this.evmFrameState.getAddress(number);
            if (address == null) continue;
            touched.add(this.evmFrameState.getAccount(address));
        }
        return touched;
    }

    @NonNull
    public Collection<Address> getDeletedAccountAddresses() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public ExchangeRate currentExchangeRate() {
        return this.enhancement().systemOperations().currentExchangeRate();
    }

    private long getValidatedCreationNumber(@NonNull Address address, @NonNull Wei balance, @NonNull PendingCreation knownPendingCreation) {
        if (!balance.isZero()) {
            throw new IllegalStateException(CANNOT_CREATE + String.valueOf(address) + " with non-zero balance " + String.valueOf(balance));
        }
        Address pendingAddress = knownPendingCreation.address();
        if (!Objects.requireNonNull(address).equals((Object)pendingAddress)) {
            throw new IllegalStateException(CANNOT_CREATE + String.valueOf(address) + " with " + String.valueOf(pendingAddress) + " pending");
        }
        long pendingNumber = this.enhancement.operations().peekNextEntityNumber();
        if (pendingNumber != knownPendingCreation.number()) {
            throw new IllegalStateException(CANNOT_CREATE + String.valueOf(address) + " with number " + pendingNumber + " (" + knownPendingCreation.number() + ") pending");
        }
        return pendingNumber;
    }

    private void setupPendingCreation(@Nullable Address origin, @Nullable ContractCreateTransactionBody body, @Nullable Address alias) {
        long number = this.enhancement.operations().peekNextEntityNumber();
        this.pendingCreation = new PendingCreation(alias == null ? ConversionUtils.asLongZeroAddress(number) : alias, number, origin != null ? this.evmFrameState.getIdNumber(origin) : -1L, body);
    }
}

