/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TokenJsonCodec
implements JsonCodec<Token> {
    @NonNull
    public Token parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            TokenID temp_token_id = null;
            String temp_name = "";
            String temp_symbol = "";
            int temp_decimals = 0;
            long temp_total_supply = 0L;
            AccountID temp_treasury_account_id = null;
            Key temp_admin_key = null;
            Key temp_kyc_key = null;
            Key temp_freeze_key = null;
            Key temp_wipe_key = null;
            Key temp_supply_key = null;
            Key temp_fee_schedule_key = null;
            Key temp_pause_key = null;
            long temp_last_used_serial_number = 0L;
            boolean temp_deleted = false;
            TokenType temp_token_type = TokenType.fromProtobufOrdinal(0);
            TokenSupplyType temp_supply_type = TokenSupplyType.fromProtobufOrdinal(0);
            AccountID temp_auto_renew_account_id = null;
            long temp_auto_renew_seconds = 0L;
            long temp_expiration_second = 0L;
            String temp_memo = "";
            long temp_max_supply = 0L;
            boolean temp_paused = false;
            boolean temp_accounts_frozen_by_default = false;
            boolean temp_accounts_kyc_granted_by_default = false;
            List temp_custom_fees = Collections.emptyList();
            Bytes temp_metadata = Bytes.EMPTY;
            Key temp_metadata_key = null;
            block62: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "tokenId": {
                        temp_token_id = (TokenID)TokenID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block62;
                    }
                    case "name": {
                        temp_name = JsonTools.unescape((String)JsonTools.checkSize((String)"name", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block62;
                    }
                    case "symbol": {
                        temp_symbol = JsonTools.unescape((String)JsonTools.checkSize((String)"symbol", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block62;
                    }
                    case "decimals": {
                        temp_decimals = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block62;
                    }
                    case "totalSupply": {
                        temp_total_supply = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block62;
                    }
                    case "treasuryAccountId": {
                        temp_treasury_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block62;
                    }
                    case "adminKey": {
                        temp_admin_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block62;
                    }
                    case "kycKey": {
                        temp_kyc_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block62;
                    }
                    case "freezeKey": {
                        temp_freeze_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block62;
                    }
                    case "wipeKey": {
                        temp_wipe_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block62;
                    }
                    case "supplyKey": {
                        temp_supply_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block62;
                    }
                    case "feeScheduleKey": {
                        temp_fee_schedule_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block62;
                    }
                    case "pauseKey": {
                        temp_pause_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block62;
                    }
                    case "lastUsedSerialNumber": {
                        temp_last_used_serial_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block62;
                    }
                    case "deleted": {
                        temp_deleted = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block62;
                    }
                    case "tokenType": {
                        temp_token_type = TokenType.fromString(kvPair.value().STRING().getText());
                        continue block62;
                    }
                    case "supplyType": {
                        temp_supply_type = TokenSupplyType.fromString(kvPair.value().STRING().getText());
                        continue block62;
                    }
                    case "autoRenewAccountId": {
                        temp_auto_renew_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block62;
                    }
                    case "autoRenewSeconds": {
                        temp_auto_renew_seconds = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block62;
                    }
                    case "expirationSecond": {
                        temp_expiration_second = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block62;
                    }
                    case "memo": {
                        temp_memo = JsonTools.unescape((String)JsonTools.checkSize((String)"memo", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block62;
                    }
                    case "maxSupply": {
                        temp_max_supply = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block62;
                    }
                    case "paused": {
                        temp_paused = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block62;
                    }
                    case "accountsFrozenByDefault": {
                        temp_accounts_frozen_by_default = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block62;
                    }
                    case "accountsKycGrantedByDefault": {
                        temp_accounts_kyc_granted_by_default = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block62;
                    }
                    case "customFees": {
                        temp_custom_fees = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"custom_fees", (List)kvPair.value().arr().value(), (int)maxSize), CustomFee.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block62;
                    }
                    case "metadata": {
                        temp_metadata = Bytes.fromBase64((String)JsonTools.checkSize((String)"metadata", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block62;
                    }
                    case "metadataKey": {
                        temp_metadata_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block62;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new Token(temp_token_id, temp_name, temp_symbol, temp_decimals, temp_total_supply, temp_treasury_account_id, temp_admin_key, temp_kyc_key, temp_freeze_key, temp_wipe_key, temp_supply_key, temp_fee_schedule_key, temp_pause_key, temp_last_used_serial_number, temp_deleted, temp_token_type, temp_supply_type, temp_auto_renew_account_id, temp_auto_renew_seconds, temp_expiration_second, temp_memo, temp_max_supply, temp_paused, temp_accounts_frozen_by_default, temp_accounts_kyc_granted_by_default, (List<CustomFee>)temp_custom_fees, temp_metadata, temp_metadata_key);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull Token data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.tokenId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"tokenId", TokenID.JSON, (Object)data.tokenId()));
        }
        if (data.name() != null && !data.name().isEmpty()) {
            fieldLines.add(JsonTools.field((String)"name", (String)data.name()));
        }
        if (data.symbol() != null && !data.symbol().isEmpty()) {
            fieldLines.add(JsonTools.field((String)"symbol", (String)data.symbol()));
        }
        if (data.decimals() != 0) {
            fieldLines.add(JsonTools.field((String)"decimals", (int)data.decimals()));
        }
        if (data.totalSupply() != 0L) {
            fieldLines.add(JsonTools.field((String)"totalSupply", (long)data.totalSupply()));
        }
        if (data.treasuryAccountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"treasuryAccountId", AccountID.JSON, (Object)data.treasuryAccountId()));
        }
        if (data.adminKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"adminKey", Key.JSON, (Object)data.adminKey()));
        }
        if (data.kycKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"kycKey", Key.JSON, (Object)data.kycKey()));
        }
        if (data.freezeKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"freezeKey", Key.JSON, (Object)data.freezeKey()));
        }
        if (data.wipeKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"wipeKey", Key.JSON, (Object)data.wipeKey()));
        }
        if (data.supplyKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"supplyKey", Key.JSON, (Object)data.supplyKey()));
        }
        if (data.feeScheduleKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"feeScheduleKey", Key.JSON, (Object)data.feeScheduleKey()));
        }
        if (data.pauseKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"pauseKey", Key.JSON, (Object)data.pauseKey()));
        }
        if (data.lastUsedSerialNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"lastUsedSerialNumber", (long)data.lastUsedSerialNumber()));
        }
        if (data.deleted()) {
            fieldLines.add(JsonTools.field((String)"deleted", (boolean)data.deleted()));
        }
        if (data.tokenType() != TokenType.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"tokenType", (String)data.tokenType().protoName()));
        }
        if (data.supplyType() != TokenSupplyType.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"supplyType", (String)data.supplyType().protoName()));
        }
        if (data.autoRenewAccountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewAccountId", AccountID.JSON, (Object)data.autoRenewAccountId()));
        }
        if (data.autoRenewSeconds() != 0L) {
            fieldLines.add(JsonTools.field((String)"autoRenewSeconds", (long)data.autoRenewSeconds()));
        }
        if (data.expirationSecond() != 0L) {
            fieldLines.add(JsonTools.field((String)"expirationSecond", (long)data.expirationSecond()));
        }
        if (data.memo() != null && !data.memo().isEmpty()) {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.maxSupply() != 0L) {
            fieldLines.add(JsonTools.field((String)"maxSupply", (long)data.maxSupply()));
        }
        if (data.paused()) {
            fieldLines.add(JsonTools.field((String)"paused", (boolean)data.paused()));
        }
        if (data.accountsFrozenByDefault()) {
            fieldLines.add(JsonTools.field((String)"accountsFrozenByDefault", (boolean)data.accountsFrozenByDefault()));
        }
        if (data.accountsKycGrantedByDefault()) {
            fieldLines.add(JsonTools.field((String)"accountsKycGrantedByDefault", (boolean)data.accountsKycGrantedByDefault()));
        }
        if (!data.customFees().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"customFees", CustomFee.JSON, data.customFees()));
        }
        if (data.metadata() != Bytes.EMPTY && data.metadata() != null && data.metadata().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"metadata", (Bytes)data.metadata()));
        }
        if (data.metadataKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"metadataKey", Key.JSON, (Object)data.metadataKey()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

