/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.nexus;

import com.swirlds.platform.state.nexus.SignedStateNexus;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.consensus.state.signed.ReservedSignedState;

public class LockFreeStateNexus
implements SignedStateNexus {
    private final AtomicReference<ReservedSignedState> currentState = new AtomicReference();
    private final AtomicLong currentStateRound = new AtomicLong(-1L);

    @Override
    @Nullable
    public ReservedSignedState getState(@NonNull String reason) {
        ReservedSignedState state;
        do {
            if ((state = this.currentState.get()) == null) {
                return null;
            }
            ReservedSignedState newReservation = state.tryGetAndReserve(reason);
            if (newReservation == null) continue;
            return newReservation;
        } while (state != this.currentState.get());
        return null;
    }

    @Override
    public void setState(@Nullable ReservedSignedState reservedSignedState) {
        ReservedSignedState oldState = this.currentState.getAndSet(reservedSignedState);
        this.currentStateRound.set(reservedSignedState == null ? -1L : reservedSignedState.get().getRound());
        if (oldState != null) {
            oldState.close();
        }
    }

    @Override
    public long getRound() {
        return this.currentStateRound.get();
    }
}

