/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.uptime;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.base.time.Time;
import com.swirlds.base.units.TimeUnit;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.uptime.UptimeConfig;
import com.swirlds.platform.uptime.UptimeData;
import com.swirlds.platform.uptime.UptimeMetrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.hiero.base.CompareTo;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class UptimeTracker {
    private final NodeId selfId;
    private final Time time;
    private final UptimeMetrics uptimeMetrics;
    private final Duration degradationThreshold;
    private final AtomicReference<Instant> lastSelfEventTime = new AtomicReference();
    final UptimeData uptimeData;

    public UptimeTracker(@NonNull PlatformContext platformContext, @NonNull NodeId selfId) {
        this.selfId = Objects.requireNonNull(selfId, "selfId must not be null");
        this.time = Objects.requireNonNull(platformContext).getTime();
        this.degradationThreshold = ((UptimeConfig)platformContext.getConfiguration().getConfigData(UptimeConfig.class)).degradationThreshold();
        this.uptimeMetrics = new UptimeMetrics(platformContext.getMetrics(), this::isSelfDegraded);
        this.uptimeData = new UptimeData();
    }

    public boolean trackRound(@NonNull ConsensusRound round) {
        if (round.isEmpty()) {
            return false;
        }
        Instant start = this.time.now();
        this.addAndRemoveNodes(this.uptimeData, round.getConsensusRoster());
        HashMap<NodeId, ConsensusEvent> lastEventsInRoundByCreator = new HashMap<NodeId, ConsensusEvent>();
        boolean newSelfEvent = this.scanRound((Round)round, lastEventsInRoundByCreator);
        this.updateUptimeData(round.getConsensusRoster(), this.uptimeData, lastEventsInRoundByCreator, round.getRoundNum());
        this.reportUptime(round.getConsensusRoster(), this.uptimeData, round.getConsensusTimestamp(), round.getRoundNum());
        Instant end = this.time.now();
        Duration elapsed = Duration.between(start, end);
        this.uptimeMetrics.getUptimeComputationTimeMetric().update(TimeUnit.UNIT_NANOSECONDS.convertTo(elapsed.toNanos(), TimeUnit.UNIT_MICROSECONDS));
        return newSelfEvent;
    }

    private void addAndRemoveNodes(@NonNull UptimeData uptimeData, @NonNull Roster roster) {
        Set rosterNodes = roster.rosterEntries().stream().map(entry -> NodeId.of((long)entry.nodeId())).collect(Collectors.toSet());
        Set<NodeId> trackedNodes = uptimeData.getTrackedNodes();
        for (NodeId nodeId : rosterNodes) {
            if (trackedNodes.contains(nodeId)) continue;
            this.uptimeMetrics.addMetricsForNode(nodeId);
            uptimeData.addNode(nodeId);
        }
        for (NodeId nodeId : trackedNodes) {
            if (rosterNodes.contains(nodeId)) continue;
            this.uptimeMetrics.removeMetricsForNode(nodeId);
            uptimeData.removeNode(nodeId);
        }
    }

    public boolean isSelfDegraded() {
        Instant eventTime = this.lastSelfEventTime.get();
        if (eventTime == null) {
            return true;
        }
        Instant now = this.time.now();
        Duration durationSinceLastEvent = Duration.between(eventTime, now);
        return CompareTo.isGreaterThan((Comparable)durationSinceLastEvent, (Object)this.degradationThreshold);
    }

    private boolean scanRound(@NonNull Round round, @NonNull Map<NodeId, ConsensusEvent> lastEventsInRoundByCreator) {
        Instant lastSelfEventConsensusTimestamp;
        Instant previousSelfEventConsensusTimestamp = this.lastSelfEventTime.get();
        round.forEach(event -> lastEventsInRoundByCreator.put(event.getCreatorId(), (ConsensusEvent)event));
        ConsensusEvent lastSelfEvent = lastEventsInRoundByCreator.get(this.selfId);
        if (lastSelfEvent != null && !(lastSelfEventConsensusTimestamp = lastSelfEvent.getConsensusTimestamp()).equals(previousSelfEventConsensusTimestamp)) {
            this.lastSelfEventTime.set(lastSelfEventConsensusTimestamp);
            return true;
        }
        return false;
    }

    private void updateUptimeData(@NonNull Roster roster, @NonNull UptimeData uptimeData, @NonNull Map<NodeId, ConsensusEvent> lastEventsInRoundByCreator, long roundNum) {
        for (RosterEntry rosterEntry : roster.rosterEntries()) {
            ConsensusEvent lastEvent = lastEventsInRoundByCreator.get(NodeId.of((long)rosterEntry.nodeId()));
            if (lastEvent == null) continue;
            uptimeData.recordLastEvent(lastEvent, roundNum);
        }
    }

    private void reportUptime(@NonNull Roster roster, @NonNull UptimeData uptimeData, @NonNull Instant lastRoundEndTime, long currentRound) {
        long nonDegradedConsensusWeight = 0L;
        for (RosterEntry entry : roster.rosterEntries()) {
            long lastEventRound;
            Duration timeSinceLastConsensusEvent;
            NodeId id = NodeId.of((long)entry.nodeId());
            Instant lastConsensusEventTime = uptimeData.getLastEventTime(id);
            if (lastConsensusEventTime != null && CompareTo.isLessThanOrEqualTo((Comparable)(timeSinceLastConsensusEvent = Duration.between(lastConsensusEventTime, lastRoundEndTime)), (Object)this.degradationThreshold)) {
                nonDegradedConsensusWeight += entry.weight();
            }
            if ((lastEventRound = uptimeData.getLastEventRound(id)) == -1L) continue;
            this.uptimeMetrics.getRoundsSinceLastConsensusEventMetric(id).update((double)(currentRound - lastEventRound));
        }
        double fractionOfNetworkAlive = (double)nonDegradedConsensusWeight / (double)RosterUtils.computeTotalWeight((Roster)roster);
        this.uptimeMetrics.getHealthyNetworkFraction().update(fractionOfNetworkAlive);
    }
}

