/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.hashgraph.impl;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.event.FutureEventBuffer;
import org.hiero.consensus.event.FutureEventBufferingOption;
import org.hiero.consensus.hashgraph.FreezePeriodChecker;
import org.hiero.consensus.hashgraph.config.ConsensusConfig;
import org.hiero.consensus.hashgraph.impl.ConsensusEngine;
import org.hiero.consensus.hashgraph.impl.ConsensusEngineOutput;
import org.hiero.consensus.hashgraph.impl.EventImpl;
import org.hiero.consensus.hashgraph.impl.FreezeRoundController;
import org.hiero.consensus.hashgraph.impl.consensus.Consensus;
import org.hiero.consensus.hashgraph.impl.consensus.ConsensusImpl;
import org.hiero.consensus.hashgraph.impl.linking.ConsensusLinker;
import org.hiero.consensus.hashgraph.impl.linking.DefaultLinkerLogsAndMetrics;
import org.hiero.consensus.hashgraph.impl.metrics.ConsensusEngineMetrics;
import org.hiero.consensus.hashgraph.impl.metrics.ConsensusMetricsImpl;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.round.EventWindowUtils;

public class DefaultConsensusEngine
implements ConsensusEngine {
    private final ConsensusLinker linker;
    private final FutureEventBuffer futureEventBuffer;
    private final Consensus consensus;
    private final int roundsNonAncient;
    private final ConsensusEngineMetrics consensusEngineMetrics;
    private final FreezeRoundController freezeRoundController;

    public DefaultConsensusEngine(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull Roster roster, @NonNull NodeId selfId, @NonNull FreezePeriodChecker freezeChecker) {
        ConsensusMetricsImpl consensusMetrics = new ConsensusMetricsImpl(selfId, metrics);
        this.consensus = new ConsensusImpl(configuration, time, consensusMetrics, roster);
        this.linker = new ConsensusLinker(new DefaultLinkerLogsAndMetrics(metrics, time));
        this.futureEventBuffer = new FutureEventBuffer(metrics, FutureEventBufferingOption.PENDING_CONSENSUS_ROUND, "consensus");
        this.roundsNonAncient = ((ConsensusConfig)configuration.getConfigData(ConsensusConfig.class)).roundsNonAncient();
        this.consensusEngineMetrics = new ConsensusEngineMetrics(selfId, metrics);
        this.freezeRoundController = new FreezeRoundController(freezeChecker);
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus platformStatus) {
        this.consensus.setPcesMode(platformStatus == PlatformStatus.REPLAYING_EVENTS);
    }

    @Override
    @NonNull
    public ConsensusEngineOutput addEvent(@NonNull PlatformEvent event) {
        Objects.requireNonNull(event);
        if (this.freezeRoundController.isFrozen()) {
            return ConsensusEngineOutput.emptyInstance();
        }
        PlatformEvent consensusRelevantEvent = this.futureEventBuffer.addEvent(event);
        if (consensusRelevantEvent == null) {
            return ConsensusEngineOutput.emptyInstance();
        }
        LinkedList<PlatformEvent> eventsToAdd = new LinkedList<PlatformEvent>();
        ArrayList<PlatformEvent> preConsensusEvents = new ArrayList<PlatformEvent>();
        eventsToAdd.add(consensusRelevantEvent);
        ArrayList<ConsensusRound> allConsensusRounds = new ArrayList<ConsensusRound>();
        ArrayList<PlatformEvent> staleEvents = new ArrayList<PlatformEvent>();
        while (!eventsToAdd.isEmpty()) {
            PlatformEvent eventToAdd = (PlatformEvent)eventsToAdd.poll();
            EventImpl linkedEvent = this.linker.linkEvent(eventToAdd);
            if (linkedEvent == null) continue;
            boolean waitingForJudgesBeforeAdd = this.consensus.waitingForInitJudges();
            allConsensusRounds.addAll(this.consensus.addEvent(linkedEvent));
            boolean waitingForJudgesAfterAdd = this.consensus.waitingForInitJudges();
            this.consensusEngineMetrics.eventAdded(linkedEvent);
            if (waitingForJudgesAfterAdd) {
                return ConsensusEngineOutput.emptyInstance();
            }
            if (waitingForJudgesBeforeAdd) {
                allConsensusRounds.stream().map(ConsensusRound::getConsensusEvents).flatMap(Collection::stream).forEach(preConsensusEvents::add);
                this.consensus.getPreConsensusEvents().stream().map(EventImpl::getBaseEvent).forEach(preConsensusEvents::add);
            } else {
                preConsensusEvents.add(linkedEvent.getBaseEvent());
            }
            if (allConsensusRounds.isEmpty()) continue;
            EventWindow eventWindow = ((ConsensusRound)allConsensusRounds.getLast()).getEventWindow();
            List<EventImpl> ancientEvents = this.linker.setEventWindow(eventWindow);
            ancientEvents.stream().filter(e -> !e.isConsensus()).map(EventImpl::getBaseEvent).forEach(staleEvents::add);
            eventsToAdd.addAll(this.futureEventBuffer.updateEventWindow(eventWindow));
        }
        List<ConsensusRound> modifiedRounds = this.freezeRoundController.filterAndModify(allConsensusRounds);
        staleEvents.forEach(this.consensusEngineMetrics::reportStaleEvent);
        return new ConsensusEngineOutput(modifiedRounds, preConsensusEvents, staleEvents);
    }

    @Override
    public void outOfBandSnapshotUpdate(@NonNull ConsensusSnapshot snapshot) {
        EventWindow eventWindow = EventWindowUtils.createEventWindow((ConsensusSnapshot)snapshot, (int)this.roundsNonAncient);
        this.linker.clear();
        this.linker.setEventWindow(eventWindow);
        this.futureEventBuffer.clear();
        this.futureEventBuffer.updateEventWindow(eventWindow);
        this.consensus.loadSnapshot(snapshot);
    }
}

